/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.precompile.crud;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.precompile.common.PrecompiledCommon;
import org.fisco.bcos.web3j.precompile.crud.CRUD;
import org.fisco.bcos.web3j.precompile.crud.Condition;
import org.fisco.bcos.web3j.precompile.crud.Entry;
import org.fisco.bcos.web3j.precompile.crud.Table;
import org.fisco.bcos.web3j.precompile.crud.TableFactory;
import org.fisco.bcos.web3j.precompile.exception.PrecompileMessageException;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tx.gas.ContractGasProvider;
import org.fisco.bcos.web3j.tx.gas.StaticGasProvider;

public class CRUDService {
    private static BigInteger gasPrice = new BigInteger("300000000");
    private static BigInteger gasLimit = new BigInteger("300000000");
    private static final String TableFactoryPrecompileAddress = "0x0000000000000000000000000000000000001001";
    private static final String CRUDPrecompileAddress = "0x0000000000000000000000000000000000001002";
    private TableFactory tableFactory;
    private CRUD crud;

    public CRUDService(Web3j web3j, Credentials credentials) {
        StaticGasProvider contractGasProvider = new StaticGasProvider(gasPrice, gasLimit);
        this.tableFactory = TableFactory.load(TableFactoryPrecompileAddress, web3j, credentials, (ContractGasProvider)contractGasProvider);
        this.crud = CRUD.load(CRUDPrecompileAddress, web3j, credentials, (ContractGasProvider)contractGasProvider);
    }

    public int createTable(Table table) throws Exception {
        TransactionReceipt receipt = this.tableFactory.createTable(table.getTableName(), table.getKey(), table.getValueFields()).send();
        return PrecompiledCommon.handleTransactionReceiptForCRUD(receipt);
    }

    public int insert(Table table, Entry entry) throws Exception {
        if (table.getKey().length() > 255) {
            throw new PrecompileMessageException("The value of the table key exceeds the maximum limit(255).");
        }
        String entryJsonStr = ObjectMapperFactory.getObjectMapper().writeValueAsString(entry.getFields());
        TransactionReceipt receipt = this.crud.insert(table.getTableName(), table.getKey(), entryJsonStr, table.getOptional()).send();
        return PrecompiledCommon.handleTransactionReceiptForCRUD(receipt);
    }

    public int update(Table table, Entry entry, Condition condition) throws Exception {
        if (table.getKey().length() > 255) {
            throw new PrecompileMessageException("The value of the table key exceeds the maximum limit(255).");
        }
        String entryJsonStr = ObjectMapperFactory.getObjectMapper().writeValueAsString(entry.getFields());
        String conditionStr = ObjectMapperFactory.getObjectMapper().writeValueAsString(condition.getConditions());
        TransactionReceipt receipt = this.crud.update(table.getTableName(), table.getKey(), entryJsonStr, conditionStr, table.getOptional()).send();
        return PrecompiledCommon.handleTransactionReceiptForCRUD(receipt);
    }

    public int remove(Table table, Condition condition) throws Exception {
        if (table.getKey().length() > 255) {
            throw new PrecompileMessageException("The value of the table key exceeds the maximum limit(255).");
        }
        String conditionStr = ObjectMapperFactory.getObjectMapper().writeValueAsString(condition.getConditions());
        TransactionReceipt receipt = this.crud.remove(table.getTableName(), table.getKey(), conditionStr, table.getOptional()).send();
        return PrecompiledCommon.handleTransactionReceiptForCRUD(receipt);
    }

    public List<Map<String, String>> select(Table table, Condition condition) throws Exception {
        if (table.getKey().length() > 255) {
            throw new PrecompileMessageException("The value of the table key exceeds the maximum limit(255).");
        }
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        String conditionJsonStr = objectMapper.writeValueAsString(condition.getConditions());
        String resultStr = this.crud.select(table.getTableName(), table.getKey(), conditionJsonStr, table.getOptional()).send();
        List result = (List)objectMapper.readValue(resultStr, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, Map.class));
        return result;
    }

    public Table desc(String tableName) throws Exception {
        Table table = new Table();
        table.setTableName("_sys_tables_");
        table.setKey("_user_" + tableName);
        Condition condition = table.getCondition();
        List<Map<String, String>> userTable = this.select(table, condition);
        Table tableInfo = new Table();
        if (userTable.size() == 0) {
            throw new PrecompileMessageException("The table '" + tableName + "' does not exist.");
        }
        tableInfo.setTableName(tableName);
        tableInfo.setKey(userTable.get(0).get("key_field"));
        tableInfo.setValueFields(userTable.get(0).get("value_field"));
        return tableInfo;
    }
}

