/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.protocol.channel;

import java.io.IOException;
import org.fisco.bcos.channel.client.BcosResponseCallback;
import org.fisco.bcos.channel.dto.BcosRequest;
import org.fisco.bcos.channel.dto.BcosResponse;
import org.fisco.bcos.web3j.protocol.Service;
import org.fisco.bcos.web3j.protocol.channel.ResponseExcepiton;
import org.fisco.bcos.web3j.protocol.core.Request;
import org.fisco.bcos.web3j.protocol.core.Response;
import org.fisco.bcos.web3j.protocol.core.methods.response.Call;
import org.fisco.bcos.web3j.protocol.core.methods.response.SendTransaction;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.protocol.exceptions.MessageDecodingException;
import org.fisco.bcos.web3j.tx.exceptions.ContractCallException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelEthereumService
extends Service {
    private static Logger logger = LoggerFactory.getLogger(ChannelEthereumService.class);
    private org.fisco.bcos.channel.client.Service channelService;
    private Integer timeout = 0;

    public ChannelEthereumService(boolean includeRawResponses) {
        super(includeRawResponses);
    }

    public ChannelEthereumService() {
        super(false);
    }

    @Override
    public <T extends Response> T send(Request request, Class<T> responseType) throws IOException {
        byte[] payload = this.objectMapper.writeValueAsBytes((Object)request);
        BcosRequest bcosRequest = new BcosRequest();
        if (this.channelService.getOrgID() != null) {
            bcosRequest.setKeyID(this.channelService.getOrgID());
        } else {
            bcosRequest.setKeyID(this.channelService.getAgencyName());
        }
        bcosRequest.setBankNO("");
        bcosRequest.setContent(new String(payload));
        bcosRequest.setMessageID(this.channelService.newSeq());
        if (this.timeout != 0) {
            bcosRequest.setTimeout(this.timeout);
        }
        BcosResponse response = !request.isNeedTransCallback() ? this.channelService.sendEthereumMessage(bcosRequest) : this.channelService.sendEthereumMessage(bcosRequest, request.getTransactionSucCallback());
        logger.debug("bcos request, seq:{}, method:{}", (Object)bcosRequest.getMessageID(), (Object)request.getMethod());
        logger.debug("bcos request:{} {}", (Object)bcosRequest.getMessageID(), (Object)this.objectMapper.writeValueAsString((Object)request));
        logger.trace("bcos request:{} {}", (Object)bcosRequest.getMessageID(), (Object)this.objectMapper.writeValueAsString((Object)request));
        logger.trace("bcos response:{} {} {}", new Object[]{bcosRequest.getMessageID(), response.getErrorCode(), response.getContent()});
        if (response.getErrorCode() == 0) {
            try {
                Response t = (Response)this.objectMapper.readValue(response.getContent(), responseType);
                if (t.getError() != null) {
                    throw new IOException(t.getError().getMessage());
                }
                if (t.getResult() instanceof Call.CallOutput) {
                    Call.CallOutput callResult = (Call.CallOutput)t.getResult();
                    if ("0x16".equals(callResult.getStatus())) {
                        throw new ContractCallException("The execution of the contract rolled back.");
                    }
                    if ("0x1a".equals(callResult.getStatus())) {
                        throw new ContractCallException("The contract address is incorrect.");
                    }
                }
                return (T)t;
            }
            catch (ContractCallException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageDecodingException(response.getContent());
            }
        }
        throw new IOException(response.getErrorMessage());
    }

    @Override
    public void sendOnly(final Request request) throws IOException {
        byte[] payload = this.objectMapper.writeValueAsBytes((Object)request);
        final BcosRequest fiscoRequest = new BcosRequest();
        fiscoRequest.setKeyID(this.channelService.getOrgID());
        fiscoRequest.setBankNO("");
        fiscoRequest.setContent(new String(payload));
        fiscoRequest.setMessageID(this.channelService.newSeq());
        if (this.timeout != 0) {
            fiscoRequest.setTimeout(this.timeout);
        }
        if (!request.isNeedTransCallback()) {
            this.channelService.asyncSendEthereumMessage(fiscoRequest, new BcosResponseCallback(){

                @Override
                public void onResponse(BcosResponse response) {
                    try {
                        logger.debug("fisco Request:{} {}", (Object)fiscoRequest.getMessageID(), (Object)ChannelEthereumService.this.objectMapper.writeValueAsString((Object)request));
                        logger.debug("fisco Response:{} {} {}", new Object[]{fiscoRequest.getMessageID(), response.getErrorCode(), response.getContent()});
                        if (response.getErrorCode() != 0) {
                            logger.error("Error: " + response.getErrorCode());
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error: ", (Throwable)e);
                    }
                }
            });
        } else {
            this.channelService.asyncSendEthereumMessage(fiscoRequest, new BcosResponseCallback(){

                @Override
                public void onResponse(BcosResponse response) {
                    try {
                        logger.debug("fisco Request:{} {}", (Object)fiscoRequest.getMessageID(), (Object)ChannelEthereumService.this.objectMapper.writeValueAsString((Object)request));
                        logger.debug("fisco Response:{} {} {}", new Object[]{fiscoRequest.getMessageID(), response.getErrorCode(), response.getContent()});
                        if (response.getErrorCode() == 0) {
                            SendTransaction sendTransaction = (SendTransaction)ChannelEthereumService.this.objectMapper.readValue(response.getContent(), SendTransaction.class);
                            if (sendTransaction.getError() == null) {
                                logger.debug("sendRawTransaction response ok, transaction hash: {} ", sendTransaction.getResult());
                            } else {
                                final TransactionReceipt receipt = new TransactionReceipt();
                                receipt.setStatus(String.valueOf(sendTransaction.getError().getCode()));
                                receipt.setMessage(sendTransaction.getError().getMessage());
                                if (ChannelEthereumService.this.channelService.getThreadPool() == null) {
                                    ChannelEthereumService.this.channelService.onReceiveTransactionMessage(fiscoRequest.getMessageID(), receipt);
                                } else {
                                    ChannelEthereumService.this.channelService.getThreadPool().execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            ChannelEthereumService.this.channelService.onReceiveTransactionMessage(fiscoRequest.getMessageID(), receipt);
                                        }
                                    });
                                }
                                logger.debug(" sendRawTransaction response not ok, code: {}, message: {} ", (Object)receipt.getStatus(), (Object)receipt.getMessage());
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error: ", (Throwable)e);
                    }
                }
            }, request.getTransactionSucCallback());
        }
    }

    public String sendSpecial(Request request) throws IOException {
        byte[] payload = this.objectMapper.writeValueAsBytes((Object)request);
        BcosRequest bcosRequest = new BcosRequest();
        if (this.channelService.getOrgID() != null) {
            bcosRequest.setKeyID(this.channelService.getOrgID());
        } else {
            bcosRequest.setKeyID(this.channelService.getAgencyName());
        }
        bcosRequest.setBankNO("");
        bcosRequest.setContent(new String(payload));
        bcosRequest.setMessageID(this.channelService.newSeq());
        if (this.timeout != 0) {
            bcosRequest.setTimeout(this.timeout);
        }
        BcosResponse response = !request.isNeedTransCallback() ? this.channelService.sendEthereumMessage(bcosRequest) : this.channelService.sendEthereumMessage(bcosRequest, request.getTransactionSucCallback());
        logger.trace("bcos request:{} {}", (Object)bcosRequest.getMessageID(), (Object)this.objectMapper.writeValueAsString((Object)request));
        logger.trace("bcos response:{} {} {}", new Object[]{bcosRequest.getMessageID(), response.getErrorCode(), response.getContent()});
        if (response.getErrorCode() == 0) {
            if (response.getContent().contains("error")) {
                Response t = (Response)this.objectMapper.readValue(response.getContent(), Response.class);
                throw new ResponseExcepiton(t.getError().getCode(), t.getError().getMessage());
            }
            String[] resultArray = response.getContent().split("result");
            String resultStr = resultArray[1];
            if ("\"".equals(resultStr.substring(2, 3))) {
                return resultStr.substring(3, resultStr.length() - 3);
            }
            return resultStr.substring(2, resultStr.length() - 2);
        }
        throw new IOException(response.getErrorMessage());
    }

    public org.fisco.bcos.channel.client.Service getChannelService() {
        return this.channelService;
    }

    public void setChannelService(org.fisco.bcos.channel.client.Service channelService) {
        this.channelService = channelService;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    @Override
    public void close() throws IOException {
    }
}

