/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AbiDefinition {
    private boolean constant;
    private List<NamedType> inputs;
    private String name;
    private List<NamedType> outputs;
    private String type;
    private boolean payable;
    private String stateMutability;

    public AbiDefinition() {
    }

    public AbiDefinition(boolean constant, List<NamedType> inputs, String name, List<NamedType> outputs, String type, boolean payable) {
        this(constant, inputs, name, outputs, type, payable, null);
    }

    public AbiDefinition(boolean constant, List<NamedType> inputs, String name, List<NamedType> outputs, String type, boolean payable, String stateMutability) {
        this.constant = constant;
        this.inputs = inputs;
        this.name = name;
        this.outputs = outputs;
        this.type = type;
        this.payable = payable;
        this.stateMutability = stateMutability;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public List<NamedType> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<NamedType> inputs) {
        this.inputs = inputs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<NamedType> getOutputs() {
        return this.outputs;
    }

    public boolean hasOutputs() {
        return !this.outputs.isEmpty();
    }

    public void setOutputs(List<NamedType> outputs) {
        this.outputs = outputs;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isPayable() {
        return this.payable;
    }

    public void setPayable(boolean payable) {
        this.payable = payable;
    }

    public String getStateMutability() {
        return this.stateMutability;
    }

    public void setStateMutability(String stateMutability) {
        this.stateMutability = stateMutability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbiDefinition)) {
            return false;
        }
        AbiDefinition that = (AbiDefinition)o;
        if (this.isConstant() != that.isConstant()) {
            return false;
        }
        if (this.isPayable() != that.isPayable()) {
            return false;
        }
        if (this.getInputs() != null ? !this.getInputs().equals(that.getInputs()) : that.getInputs() != null) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getOutputs() != null ? !this.getOutputs().equals(that.getOutputs()) : that.getOutputs() != null) {
            return false;
        }
        if (this.getStateMutability() != null ? !this.getStateMutability().equals(that.getStateMutability()) : that.getStateMutability() != null) {
            return false;
        }
        return this.getType() != null ? this.getType().equals(that.getType()) : that.getType() == null;
    }

    public int hashCode() {
        int result = this.isConstant() ? 1 : 0;
        result = 31 * result + (this.getInputs() != null ? this.getInputs().hashCode() : 0);
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getOutputs() != null ? this.getOutputs().hashCode() : 0);
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        result = 31 * result + (this.isPayable() ? 1 : 0);
        result = 31 * result + (this.getStateMutability() != null ? this.getStateMutability().hashCode() : 0);
        return result;
    }

    public static class NamedType {
        private String name;
        private String type;
        private Type type0;
        private boolean indexed;

        public NamedType() {
        }

        public NamedType(String name, String type) {
            this.name = name;
            this.type = type;
            this.setType0(new Type(name));
        }

        public NamedType(String name, String type, boolean indexed) {
            this.name = name;
            this.type = type;
            this.indexed = indexed;
            this.setType0(new Type(name));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean isIndexed() {
            return this.indexed;
        }

        public void setIndexed(boolean indexed) {
            this.indexed = indexed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NamedType)) {
                return false;
            }
            NamedType namedType = (NamedType)o;
            if (this.isIndexed() != namedType.isIndexed()) {
                return false;
            }
            if (this.getName() != null ? !this.getName().equals(namedType.getName()) : namedType.getName() != null) {
                return false;
            }
            return this.getType() != null ? this.getType().equals(namedType.getType()) : namedType.getType() == null;
        }

        public int hashCode() {
            int result = this.getName() != null ? this.getName().hashCode() : 0;
            result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
            result = 31 * result + (this.isIndexed() ? 1 : 0);
            return result;
        }

        public Type getType0() {
            return this.type0;
        }

        public void setType0(Type type0) {
            this.type0 = type0;
        }

        public static class Type {
            public String name;
            public String baseName;
            public List<Integer> depth = new ArrayList<Integer>();

            public Type(String name) {
                int index = name.indexOf("[");
                this.baseName = -1 == index ? name.trim() : name.substring(0, index);
                this.name = name;
                this.doParser();
            }

            private void doParser() {
                Pattern p = Pattern.compile("\\[[0-9]{0,}\\]");
                Matcher m = p.matcher(this.name);
                while (m.find()) {
                    String s = m.group();
                    String dig = s.substring(s.indexOf("[") + 1, s.indexOf("]")).trim();
                    if (dig.isEmpty()) {
                        this.depth.add(new Integer(0));
                        continue;
                    }
                    this.depth.add(Integer.valueOf(dig));
                }
            }

            public String toString() {
                return "Type [name=" + this.name + ", baseName=" + this.baseName + ", depth=" + this.depth + "]";
            }

            public String getName() {
                return this.name;
            }

            public int getDimensions() {
                if (this.arrayType()) {
                    return this.depth.get(this.depth.size() - 1);
                }
                return 0;
            }

            public String getBaseName() {
                return this.baseName;
            }

            public boolean arrayType() {
                return 0 != this.getDepth();
            }

            public boolean staticArray() {
                return this.arrayType() && this.depth.get(this.depth.size() - 1) > 0;
            }

            public boolean dynamicArray() {
                return this.arrayType() && this.depth.get(this.depth.size() - 1) == 0;
            }

            public int getDepth() {
                return this.depth.size();
            }
        }
    }
}

