/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.protocol.core.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;
import org.fisco.bcos.web3j.protocol.core.Response;
import org.fisco.bcos.web3j.protocol.core.methods.response.Transaction;
import org.fisco.bcos.web3j.utils.Numeric;

public class BcosBlock
extends Response<Block> {
    @Override
    @JsonDeserialize(using=ResponseDeserialiser.class)
    public void setResult(Block result) {
        super.setResult(result);
    }

    public Block getBlock() {
        return (Block)this.getResult();
    }

    public static class ResponseDeserialiser
    extends JsonDeserializer<Block> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public Block deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.VALUE_NULL) {
                return (Block)this.objectReader.readValue(jsonParser, Block.class);
            }
            return null;
        }
    }

    public static class ResultTransactionDeserialiser
    extends JsonDeserializer<List<TransactionResult>> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public List<TransactionResult> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ArrayList<TransactionResult> transactionResults;
            block3: {
                JsonToken nextToken;
                block2: {
                    transactionResults = new ArrayList<TransactionResult>();
                    nextToken = jsonParser.nextToken();
                    if (nextToken != JsonToken.START_OBJECT) break block2;
                    Iterator transactionObjectIterator = this.objectReader.readValues(jsonParser, TransactionObject.class);
                    while (transactionObjectIterator.hasNext()) {
                        transactionResults.add((TransactionResult)transactionObjectIterator.next());
                    }
                    break block3;
                }
                if (nextToken != JsonToken.VALUE_STRING) break block3;
                jsonParser.getValueAsString();
                Iterator transactionHashIterator = this.objectReader.readValues(jsonParser, TransactionHash.class);
                while (transactionHashIterator.hasNext()) {
                    transactionResults.add((TransactionResult)transactionHashIterator.next());
                }
            }
            return transactionResults;
        }
    }

    public static class TransactionObject
    extends Transaction
    implements TransactionResult<Transaction> {
        public TransactionObject() {
        }

        public TransactionObject(String hash, String nonce, String blockHash, String blockNumber, String transactionIndex, String from, String to, String value, String gasPrice, String gas, String input, String creates, String publicKey, String raw, String r, String s, int v) {
            super(hash, nonce, blockHash, blockNumber, transactionIndex, from, to, value, gasPrice, gas, input, creates, publicKey, raw, r, s, v);
        }

        @Override
        public Transaction get() {
            return this;
        }
    }

    public static class TransactionHash
    implements TransactionResult<String> {
        private String value;

        public TransactionHash() {
        }

        public TransactionHash(String value) {
            this.value = value;
        }

        @Override
        public String get() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransactionHash)) {
                return false;
            }
            TransactionHash that = (TransactionHash)o;
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }

    public static interface TransactionResult<T> {
        public T get();
    }

    public static class Block {
        private String number;
        private String hash;
        private String parentHash;
        private String nonce;
        private String sha3Uncles;
        private String logsBloom;
        private String transactionsRoot;
        private String stateRoot;
        private String receiptsRoot;
        private String author;
        private String sealer;
        private String mixHash;
        private List<String> extraData;
        private String gasLimit;
        private String gasUsed;
        private String timestamp;
        private List<TransactionResult> transactions;
        private List<String> uncles;
        private List<String> sealerList;

        public Block() {
        }

        public String toString() {
            return "Block [number=" + this.number + ", hash=" + this.hash + ", parentHash=" + this.parentHash + ", nonce=" + this.nonce + ", sha3Uncles=" + this.sha3Uncles + ", logsBloom=" + this.logsBloom + ", transactionsRoot=" + this.transactionsRoot + ", stateRoot=" + this.stateRoot + ", receiptsRoot=" + this.receiptsRoot + ", author=" + this.author + ", sealer=" + this.sealer + ", mixHash=" + this.mixHash + ", extraData=" + this.extraData + ", gasLimit=" + this.gasLimit + ", gasUsed=" + this.gasUsed + ", timestamp=" + this.timestamp + ", transactions=" + this.transactions + ", uncles=" + this.uncles + ", sealFields=" + this.sealerList + "]";
        }

        public Block(String number, String hash, String parentHash, String nonce, String sha3Uncles, String logsBloom, String transactionsRoot, String stateRoot, String receiptsRoot, String author, String sealer, String mixHash, List<String> extraData, String gasLimit, String gasUsed, String timestamp, List<TransactionResult> transactions, List<String> uncles, List<String> sealerList) {
            this.number = number;
            this.hash = hash;
            this.parentHash = parentHash;
            this.nonce = nonce;
            this.sha3Uncles = sha3Uncles;
            this.logsBloom = logsBloom;
            this.transactionsRoot = transactionsRoot;
            this.stateRoot = stateRoot;
            this.receiptsRoot = receiptsRoot;
            this.author = author;
            this.sealer = sealer;
            this.mixHash = mixHash;
            this.extraData = extraData;
            this.gasLimit = gasLimit;
            this.gasUsed = gasUsed;
            this.timestamp = timestamp;
            this.transactions = transactions;
            this.uncles = uncles;
            this.sealerList = sealerList;
        }

        public BigInteger getNumber() {
            return Numeric.decodeQuantity(this.number);
        }

        public String getNumberRaw() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public String getParentHash() {
            return this.parentHash;
        }

        public void setParentHash(String parentHash) {
            this.parentHash = parentHash;
        }

        public BigInteger getNonce() {
            if (this.nonce == null) {
                return new BigInteger("0");
            }
            return Numeric.decodeQuantity(this.nonce);
        }

        public String getNonceRaw() {
            return this.nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public String getSha3Uncles() {
            return this.sha3Uncles;
        }

        public void setSha3Uncles(String sha3Uncles) {
            this.sha3Uncles = sha3Uncles;
        }

        public String getLogsBloom() {
            return this.logsBloom;
        }

        public void setLogsBloom(String logsBloom) {
            this.logsBloom = logsBloom;
        }

        public String getTransactionsRoot() {
            return this.transactionsRoot;
        }

        public void setTransactionsRoot(String transactionsRoot) {
            this.transactionsRoot = transactionsRoot;
        }

        public String getStateRoot() {
            return this.stateRoot;
        }

        public void setStateRoot(String stateRoot) {
            this.stateRoot = stateRoot;
        }

        public String getReceiptsRoot() {
            return this.receiptsRoot;
        }

        public void setReceiptsRoot(String receiptsRoot) {
            this.receiptsRoot = receiptsRoot;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getSealer() {
            return this.sealer;
        }

        public void setSealer(String sealer) {
            this.sealer = sealer;
        }

        public String getMixHash() {
            return this.mixHash;
        }

        public void setMixHash(String mixHash) {
            this.mixHash = mixHash;
        }

        public List<String> getExtraData() {
            return this.extraData;
        }

        public void setExtraData(List<String> extraData) {
            this.extraData = extraData;
        }

        public BigInteger getGasLimit() {
            return Numeric.decodeQuantity(this.gasLimit);
        }

        public String getGasLimitRaw() {
            return this.gasLimit;
        }

        public void setGasLimit(String gasLimit) {
            this.gasLimit = gasLimit;
        }

        public BigInteger getGasUsed() {
            return Numeric.decodeQuantity(this.gasUsed);
        }

        public String getGasUsedRaw() {
            return this.gasUsed;
        }

        public void setGasUsed(String gasUsed) {
            this.gasUsed = gasUsed;
        }

        public BigInteger getTimestamp() {
            return Numeric.decodeQuantity(this.timestamp);
        }

        public String getTimestampRaw() {
            return this.timestamp;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public List<TransactionResult> getTransactions() {
            return this.transactions;
        }

        @JsonDeserialize(using=ResultTransactionDeserialiser.class)
        public void setTransactions(List<TransactionResult> transactions) {
            this.transactions = transactions;
        }

        public List<String> getUncles() {
            return this.uncles;
        }

        public void setUncles(List<String> uncles) {
            this.uncles = uncles;
        }

        public List<String> getSealerList() {
            return this.sealerList;
        }

        public void setSealerList(List<String> sealerList) {
            this.sealerList = sealerList;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            Block block = (Block)o;
            if (this.getNumberRaw() != null ? !this.getNumberRaw().equals(block.getNumberRaw()) : block.getNumberRaw() != null) {
                return false;
            }
            if (this.getHash() != null ? !this.getHash().equals(block.getHash()) : block.getHash() != null) {
                return false;
            }
            if (this.getParentHash() != null ? !this.getParentHash().equals(block.getParentHash()) : block.getParentHash() != null) {
                return false;
            }
            if (this.getNonceRaw() != null ? !this.getNonceRaw().equals(block.getNonceRaw()) : block.getNonceRaw() != null) {
                return false;
            }
            if (this.getSha3Uncles() != null ? !this.getSha3Uncles().equals(block.getSha3Uncles()) : block.getSha3Uncles() != null) {
                return false;
            }
            if (this.getLogsBloom() != null ? !this.getLogsBloom().equals(block.getLogsBloom()) : block.getLogsBloom() != null) {
                return false;
            }
            if (this.getTransactionsRoot() != null ? !this.getTransactionsRoot().equals(block.getTransactionsRoot()) : block.getTransactionsRoot() != null) {
                return false;
            }
            if (this.getStateRoot() != null ? !this.getStateRoot().equals(block.getStateRoot()) : block.getStateRoot() != null) {
                return false;
            }
            if (this.getReceiptsRoot() != null ? !this.getReceiptsRoot().equals(block.getReceiptsRoot()) : block.getReceiptsRoot() != null) {
                return false;
            }
            if (this.getAuthor() != null ? !this.getAuthor().equals(block.getAuthor()) : block.getAuthor() != null) {
                return false;
            }
            if (this.getSealer() != null ? !this.getSealer().equals(block.getSealer()) : block.getSealer() != null) {
                return false;
            }
            if (this.getMixHash() != null ? !this.getMixHash().equals(block.getMixHash()) : block.getMixHash() != null) {
                return false;
            }
            if (this.getExtraData() != null ? !this.getExtraData().equals(block.getExtraData()) : block.getExtraData() != null) {
                return false;
            }
            if (this.getGasLimitRaw() != null ? !this.getGasLimitRaw().equals(block.getGasLimitRaw()) : block.getGasLimitRaw() != null) {
                return false;
            }
            if (this.getGasUsedRaw() != null ? !this.getGasUsedRaw().equals(block.getGasUsedRaw()) : block.getGasUsedRaw() != null) {
                return false;
            }
            if (this.getTimestampRaw() != null ? !this.getTimestampRaw().equals(block.getTimestampRaw()) : block.getTimestampRaw() != null) {
                return false;
            }
            if (this.getTransactions() != null ? !this.getTransactions().equals(block.getTransactions()) : block.getTransactions() != null) {
                return false;
            }
            if (this.getUncles() != null ? !this.getUncles().equals(block.getUncles()) : block.getUncles() != null) {
                return false;
            }
            return this.getSealerList() != null ? this.getSealerList().equals(block.getSealerList()) : block.getSealerList() == null;
        }

        public int hashCode() {
            int result = this.getNumberRaw() != null ? this.getNumberRaw().hashCode() : 0;
            result = 31 * result + (this.getHash() != null ? this.getHash().hashCode() : 0);
            result = 31 * result + (this.getParentHash() != null ? this.getParentHash().hashCode() : 0);
            result = 31 * result + (this.getNonceRaw() != null ? this.getNonceRaw().hashCode() : 0);
            result = 31 * result + (this.getSha3Uncles() != null ? this.getSha3Uncles().hashCode() : 0);
            result = 31 * result + (this.getLogsBloom() != null ? this.getLogsBloom().hashCode() : 0);
            result = 31 * result + (this.getTransactionsRoot() != null ? this.getTransactionsRoot().hashCode() : 0);
            result = 31 * result + (this.getStateRoot() != null ? this.getStateRoot().hashCode() : 0);
            result = 31 * result + (this.getReceiptsRoot() != null ? this.getReceiptsRoot().hashCode() : 0);
            result = 31 * result + (this.getAuthor() != null ? this.getAuthor().hashCode() : 0);
            result = 31 * result + (this.getSealer() != null ? this.getSealer().hashCode() : 0);
            result = 31 * result + (this.getMixHash() != null ? this.getMixHash().hashCode() : 0);
            result = 31 * result + (this.getExtraData() != null ? this.getExtraData().hashCode() : 0);
            result = 31 * result + (this.getGasLimitRaw() != null ? this.getGasLimitRaw().hashCode() : 0);
            result = 31 * result + (this.getGasUsedRaw() != null ? this.getGasUsedRaw().hashCode() : 0);
            result = 31 * result + (this.getTimestampRaw() != null ? this.getTimestampRaw().hashCode() : 0);
            result = 31 * result + (this.getTransactions() != null ? this.getTransactions().hashCode() : 0);
            result = 31 * result + (this.getUncles() != null ? this.getUncles().hashCode() : 0);
            result = 31 * result + (this.getSealerList() != null ? this.getSealerList().hashCode() : 0);
            return result;
        }
    }
}

