/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.protocol.rx;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.DefaultBlockParameter;
import org.fisco.bcos.web3j.protocol.core.DefaultBlockParameterName;
import org.fisco.bcos.web3j.protocol.core.DefaultBlockParameterNumber;
import org.fisco.bcos.web3j.protocol.core.filters.BlockFilter;
import org.fisco.bcos.web3j.protocol.core.filters.Filter;
import org.fisco.bcos.web3j.protocol.core.filters.LogFilter;
import org.fisco.bcos.web3j.protocol.core.filters.PendingTransactionFilter;
import org.fisco.bcos.web3j.protocol.core.methods.request.BcosFilter;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosBlock;
import org.fisco.bcos.web3j.protocol.core.methods.response.Log;
import org.fisco.bcos.web3j.protocol.core.methods.response.Transaction;
import org.fisco.bcos.web3j.utils.Flowables;
import org.reactivestreams.Publisher;

public class JsonRpc2_0Rx {
    private final Web3j web3j;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Scheduler scheduler;

    public JsonRpc2_0Rx(Web3j web3j, ScheduledExecutorService scheduledExecutorService) {
        this.web3j = web3j;
        this.scheduledExecutorService = scheduledExecutorService;
        this.scheduler = Schedulers.from((Executor)scheduledExecutorService);
    }

    public Flowable<String> blockHashFlowable(long pollingInterval) {
        return Flowable.create(subscriber -> {
            BlockFilter blockFilter = new BlockFilter(this.web3j, arg_0 -> ((FlowableEmitter)subscriber).onNext(arg_0));
            this.run(blockFilter, subscriber, pollingInterval);
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public Flowable<String> pendingTransactionHashFlowable(long pollingInterval) {
        return Flowable.create(subscriber -> {
            PendingTransactionFilter pendingTransactionFilter = new PendingTransactionFilter(this.web3j, arg_0 -> ((FlowableEmitter)subscriber).onNext(arg_0));
            this.run(pendingTransactionFilter, subscriber, pollingInterval);
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public Flowable<Log> logFlowable(BcosFilter ethFilter, long pollingInterval) {
        return Flowable.create(subscriber -> {
            LogFilter logFilter = new LogFilter(this.web3j, arg_0 -> ((FlowableEmitter)subscriber).onNext(arg_0), ethFilter);
            this.run(logFilter, subscriber, pollingInterval);
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    private <T> void run(Filter<T> filter, FlowableEmitter<? super T> emitter, long pollingInterval) {
        filter.run(this.scheduledExecutorService, pollingInterval);
        emitter.setCancellable(filter::cancel);
    }

    public Flowable<Transaction> transactionFlowable(long pollingInterval) {
        return this.blockFlowable(true, pollingInterval).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    public Flowable<Transaction> pendingTransactionFlowable(long pollingInterval) {
        return this.pendingTransactionHashFlowable(pollingInterval).flatMap(transactionHash -> this.web3j.getTransactionByHash((String)transactionHash).flowable()).filter(ethTransaction -> ethTransaction.getTransaction().isPresent()).map(ethTransaction -> ethTransaction.getTransaction().get());
    }

    public Flowable<BcosBlock> blockFlowable(boolean fullTransactionObjects, long pollingInterval) {
        return this.blockHashFlowable(pollingInterval).flatMap(blockHash -> this.web3j.getBlockByHash((String)blockHash, fullTransactionObjects).flowable());
    }

    public Flowable<BcosBlock> replayBlocksFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects) {
        return this.replayBlocksFlowable(startBlock, endBlock, fullTransactionObjects, true);
    }

    public Flowable<BcosBlock> replayBlocksFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects, boolean ascending) {
        return this.replayBlocksFlowableSync(startBlock, endBlock, fullTransactionObjects, ascending).subscribeOn(this.scheduler);
    }

    private Flowable<BcosBlock> replayBlocksFlowableSync(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects) {
        return this.replayBlocksFlowableSync(startBlock, endBlock, fullTransactionObjects, true);
    }

    private Flowable<BcosBlock> replayBlocksFlowableSync(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects, boolean ascending) {
        BigInteger startBlockNumber = null;
        BigInteger endBlockNumber = null;
        try {
            startBlockNumber = this.getBlockNumber(startBlock);
            endBlockNumber = this.getBlockNumber(endBlock);
        }
        catch (IOException e) {
            Flowable.error((Throwable)e);
        }
        if (ascending) {
            return Flowables.range(startBlockNumber, endBlockNumber).flatMap(i -> this.web3j.getBlockByNumber(new DefaultBlockParameterNumber((BigInteger)i), fullTransactionObjects).flowable());
        }
        return Flowables.range(startBlockNumber, endBlockNumber, false).flatMap(i -> this.web3j.getBlockByNumber(new DefaultBlockParameterNumber((BigInteger)i), fullTransactionObjects).flowable());
    }

    public Flowable<Transaction> replayTransactionsFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        return this.replayBlocksFlowable(startBlock, endBlock, true).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    public Flowable<BcosBlock> replayPastBlocksFlowable(DefaultBlockParameter startBlock, boolean fullTransactionObjects, Flowable<BcosBlock> onCompleteFlowable) {
        return this.replayPastBlocksFlowableSync(startBlock, fullTransactionObjects, onCompleteFlowable).subscribeOn(this.scheduler);
    }

    public Flowable<BcosBlock> replayPastBlocksFlowable(DefaultBlockParameter startBlock, boolean fullTransactionObjects) {
        return this.replayPastBlocksFlowable(startBlock, fullTransactionObjects, (Flowable<BcosBlock>)Flowable.empty());
    }

    private Flowable<BcosBlock> replayPastBlocksFlowableSync(DefaultBlockParameter startBlock, boolean fullTransactionObjects, Flowable<BcosBlock> onCompleteFlowable) {
        BigInteger latestBlockNumber;
        BigInteger startBlockNumber;
        try {
            startBlockNumber = this.getBlockNumber(startBlock);
            latestBlockNumber = this.getLatestBlockNumber();
        }
        catch (IOException e) {
            return Flowable.error((Throwable)e);
        }
        if (startBlockNumber.compareTo(latestBlockNumber) > -1) {
            return onCompleteFlowable;
        }
        return Flowable.concat(this.replayBlocksFlowableSync(new DefaultBlockParameterNumber(startBlockNumber), new DefaultBlockParameterNumber(latestBlockNumber), fullTransactionObjects), (Publisher)Flowable.defer(() -> this.replayPastBlocksFlowableSync(new DefaultBlockParameterNumber(latestBlockNumber.add(BigInteger.ONE)), fullTransactionObjects, onCompleteFlowable)));
    }

    public Flowable<Transaction> replayPastTransactionsFlowable(DefaultBlockParameter startBlock) {
        return this.replayPastBlocksFlowable(startBlock, true, (Flowable<BcosBlock>)Flowable.empty()).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    public Flowable<BcosBlock> replayPastAndFutureBlocksFlowable(DefaultBlockParameter startBlock, boolean fullTransactionObjects, long pollingInterval) {
        return this.replayPastBlocksFlowable(startBlock, fullTransactionObjects, this.blockFlowable(fullTransactionObjects, pollingInterval));
    }

    public Flowable<Transaction> replayPastAndFutureTransactionsFlowable(DefaultBlockParameter startBlock, long pollingInterval) {
        return this.replayPastAndFutureBlocksFlowable(startBlock, true, pollingInterval).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    private BigInteger getLatestBlockNumber() throws IOException {
        return this.getBlockNumber(DefaultBlockParameterName.LATEST);
    }

    private BigInteger getBlockNumber(DefaultBlockParameter defaultBlockParameter) throws IOException {
        if (defaultBlockParameter instanceof DefaultBlockParameterNumber) {
            return ((DefaultBlockParameterNumber)defaultBlockParameter).getBlockNumber();
        }
        BcosBlock latestEthBlock = this.web3j.getBlockByNumber(defaultBlockParameter, false).send();
        return latestEthBlock.getBlock().getNumber();
    }

    private static List<Transaction> toTransactions(BcosBlock ethBlock) {
        return ethBlock.getBlock().getTransactions().stream().map(transactionResult -> (Transaction)transactionResult.get()).collect(Collectors.toList());
    }
}

