/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.solidity.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Scanner;

public class Solc {
    private File solc = null;

    Solc() {
        try {
            this.initBundled();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't init solc compiler: ", e);
        }
    }

    private void initBundled() throws IOException {
        File tmpDir = new File(System.getProperty("user.home"), "solc");
        tmpDir.mkdirs();
        InputStream is = this.getClass().getResourceAsStream("/native/" + this.getOS() + "/solc/file.list");
        try (Scanner scanner = new Scanner(is);){
            while (scanner.hasNext()) {
                String s = scanner.next();
                File targetFile = new File(tmpDir, s);
                InputStream fis = this.getClass().getResourceAsStream("/native/" + this.getOS() + "/solc/" + s);
                Files.copy(fis, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (this.solc != null) continue;
                this.solc = targetFile;
                this.solc.setExecutable(true);
            }
        }
    }

    private String getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return "win";
        }
        if (osName.contains("linux")) {
            return "linux";
        }
        if (osName.contains("mac")) {
            return "mac";
        }
        throw new RuntimeException("Can't find solc compiler: unrecognized OS: " + osName);
    }

    public File getExecutable() {
        return this.solc;
    }
}

