/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Timeout;
import java.security.SecureRandom;
import java.util.List;
import org.fisco.bcos.channel.client.Service;
import org.fisco.bcos.channel.dto.ChannelMessage2;
import org.fisco.bcos.channel.dto.ChannelResponse;
import org.fisco.bcos.channel.handler.ChannelConnections;
import org.fisco.bcos.channel.handler.ChannelHandlerContextHelper;
import org.fisco.bcos.channel.handler.ConnectionInfo;
import org.fisco.bcos.channel.protocol.ChannelMessageError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelResponseCallback2 {
    private static Logger logger = LoggerFactory.getLogger(ChannelResponseCallback2.class);
    private ConnectionInfo fromConnection;
    private List<ConnectionInfo> fromConnectionInfos;
    private ChannelConnections fromChannelConnections;
    private ChannelMessage2 message;
    private Service service;
    private Timeout timeout;

    public abstract void onResponseMessage(ChannelResponse var1);

    public final void onResponse(ChannelResponse response) {
        if (response.getErrorCode().intValue() == ChannelMessageError.NODES_UNREACHABLE.getError()) {
            logger.error("Local node error\uff0ctry the next local nodec");
            this.retrySendMessage();
        } else {
            try {
                this.onResponseMessage(response);
            }
            catch (Exception e) {
                logger.error("response package processing error:", (Throwable)e);
            }
            if (this.message.getSeq() != null) {
                this.service.getSeq2Callback().remove(this.message.getSeq());
            }
            if (this.timeout != null) {
                this.timeout.cancel();
            }
        }
    }

    public final void onTimeout() {
        logger.error("send message timeout:{}", (Object)this.message.getSeq());
        ChannelResponse response = new ChannelResponse();
        response.setErrorCode(ChannelMessageError.MESSAGE_TIMEOUT.getError());
        response.setMessageID(this.message.getSeq());
        response.setErrorMessage("send message timeout");
        response.setContent("");
        try {
            this.onResponseMessage(response);
        }
        catch (Exception e) {
            logger.error("timeout processing error:", (Throwable)e);
        }
        this.service.getSeq2Callback().remove(this.message.getSeq());
        this.timeout.cancel();
    }

    public void retrySendMessage() {
        Integer errorCode = 0;
        try {
            logger.debug("Number of local nodes:{}", (Object)this.fromConnectionInfos.size());
            this.setFromConnection(null);
            if (this.fromConnectionInfos.size() > 0) {
                SecureRandom random = new SecureRandom();
                Integer index = random.nextInt(this.fromConnectionInfos.size());
                logger.debug("selected:{}", (Object)index);
                this.setFromConnection(this.fromConnectionInfos.get(index));
                this.fromConnectionInfos.remove(this.fromConnectionInfos.get(index));
            }
            if (this.getFromConnection() == null) {
                logger.error("Failed to send message,all retry failed");
                errorCode = ChannelMessageError.NODES_UNREACHABLE.getError();
                throw new Exception("Failed to send message,all retry failed");
            }
            ChannelHandlerContext ctx = this.fromChannelConnections.getNetworkConnectionByHost(this.getFromConnection().getHost(), this.getFromConnection().getPort());
            if (ctx != null && ChannelHandlerContextHelper.isChannelAvailable(ctx)) {
                ByteBuf out = ctx.alloc().buffer();
                this.message.writeHeader(out);
                this.message.writeExtra(out);
                ctx.writeAndFlush((Object)out);
                logger.debug("send message to  {}:{} success ", (Object)this.fromConnection.getHost(), (Object)this.fromConnection.getPort());
            } else {
                logger.error("sending node unavailable");
                this.retrySendMessage();
            }
        }
        catch (Exception e) {
            logger.error("send message exception {}", (Throwable)e);
            ChannelResponse response = new ChannelResponse();
            response.setErrorCode(errorCode);
            response.setErrorMessage(e.getMessage());
            try {
                this.onResponseMessage(response);
            }
            catch (Exception ee) {
                logger.error("onResponseMessage error:{}", (Throwable)ee);
            }
            if (this.message.getSeq() != null) {
                this.service.getSeq2Callback().remove(this.message.getSeq());
            }
            if (this.timeout != null) {
                this.timeout.cancel();
            }
            return;
        }
    }

    public ConnectionInfo getFromConnection() {
        return this.fromConnection;
    }

    public void setFromConnection(ConnectionInfo fromConnection) {
        this.fromConnection = fromConnection;
    }

    public List<ConnectionInfo> getFromConnectionInfos() {
        return this.fromConnectionInfos;
    }

    public void setFromConnectionInfos(List<ConnectionInfo> fromConnectionInfos) {
        this.fromConnectionInfos = fromConnectionInfos;
    }

    public ChannelConnections getFromChannelConnections() {
        return this.fromChannelConnections;
    }

    public void setFromChannelConnections(ChannelConnections fromConnectionConnections) {
        this.fromChannelConnections = fromConnectionConnections;
    }

    public ChannelMessage2 getRequest() {
        return this.message;
    }

    public void setRequest(ChannelMessage2 message) {
        this.message = message;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Timeout timeout) {
        this.timeout = timeout;
    }
}

