/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.handler;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLException;
import org.fisco.bcos.channel.handler.ChannelHandler;
import org.fisco.bcos.channel.handler.ChannelHandlerContextHelper;
import org.fisco.bcos.channel.handler.ConnectionInfo;
import org.fisco.bcos.web3j.tuples.generated.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ChannelConnections {
    private static Logger logger = LoggerFactory.getLogger(ChannelConnections.class);
    private Callback callback;
    private List<String> connectionsStr;
    private static final String CA_CERT = "classpath:ca.crt";
    private static final String SSL_CERT = "classpath:node.crt";
    private static final String SSL_KEY = "classpath:node.key";
    private Resource caCert;
    private Resource sslCert;
    private Resource sslKey;
    private List<ConnectionInfo> connections = new ArrayList<ConnectionInfo>();
    private Boolean running = false;
    private ThreadPoolTaskExecutor threadPool;
    private long idleTimeout = 10000L;
    private long heartBeatDelay = 2000L;
    public ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    public Map<String, ChannelHandlerContext> networkConnections = new HashMap<String, ChannelHandlerContext>();
    private int groupId;
    private Bootstrap bootstrap = new Bootstrap();
    ServerBootstrap serverBootstrap = new ServerBootstrap();

    private void initDefaultCertConfig() {
        PathMatchingResourcePatternResolver resolver;
        if (this.getCaCert() == null) {
            resolver = new PathMatchingResourcePatternResolver();
            this.setCaCert(resolver.getResource(CA_CERT));
        }
        if (this.getSslCert() == null || !this.getSslCert().exists()) {
            if (this.getSslCert() == null) {
                logger.info(" sslCert not configured in applicationContext.xml, use default setting: {}  ", (Object)SSL_CERT);
            } else {
                logger.info(" sslCert:{} configured in applicationContext.xml not exist, use default setting: {}  ", (Object)this.getSslCert().getFilename(), (Object)SSL_CERT);
            }
            resolver = new PathMatchingResourcePatternResolver();
            this.setSslCert(resolver.getResource(SSL_CERT));
        }
        if (this.getSslKey() == null || !this.getSslKey().exists()) {
            if (this.getSslKey() == null) {
                logger.info(" sslKey not configured in applicationContext.xml, use default setting: {}  ", (Object)SSL_KEY);
            } else {
                logger.info(" sslKey:{} configured in applicationContext.xml not exist, use default setting: {}  ", (Object)this.getSslKey().getFilename(), (Object)SSL_KEY);
            }
            resolver = new PathMatchingResourcePatternResolver();
            this.setSslKey(resolver.getResource(SSL_KEY));
        }
    }

    public Resource getCaCert() {
        return this.caCert;
    }

    public void setCaCert(Resource caCert) {
        this.caCert = caCert;
    }

    public Resource getSslCert() {
        return this.sslCert;
    }

    public void setSslCert(Resource sslCert) {
        this.sslCert = sslCert;
    }

    public Resource getSslKey() {
        return this.sslKey;
    }

    public void setSslKey(Resource sslKey) {
        this.sslKey = sslKey;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public List<String> getConnectionsStr() {
        return this.connectionsStr;
    }

    public void setConnectionsStr(List<String> connectionsStr) {
        this.connectionsStr = connectionsStr;
    }

    public List<ConnectionInfo> getConnections() {
        return this.connections;
    }

    public void setConnections(List<ConnectionInfo> connections) {
        this.connections = connections;
    }

    public ThreadPoolTaskExecutor getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPoolTaskExecutor threadPool) {
        this.threadPool = threadPool;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public long getHeartBeatDelay() {
        return this.heartBeatDelay;
    }

    public void setHeartBeatDelay(long heartBeatDelay) {
        this.heartBeatDelay = heartBeatDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelHandlerContext randomNetworkConnection(ConcurrentHashMap<String, BigInteger> nodeToBlockNumberMap) throws Exception {
        ArrayList<ChannelHandlerContext> activeConnections = new ArrayList<ChannelHandlerContext>();
        this.getReadWriteLock().readLock().lock();
        try {
            for (String key : this.networkConnections.keySet()) {
                if (this.networkConnections.get(key) == null || !ChannelHandlerContextHelper.isChannelAvailable(this.networkConnections.get(key))) continue;
                activeConnections.add(this.networkConnections.get(key));
            }
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
        if (activeConnections.isEmpty()) {
            logger.error("activeConnections isEmpty");
            throw new Exception("activeConnections isEmpty");
        }
        ArrayList<ChannelHandlerContext> maxBlockNumberConnections = new ArrayList<ChannelHandlerContext>();
        BigInteger maxBlockNumber = new BigInteger("0");
        if (nodeToBlockNumberMap != null) {
            for (String key : nodeToBlockNumberMap.keySet()) {
                Optional<ChannelHandlerContext> optionalCtx;
                BigInteger blockNumber = nodeToBlockNumberMap.get(key);
                if (blockNumber.compareTo(maxBlockNumber) < 0) continue;
                if (blockNumber.compareTo(maxBlockNumber) > 0) {
                    maxBlockNumberConnections.clear();
                }
                if (!(optionalCtx = activeConnections.stream().filter(x -> key.equals(((SocketChannel)x.channel()).remoteAddress().getAddress().getHostAddress() + ((SocketChannel)x.channel()).remoteAddress().getPort())).findFirst()).isPresent()) continue;
                ChannelHandlerContext channelHandlerContext = optionalCtx.get();
                maxBlockNumberConnections.add(channelHandlerContext);
                maxBlockNumber = blockNumber;
            }
        }
        SecureRandom random = new SecureRandom();
        int selectNodeIndex = 0;
        ChannelHandlerContext selectedNodeChannelHandlerContext = null;
        if (!maxBlockNumberConnections.isEmpty()) {
            selectNodeIndex = random.nextInt(maxBlockNumberConnections.size());
            selectedNodeChannelHandlerContext = (ChannelHandlerContext)maxBlockNumberConnections.get(selectNodeIndex);
        } else {
            selectNodeIndex = random.nextInt(activeConnections.size());
            selectedNodeChannelHandlerContext = (ChannelHandlerContext)activeConnections.get(selectNodeIndex);
        }
        return selectedNodeChannelHandlerContext;
    }

    public ConnectionInfo getConnectionInfo(String host, Integer port) {
        for (ConnectionInfo info : this.connections) {
            if (!info.getHost().equals(host) || !info.getPort().equals(port)) continue;
            return info;
        }
        return null;
    }

    public Map<String, ChannelHandlerContext> getNetworkConnections() {
        return this.networkConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelHandlerContext getNetworkConnectionByHost(String host, Integer port) {
        String endpoint = host + ":" + port;
        ChannelHandlerContext channelHandlerContext = null;
        this.getReadWriteLock().readLock().lock();
        try {
            channelHandlerContext = this.networkConnections.get(endpoint);
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
        return channelHandlerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetworkConnectionByHost(String host, Integer port, ChannelHandlerContext ctx) {
        String endpoint = host + ":" + port;
        this.getReadWriteLock().writeLock().lock();
        try {
            this.networkConnections.put(endpoint, ctx);
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetworkConnectionByHost(String host, Integer port) {
        String endpoint = host + ":" + port;
        this.getReadWriteLock().writeLock().lock();
        try {
            this.networkConnections.remove(endpoint);
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public void startListen(Integer port) throws SSLException {
        if (this.running.booleanValue()) {
            logger.debug("running");
            return;
        }
        logger.debug("init connections listen");
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        final ChannelConnections selfService = this;
        final ThreadPoolTaskExecutor selfThreadPool = this.threadPool;
        final SslContext sslCtx = this.initSslContextForListening();
        logger.debug("listening sslcontext init success");
        try {
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((io.netty.channel.ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((io.netty.channel.ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelHandler handler = new ChannelHandler();
                    handler.setConnections(selfService);
                    handler.setThreadPool(selfThreadPool);
                    ch.pipeline().addLast(new io.netty.channel.ChannelHandler[]{sslCtx.newHandler(ch.alloc()), new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, -4, 0), new IdleStateHandler(ChannelConnections.this.idleTimeout, ChannelConnections.this.idleTimeout, ChannelConnections.this.idleTimeout, TimeUnit.MILLISECONDS), handler});
                }
            });
            ChannelFuture future = this.serverBootstrap.bind(port.intValue());
            future.get();
            this.running = true;
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
        }
    }

    public void init() {
        logger.debug("init connections");
        if (this.connectionsStr != null) {
            for (String conn : this.connectionsStr) {
                ConnectionInfo connection = new ConnectionInfo();
                String[] split2 = conn.split(":");
                connection.setHost(split2[0]);
                connection.setPort(Integer.parseInt(split2[1]));
                this.networkConnections.put(conn, null);
                logger.info(" add connected node: " + split2[0] + ":" + split2[1]);
                connection.setConfig(true);
                this.connections.add(connection);
            }
        } else {
            logger.warn(" connectionsStr null, check your connectionsStr list config.");
        }
        this.initDefaultCertConfig();
    }

    public void startConnect() throws SSLException {
        if (this.running.booleanValue()) {
            logger.debug("running");
            return;
        }
        logger.debug("init connections connect");
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        this.bootstrap.group((EventLoopGroup)workerGroup);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        final ChannelConnections selfService = this;
        final ThreadPoolTaskExecutor selfThreadPool = this.threadPool;
        final SslContext sslCtx = this.initSslContextForConnect();
        logger.debug(" connect sslcontext init success");
        this.bootstrap.handler((io.netty.channel.ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelHandler handler = new ChannelHandler();
                handler.setConnections(selfService);
                handler.setThreadPool(selfThreadPool);
                ch.pipeline().addLast(new io.netty.channel.ChannelHandler[]{sslCtx.newHandler(ch.alloc()), new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, -4, 0), new IdleStateHandler(ChannelConnections.this.idleTimeout, ChannelConnections.this.idleTimeout, ChannelConnections.this.idleTimeout, TimeUnit.MILLISECONDS), handler});
            }
        });
        this.running = true;
        Thread loop = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        if (!ChannelConnections.this.running.booleanValue()) {
                            return;
                        }
                        ChannelConnections.this.reconnect();
                        Thread.sleep(ChannelConnections.this.heartBeatDelay);
                    }
                }
                catch (InterruptedException e) {
                    logger.error("error", (Throwable)e);
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        };
        loop.start();
    }

    private SslContext initSslContextForConnect() throws SSLException {
        SslContext sslCtx;
        try {
            Resource caResource = this.getCaCert();
            InputStream caInputStream = caResource.getInputStream();
            Resource keystorecaResource = this.getSslCert();
            Resource keystorekeyResource = this.getSslKey();
            sslCtx = SslContextBuilder.forClient().trustManager(caInputStream).keyManager(keystorecaResource.getInputStream(), keystorekeyResource.getInputStream()).sslProvider(SslProvider.JDK).build();
        }
        catch (Exception e) {
            logger.debug("SSLCONTEXT ***********" + e.getMessage());
            throw new SSLException("Failed to initialize the client-side SSLContext: " + e.getMessage());
        }
        return sslCtx;
    }

    private SslContext initSslContextForListening() throws SSLException {
        SslContext sslCtx;
        try {
            Resource caResource = this.getCaCert();
            InputStream caInputStream = caResource.getInputStream();
            Resource keystorecaResource = this.getSslCert();
            Resource keystorekeyResource = this.getSslKey();
            sslCtx = SslContextBuilder.forServer((InputStream)keystorecaResource.getInputStream(), (InputStream)keystorekeyResource.getInputStream()).trustManager(caInputStream).sslProvider(SslProvider.JDK).build();
        }
        catch (Exception e) {
            logger.debug("SSLCONTEXT ***********" + e.getMessage());
            throw new SSLException("Failed to initialize the client-side SSLContext, please checkout ca.crt File!", e);
        }
        return sslCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        ArrayList<String> shouldConnectNodes = new ArrayList<String>();
        ArrayList<Tuple2<String, ChannelHandlerContext>> shouldHeatBeatNodes = new ArrayList<Tuple2<String, ChannelHandlerContext>>();
        this.getReadWriteLock().readLock().lock();
        try {
            for (Map.Entry<String, ChannelHandlerContext> ctx : this.networkConnections.entrySet()) {
                if (ctx.getValue() == null || !ctx.getValue().channel().isActive()) {
                    shouldConnectNodes.add(ctx.getKey());
                    continue;
                }
                if (!ChannelHandlerContextHelper.isChannelAvailable(ctx.getValue())) continue;
                shouldHeatBeatNodes.add(new Tuple2<String, ChannelHandlerContext>(ctx.getKey(), ctx.getValue()));
            }
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
        for (int j = 0; j < shouldHeatBeatNodes.size(); ++j) {
            logger.trace("send heart beat to {}", ((Tuple2)shouldHeatBeatNodes.get(j)).getValue1());
            this.callback.sendHeartbeat((ChannelHandlerContext)((Tuple2)shouldHeatBeatNodes.get(j)).getValue2());
        }
        for (int i = 0; i < shouldConnectNodes.size(); ++i) {
            String[] split = ((String)shouldConnectNodes.get(i)).split(":");
            String host = split[0];
            Integer port = Integer.parseInt(split[1]);
            logger.info("try connect to: {}:{}", (Object)host, (Object)port);
            this.bootstrap.connect(host, port.intValue());
        }
    }

    public void onReceiveMessage(ChannelHandlerContext ctx, ByteBuf message) {
        this.callback.onMessage(ctx, message);
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public void setReadWriteLock(ReadWriteLock readWriteLock) {
        this.readWriteLock = readWriteLock;
    }

    public static interface Callback {
        public void onConnect(ChannelHandlerContext var1);

        public void onDisconnect(ChannelHandlerContext var1);

        public void onMessage(ChannelHandlerContext var1, ByteBuf var2);

        public void sendHeartbeat(ChannelHandlerContext var1);
    }
}

