/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.abi.datatypes;

import java.math.BigInteger;
import org.fisco.bcos.web3j.abi.datatypes.NumericType;

public abstract class IntType
extends NumericType {
    public IntType(String typePrefix, int bitSize, BigInteger value) {
        super(typePrefix + bitSize, value);
        if (!this.valid(bitSize, value)) {
            throw new UnsupportedOperationException("Bitsize must be 8 bit aligned, and in range 0 < bitSize <= 256, and in valid range.");
        }
    }

    boolean valid(int bitSize, BigInteger value) {
        return IntType.isValidBitSize(bitSize) && IntType.isValidBitCount(bitSize, value);
    }

    static boolean isValidBitSize(int bitSize) {
        return bitSize % 8 == 0 && bitSize > 0 && bitSize <= 256;
    }

    private static boolean isValidBitCount(int bitSize, BigInteger value) {
        return value.bitLength() <= bitSize;
    }
}

