/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class WalletFile {
    private String address;
    private Crypto crypto;
    private String id;
    private int version;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    @JsonSetter(value="crypto")
    public void setCrypto(Crypto crypto) {
        this.crypto = crypto;
    }

    @JsonSetter(value="Crypto")
    public void setCryptoV1(Crypto crypto) {
        this.setCrypto(crypto);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    static class KdfParamsDeserialiser
    extends JsonDeserializer<KdfParams> {
        KdfParamsDeserialiser() {
        }

        public KdfParams deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
            ObjectNode root = (ObjectNode)objectMapper.readTree(jsonParser);
            JsonNode n = root.get("n");
            KdfParams kdfParams = n == null ? (KdfParams)objectMapper.convertValue((Object)root, Aes128CtrKdfParams.class) : (KdfParams)objectMapper.convertValue((Object)root, ScryptKdfParams.class);
            return kdfParams;
        }
    }

    public static class ScryptKdfParams
    implements KdfParams {
        private int dklen;
        private int n;
        private int p;
        private int r;
        private String salt;

        @Override
        public int getDklen() {
            return this.dklen;
        }

        public void setDklen(int dklen) {
            this.dklen = dklen;
        }

        public int getN() {
            return this.n;
        }

        public void setN(int n) {
            this.n = n;
        }

        public int getP() {
            return this.p;
        }

        public void setP(int p) {
            this.p = p;
        }

        public int getR() {
            return this.r;
        }

        public void setR(int r) {
            this.r = r;
        }

        @Override
        public String getSalt() {
            return this.salt;
        }

        public void setSalt(String salt) {
            this.salt = salt;
        }
    }

    public static class Aes128CtrKdfParams
    implements KdfParams {
        private int dklen;
        private int c;
        private String prf;
        private String salt;

        @Override
        public int getDklen() {
            return this.dklen;
        }

        public void setDklen(int dklen) {
            this.dklen = dklen;
        }

        public int getC() {
            return this.c;
        }

        public void setC(int c) {
            this.c = c;
        }

        public String getPrf() {
            return this.prf;
        }

        public void setPrf(String prf) {
            this.prf = prf;
        }

        @Override
        public String getSalt() {
            return this.salt;
        }

        public void setSalt(String salt) {
            this.salt = salt;
        }
    }

    static interface KdfParams {
        public int getDklen();

        public String getSalt();
    }

    public static class CipherParams {
        private String iv;

        public String getIv() {
            return this.iv;
        }

        public void setIv(String iv) {
            this.iv = iv;
        }
    }

    public static class Crypto {
        private String cipher;
        private String ciphertext;
        private CipherParams cipherparams;
        private String kdf;
        private KdfParams kdfparams;
        private String mac;

        public String getCipher() {
            return this.cipher;
        }

        public void setCipher(String cipher) {
            this.cipher = cipher;
        }

        public String getCiphertext() {
            return this.ciphertext;
        }

        public void setCiphertext(String ciphertext) {
            this.ciphertext = ciphertext;
        }

        public CipherParams getCipherparams() {
            return this.cipherparams;
        }

        public void setCipherparams(CipherParams cipherparams) {
            this.cipherparams = cipherparams;
        }

        public String getKdf() {
            return this.kdf;
        }

        public void setKdf(String kdf) {
            this.kdf = kdf;
        }

        public KdfParams getKdfparams() {
            return this.kdfparams;
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="kdf")
        @JsonSubTypes(value={@JsonSubTypes.Type(value=Aes128CtrKdfParams.class, name="pbkdf2"), @JsonSubTypes.Type(value=ScryptKdfParams.class, name="scrypt")})
        public void setKdfparams(KdfParams kdfparams) {
            this.kdfparams = kdfparams;
        }

        public String getMac() {
            return this.mac;
        }

        public void setMac(String mac) {
            this.mac = mac;
        }
    }
}

