/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto.gm.sm2;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.fisco.bcos.web3j.crypto.ECKeyPair;
import org.fisco.bcos.web3j.crypto.Sign;
import org.fisco.bcos.web3j.crypto.SignInterface;
import org.fisco.bcos.web3j.crypto.gm.sm2.crypto.asymmetric.SM2Algorithm;
import org.fisco.bcos.web3j.crypto.gm.sm2.util.encoders.Hex;
import org.fisco.bcos.web3j.crypto.gm.sm3.SM3Digest;
import org.fisco.bcos.web3j.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2Sign
implements SignInterface {
    static Logger logger = LoggerFactory.getLogger(SM2Sign.class);

    @Override
    public Sign.SignatureData signMessage(byte[] message, ECKeyPair keyPair) {
        return SM2Sign.sign(message, keyPair);
    }

    public static Sign.SignatureData sign(byte[] message, ECKeyPair ecKeyPair) {
        SM3Digest sm3Digest = new SM3Digest();
        BigInteger[] rs = null;
        byte[] r = null;
        byte[] s = null;
        byte[] pub = null;
        byte v = 0;
        byte[] messageHash = sm3Digest.hash(message);
        try {
            byte[] signByte = SM2Algorithm.sign(messageHash, ecKeyPair.getPrivateKey());
            logger.debug("signData:{}", (Object)signByte);
            ASN1Sequence as = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])signByte);
            rs = new BigInteger[]{((ASN1Integer)as.getObjectAt(0)).getValue(), ((ASN1Integer)as.getObjectAt(1)).getValue()};
        }
        catch (IOException ex) {
            logger.error("SM2 Sign ERROR");
        }
        if (rs != null) {
            r = SM2Algorithm.getEncoded((BigInteger)rs[0]);
            s = SM2Algorithm.getEncoded((BigInteger)rs[1]);
            pub = Numeric.toBytesPadded(ecKeyPair.getPublicKey(), 64);
            logger.debug("SM2 SignPublic:{},SM2SignPublicLen:{}", (Object)Hex.toHexString(pub), (Object)pub.length);
            logger.debug("SM2 SignR:{},SM2SignRLen{}", (Object)Hex.toHexString(r), (Object)r.length);
            logger.debug("SM2 SignS:{},SM2SignSLen{}", (Object)Hex.toHexString(s), (Object)s.length);
        }
        return new Sign.SignatureData(v, r, s, pub);
    }
}

