/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.precompile.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigInteger;
import org.fisco.bcos.fisco.EnumNodeVersion;
import org.fisco.bcos.web3j.precompile.common.PrecompiledResponse;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.channel.StatusCode;
import org.fisco.bcos.web3j.protocol.core.methods.response.NodeVersion;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.protocol.exceptions.TransactionException;

public class PrecompiledCommon {
    public static final String BCOS_RC1 = "2.0.0-rc1";
    public static final String BCOS_RC2 = "2.0.0-rc2";
    public static final String BCOS_RC3 = "2.0.0-rc3";
    public static final String USER_TABLE_PREFIX = "_user_";
    public static final String USER_TABLE_PREFIX_2_2_0_VERSION = "u_";
    public static final String SYS_TABLE = "_sys_tables_";
    public static final String SYS_TABLE_ACCESS = "_sys_table_access_";
    public static final String SYS_CONSENSUS = "_sys_consensus_";
    public static final String SYS_CNS = "_sys_cns_";
    public static final String SYS_CONFIG = "_sys_config_";
    public static final int Success = 0;
    public static final int PermissionDenied_RC1 = 80;
    public static final int PermissionDenied = 50000;
    public static final int PermissionDenied_RC3 = -50000;
    public static final int TableExist = 50001;
    public static final int TableExist_RC3 = -50001;
    public static final int TableNameAndAddressExist_RC1 = 56;
    public static final int TableNameAndAddressExist = 51000;
    public static final int TableNameAndAddressExist_RC3 = -51000;
    public static final int TableNameAndAddressNotExist_RC1 = 57;
    public static final int TableNameAndAddressNotExist = 51001;
    public static final int TableNameAndAddressNotExist_RC3 = -51001;
    public static final int InvalidNodeId = -51100;
    public static final int LastSealer_RC1 = 100;
    public static final int LastSealer = 51101;
    public static final int LastSealer_RC3 = -51101;
    public static final int P2pNetwork = -51102;
    public static final int GroupPeers = -51103;
    public static final int SealerList = -51104;
    public static final int ObserverList = -51105;
    public static final int ContractNameAndVersionExist = -51200;
    public static final int VersionExceeds = -51201;
    public static final int InvalidKey_RC1 = 157;
    public static final int InvalidKey = 51300;
    public static final int InvalidKey_RC3 = -51300;
    public static final int TABLE_KEY_MAX_LENGTH = 255;
    public static String BCOS_VERSION = "";

    public static String transferToJson(int code) throws IOException {
        String msg = "";
        if (BCOS_VERSION == null || EnumNodeVersion.BCOS_2_0_0_RC1.getVersion().equals(BCOS_VERSION)) {
            if (code == 80) {
                msg = "permission denied";
            } else if (code == 56) {
                msg = "table name and address already exist";
            } else if (code == 57) {
                msg = "table name and address does not exist";
            } else if (code == 100) {
                msg = "the last sealer cannot be removed";
            } else if (code == 157) {
                msg = "invalid configuration entry";
            }
        } else if (EnumNodeVersion.BCOS_2_0_0_RC2.getVersion().equals(BCOS_VERSION)) {
            if (code == 50000) {
                msg = "permission denied";
            } else if (code == 51000) {
                msg = "table name and address already exist";
            } else if (code == 51001) {
                msg = "table name and address does not exist";
            } else if (code == 51101) {
                msg = "the last sealer cannot be removed";
            } else if (code == 50001) {
                msg = "table already exist";
            } else if (code == 51300) {
                msg = "invalid configuration entry";
            }
        } else if (code == -50000) {
            msg = "permission denied";
        } else if (code == -51000) {
            msg = "table name and address already exist";
        } else if (code == -51001) {
            msg = "table name and address does not exist";
        } else if (code == -51101) {
            msg = "the last sealer cannot be removed";
        } else if (code == -50001) {
            msg = "table already exist";
        } else if (code == -51300) {
            msg = "invalid configuration entry";
        }
        if (code == 0) {
            msg = "success";
        } else if (code == -51100) {
            msg = "invalid node ID";
        } else if (code == -51102) {
            msg = "the node is not reachable";
        } else if (code == -51103) {
            msg = "the node is not a group peer";
        } else if (code == -51104) {
            msg = "the node is already in the sealer list";
        } else if (code == -51105) {
            msg = "the node is already in the observer list";
        } else if (code == -51200) {
            msg = "contract name and version already exist";
        } else if (code == -51201) {
            msg = "version string length exceeds the maximum limit";
        }
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        return mapper.writeValueAsString((Object)new PrecompiledResponse(code, msg));
    }

    public static String getJsonStr(String output, Web3j web3j) throws IOException {
        try {
            NodeVersion.Version nodeVersion = web3j.getNodeVersion().send().getNodeVersion();
            BCOS_VERSION = nodeVersion.getSupportedVersion();
            int code = 0;
            code = new BigInteger(output.substring(2, output.length()), 16).intValue();
            if (code == 1) {
                code = 0;
            }
            return PrecompiledCommon.transferToJson(code);
        }
        catch (NumberFormatException e) {
            return "The call function does not exist.";
        }
    }

    public static int handleTransactionReceiptForCRUD(TransactionReceipt receipt) throws TransactionException {
        String status = receipt.getStatus();
        if (!"0x0".equals(status)) {
            throw new TransactionException(StatusCode.getStatusMessage(status, receipt.getMessage()));
        }
        String output = receipt.getOutput();
        if (!"0x".equals(output)) {
            return new BigInteger(output.substring(2, output.length()), 16).intValue();
        }
        throw new TransactionException("Transaction is handled failure.");
    }

    public static String handleTransactionReceipt(TransactionReceipt receipt, Web3j web3j) throws TransactionException, IOException {
        String status = receipt.getStatus();
        if (!"0x0".equals(status)) {
            throw new TransactionException(StatusCode.getStatusMessage(receipt.getStatus(), receipt.getMessage()));
        }
        if (receipt.getOutput() != null) {
            return PrecompiledCommon.getJsonStr(receipt.getOutput(), web3j);
        }
        throw new TransactionException("Transaction is handled failure.");
    }
}

