/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.protocol.channel;

public class StatusCode {
    public static final String Success = "0x0";
    public static final String Unknown = "0x1";
    public static final String BadRLP = "0x2";
    public static final String InvalidFormat = "0x3";
    public static final String OutOfGasIntrinsic = "0x4";
    public static final String InvalidSignature = "0x5";
    public static final String InvalidNonce = "0x6";
    public static final String NotEnoughCash = "0x7";
    public static final String OutOfGasBase = "0x8";
    public static final String BlockGasLimitReached = "0x9";
    public static final String BadInstruction = "0xa";
    public static final String BadJumpDestination = "0xb";
    public static final String OutOfGas = "0xc";
    public static final String OutOfStack = "0xd";
    public static final String StackUnderflow = "0xe";
    public static final String NonceCheckFail = "0xf";
    public static final String BlockLimitCheckFail = "0x10";
    public static final String FilterCheckFail = "0x11";
    public static final String NoDeployPermission = "0x12";
    public static final String NoCallPermission = "0x13";
    public static final String NoTxPermission = "0x14";
    public static final String PrecompiledError = "0x15";
    public static final String RevertInstruction = "0x16";
    public static final String InvalidZeroSignatureFormat = "0x17";
    public static final String AddressAlreadyUsed = "0x18";
    public static final String PermissionDenied = "0x19";
    public static final String CallAddressError = "0x1a";
    public static final String GasOverflow = "0x1b";
    public static final String TxPoolIsFull = "0x1c";
    public static final String TransactionRefused = "0x1d";
    public static final String ExceptionCatched = "0x30";
    public static final String ErrorInRPC = "0x31";
    public static final String AlreadyKnown = "0x2710";
    public static final String AlreadyInChain = "0x2711";
    public static final String InvalidTxChainId = "0x2712";
    public static final String InvalidTxGroupId = "0x2713";
    public static final String RequestNotBelongToTheGroup = "0x2714";
    public static final String MalformedTx = "0x2715";

    public static String getStatusMessage(String status) {
        return StatusCode.getStatusMessage(status, " Error code: " + status);
    }

    public static String getStatusMessage(String status, String errorMessage) {
        String message = "";
        switch (status) {
            case "0x0": {
                message = "success";
                break;
            }
            case "0x1": {
                message = "unknown";
                break;
            }
            case "0x2": {
                message = "bad RLP";
                break;
            }
            case "0x3": {
                message = "invalid format";
                break;
            }
            case "0x4": {
                message = "out of gas";
                break;
            }
            case "0x5": {
                message = "invalid signature";
                break;
            }
            case "0x6": {
                message = "invalid nonce";
                break;
            }
            case "0x7": {
                message = "not enough cash";
                break;
            }
            case "0x8": {
                message = "out of gas base";
                break;
            }
            case "0x9": {
                message = "block gas limit reached";
                break;
            }
            case "0xa": {
                message = "bad instruction";
                break;
            }
            case "0xb": {
                message = "bad jump destination";
                break;
            }
            case "0xc": {
                message = "out of gas";
                break;
            }
            case "0xd": {
                message = "out of stack";
                break;
            }
            case "0xe": {
                message = "stack underflow";
                break;
            }
            case "0xf": {
                message = "nonce check fail";
                break;
            }
            case "0x10": {
                message = "block limit check fail";
                break;
            }
            case "0x11": {
                message = "filter check fail";
                break;
            }
            case "0x12": {
                message = "no deploy permission";
                break;
            }
            case "0x13": {
                message = "no call permission";
                break;
            }
            case "0x14": {
                message = "no tx permission";
                break;
            }
            case "0x15": {
                message = "precompiled error";
                break;
            }
            case "0x16": {
                message = "revert instruction";
                break;
            }
            case "0x17": {
                message = "invalid zero signature format";
                break;
            }
            case "0x18": {
                message = "address already used";
                break;
            }
            case "0x19": {
                message = "permission denied";
                break;
            }
            case "0x1a": {
                message = "call address error";
                break;
            }
            case "0x1b": {
                message = "gas over flow";
                break;
            }
            case "0x1c": {
                message = "transaction pool is full";
                break;
            }
            case "0x1d": {
                message = "transaction refuesd";
                break;
            }
            case "0x31": {
                message = "error in RPC";
                break;
            }
            case "0x2710": {
                message = "transaction already known";
                break;
            }
            case "0x2711": {
                message = "transaction already in chain";
                break;
            }
            case "0x2712": {
                message = "invalid chain id";
                break;
            }
            case "0x2713": {
                message = "invalid group id";
                break;
            }
            case "0x2714": {
                message = "request not belong to the group";
                break;
            }
            case "0x2715": {
                message = "malformed transaction";
                break;
            }
            default: {
                message = errorMessage;
            }
        }
        return message;
    }
}

