/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.protocol.core.filters;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.Request;
import org.fisco.bcos.web3j.protocol.core.filters.Callback;
import org.fisco.bcos.web3j.protocol.core.filters.Filter;
import org.fisco.bcos.web3j.protocol.core.filters.FilterException;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosFilter;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosLog;

public class BlockFilter
extends Filter<String> {
    public BlockFilter(Web3j web3j, Callback<String> callback) {
        super(web3j, callback);
    }

    @Override
    BcosFilter sendRequest() throws IOException {
        return this.web3j.newBlockFilter().send();
    }

    @Override
    void process(List<BcosLog.LogResult> logResults) {
        for (BcosLog.LogResult logResult : logResults) {
            if (logResult instanceof BcosLog.Hash) {
                String blockHash = ((BcosLog.Hash)logResult).get();
                this.callback.onEvent(blockHash);
                continue;
            }
            throw new FilterException("Unexpected result type: " + logResult.get() + ", required Hash");
        }
    }

    @Override
    protected Optional<Request<?, BcosLog>> getFilterLogs(BigInteger filterId) {
        return Optional.empty();
    }
}

