/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.protocol.core.filters;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.Request;
import org.fisco.bcos.web3j.protocol.core.Response;
import org.fisco.bcos.web3j.protocol.core.filters.Callback;
import org.fisco.bcos.web3j.protocol.core.filters.FilterException;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosFilter;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosLog;
import org.fisco.bcos.web3j.protocol.core.methods.response.UninstallFilter;

public abstract class Filter<T> {
    final Web3j web3j;
    final Callback<T> callback;
    private volatile BigInteger filterId;
    private ScheduledFuture<?> schedule;

    public Filter(Web3j web3j, Callback<T> callback) {
        this.web3j = web3j;
        this.callback = callback;
    }

    public void run(ScheduledExecutorService scheduledExecutorService, long blockTime) {
        try {
            BcosFilter ethFilter = this.sendRequest();
            if (ethFilter.hasError()) {
                this.throwException(ethFilter.getError());
            }
            this.filterId = ethFilter.getFilterId();
            scheduledExecutorService.submit(this::getInitialFilterLogs);
            this.schedule = scheduledExecutorService.scheduleAtFixedRate(() -> this.pollFilter(ethFilter), 0L, blockTime, TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            this.throwException(e);
        }
    }

    private void getInitialFilterLogs() {
        try {
            BcosLog ethLog;
            Optional<Request<?, BcosLog>> maybeRequest = this.getFilterLogs(this.filterId);
            if (maybeRequest.isPresent()) {
                ethLog = maybeRequest.get().send();
            } else {
                ethLog = new BcosLog();
                ethLog.setResult(Collections.emptyList());
            }
            this.process(ethLog.getLogs());
        }
        catch (IOException e) {
            this.throwException(e);
        }
    }

    private void pollFilter(BcosFilter ethFilter) {
        Response ethLog = null;
        try {
            ethLog = this.web3j.getFilterChanges(this.filterId).send();
        }
        catch (IOException e) {
            this.throwException(e);
        }
        if (ethLog.hasError()) {
            this.throwException(ethFilter.getError());
        }
        this.process(((BcosLog)ethLog).getLogs());
    }

    abstract BcosFilter sendRequest() throws IOException;

    abstract void process(List<BcosLog.LogResult> var1);

    public void cancel() {
        this.schedule.cancel(false);
        Response ethUninstallFilter = null;
        try {
            ethUninstallFilter = this.web3j.getUninstallFilter(this.filterId).send();
        }
        catch (IOException e) {
            this.throwException(e);
        }
        if (ethUninstallFilter.hasError()) {
            this.throwException(ethUninstallFilter.getError());
        }
        if (!((UninstallFilter)ethUninstallFilter).isUninstalled()) {
            this.throwException(ethUninstallFilter.getError());
        }
    }

    protected abstract Optional<Request<?, BcosLog>> getFilterLogs(BigInteger var1);

    void throwException(Response.Error error) {
        throw new FilterException("Invalid request: " + error.getMessage());
    }

    void throwException(Throwable cause) {
        throw new FilterException("Error sending request", cause);
    }
}

