/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.protocol.ipc;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.fisco.bcos.web3j.protocol.ipc.IOFacade;

public class UnixDomainSocket
implements IOFacade {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final int bufferSize;
    private final InputStreamReader reader;
    private final PrintWriter writer;

    public UnixDomainSocket(String ipcSocketPath) {
        this(ipcSocketPath, 1024);
    }

    public UnixDomainSocket(String ipcSocketPath, int bufferSize) {
        this.bufferSize = bufferSize;
        try {
            UnixSocketAddress address = new UnixSocketAddress(ipcSocketPath);
            UnixSocketChannel channel = UnixSocketChannel.open((UnixSocketAddress)address);
            this.reader = new InputStreamReader(Channels.newInputStream((ReadableByteChannel)channel));
            this.writer = new PrintWriter(Channels.newOutputStream((WritableByteChannel)channel));
        }
        catch (IOException e) {
            throw new RuntimeException("Provided file socket cannot be opened: " + ipcSocketPath, e);
        }
    }

    UnixDomainSocket(InputStreamReader reader, PrintWriter writer, int bufferSize) {
        this.bufferSize = bufferSize;
        this.writer = writer;
        this.reader = reader;
    }

    @Override
    public void write(String payload) throws IOException {
        this.writer.write(payload);
        this.writer.flush();
    }

    @Override
    public String read() throws IOException {
        CharBuffer response = CharBuffer.allocate(this.bufferSize);
        String result = "";
        do {
            response.clear();
            this.reader.read(response);
            result = result + new String(response.array(), response.arrayOffset(), response.position());
        } while (response.position() == response.limit() && response.get(response.limit() - 1) != '\n');
        return result;
    }
}

