/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.tx;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.crypto.Hash;
import org.fisco.bcos.web3j.crypto.RawTransaction;
import org.fisco.bcos.web3j.crypto.TransactionEncoder;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.methods.response.SendTransaction;
import org.fisco.bcos.web3j.tx.RawTransactionManager;
import org.fisco.bcos.web3j.tx.TransactionManager;
import org.fisco.bcos.web3j.tx.exceptions.TxHashMismatchException;
import org.fisco.bcos.web3j.tx.response.TransactionReceiptProcessor;
import org.fisco.bcos.web3j.utils.Numeric;
import org.fisco.bcos.web3j.utils.TxHashVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTransactionManager
extends TransactionManager {
    static Logger logger = LoggerFactory.getLogger(RawTransactionManager.class);
    private final Web3j web3j;
    protected TxHashVerifier txHashVerifier = new TxHashVerifier();

    public ClientTransactionManager(Web3j web3j, Credentials credentials) {
        super(web3j, credentials);
        this.web3j = web3j;
    }

    public ClientTransactionManager(Web3j web3j, Credentials credentials, int attempts, int sleepDuration) {
        super(web3j, attempts, sleepDuration, credentials);
        this.web3j = web3j;
    }

    public ClientTransactionManager(Web3j web3j, Credentials credentials, TransactionReceiptProcessor transactionReceiptProcessor) {
        super(transactionReceiptProcessor, credentials);
        this.web3j = web3j;
    }

    @Override
    public SendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value, String extraData) throws IOException {
        SecureRandom r = new SecureRandom();
        BigInteger randomid = new BigInteger(250, r);
        BigInteger blockLimit = this.getBlockLimit();
        logger.info("sendTransaction randomid: {} blockLimit:{}", (Object)randomid, (Object)blockLimit);
        RawTransaction rawTransaction = RawTransaction.createTransaction(randomid, gasPrice, gasLimit, blockLimit, to, value, data);
        return this.signAndSend(rawTransaction);
    }

    public SendTransaction signAndSend(RawTransaction rawTransaction) throws IOException {
        String txHashRemote;
        String txHashLocal;
        byte[] signedMessage = TransactionEncoder.signMessage(rawTransaction, this.credentials);
        String hexValue = Numeric.toHexString(signedMessage);
        SendTransaction sendTransaction = this.web3j.sendRawTransaction(hexValue).send();
        if (sendTransaction != null && !sendTransaction.hasError() && !this.txHashVerifier.verify(txHashLocal = Hash.sha3(hexValue), txHashRemote = sendTransaction.getTransactionHash())) {
            throw new TxHashMismatchException(txHashLocal, txHashRemote);
        }
        return sendTransaction;
    }

    BigInteger getBlockLimit() throws IOException {
        return this.web3j.getBlockNumberCache();
    }
}

