/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.tx;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.fisco.bcos.channel.client.TransactionSucCallback;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.crypto.Hash;
import org.fisco.bcos.web3j.crypto.RawTransaction;
import org.fisco.bcos.web3j.crypto.TransactionEncoder;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.Request;
import org.fisco.bcos.web3j.protocol.core.methods.response.SendTransaction;
import org.fisco.bcos.web3j.tx.TransactionManager;
import org.fisco.bcos.web3j.tx.exceptions.TxHashMismatchException;
import org.fisco.bcos.web3j.utils.Numeric;
import org.fisco.bcos.web3j.utils.TxHashVerifier;

public class RawTransactionManager
extends TransactionManager {
    private final Web3j web3j;
    final Credentials credentials;
    private final byte chainId;
    protected TxHashVerifier txHashVerifier = new TxHashVerifier();

    public RawTransactionManager(Web3j web3j, Credentials credentials, byte chainId) {
        super(web3j, credentials);
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, byte chainId, int attempts, int sleepDuration) {
        super(web3j, attempts, sleepDuration, credentials);
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials) {
        this(web3j, credentials, -1);
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, int attempts, int sleepDuration) {
        this(web3j, credentials, -1, attempts, sleepDuration);
    }

    BigInteger getBlockLimit() throws IOException {
        return this.web3j.getBlockNumberCache();
    }

    public TxHashVerifier getTxHashVerifier() {
        return this.txHashVerifier;
    }

    public void setTxHashVerifier(TxHashVerifier txHashVerifier) {
        this.txHashVerifier = txHashVerifier;
    }

    @Override
    public SendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value, String extraData) throws IOException {
        SecureRandom r = new SecureRandom();
        BigInteger randomid = new BigInteger(250, r);
        BigInteger blockLimit = this.getBlockLimit();
        RawTransaction rawTransaction = RawTransaction.createTransaction(randomid, gasPrice, gasLimit, blockLimit, to, value, data);
        return this.signAndSend(rawTransaction);
    }

    @Override
    public SendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value, String extraData, TransactionSucCallback callback) throws IOException {
        SecureRandom r = new SecureRandom();
        BigInteger randomid = new BigInteger(250, r);
        BigInteger blockLimit = this.getBlockLimit();
        RawTransaction rawTransaction = RawTransaction.createTransaction(randomid, gasPrice, gasLimit, blockLimit, to, value, data);
        return this.signAndSend(rawTransaction, callback);
    }

    public SendTransaction signAndSend(RawTransaction rawTransaction) throws IOException {
        String txHashRemote;
        String txHashLocal;
        byte[] signedMessage = this.chainId > -1 ? TransactionEncoder.signMessage(rawTransaction, this.chainId, this.credentials) : TransactionEncoder.signMessage(rawTransaction, this.credentials);
        String hexValue = Numeric.toHexString(signedMessage);
        SendTransaction sendTransaction = this.web3j.sendRawTransaction(hexValue).send();
        if (sendTransaction != null && !sendTransaction.hasError() && !this.txHashVerifier.verify(txHashLocal = Hash.sha3(hexValue), txHashRemote = sendTransaction.getTransactionHash())) {
            throw new TxHashMismatchException(txHashLocal, txHashRemote);
        }
        return sendTransaction;
    }

    public SendTransaction signAndSend(RawTransaction rawTransaction, TransactionSucCallback callback) throws IOException {
        byte[] signedMessage = this.chainId > -1 ? TransactionEncoder.signMessage(rawTransaction, this.chainId, this.credentials) : TransactionEncoder.signMessage(rawTransaction, this.credentials);
        String hexValue = Numeric.toHexString(signedMessage);
        Request<?, SendTransaction> request = this.web3j.sendRawTransaction(hexValue);
        request.setNeedTransCallback(true);
        request.setTransactionSucCallback(callback);
        request.sendOnly();
        return null;
    }
}

