/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.tx.txdecode;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import org.fisco.bcos.web3j.abi.EventValues;
import org.fisco.bcos.web3j.abi.TypeReference;
import org.fisco.bcos.web3j.abi.datatypes.Event;
import org.fisco.bcos.web3j.protocol.core.methods.response.AbiDefinition;
import org.fisco.bcos.web3j.protocol.core.methods.response.Log;
import org.fisco.bcos.web3j.tx.Contract;
import org.fisco.bcos.web3j.tx.txdecode.BaseException;
import org.fisco.bcos.web3j.tx.txdecode.ContractTypeUtil;
import org.fisco.bcos.web3j.tx.txdecode.DynamicArrayReference;
import org.fisco.bcos.web3j.tx.txdecode.StaticArrayReference;

public class ContractAbiUtil {
    public static final String TYPE_CONSTRUCTOR = "constructor";
    public static final String TYPE_FUNCTION = "function";
    public static final String TYPE_EVENT = "event";

    public static AbiDefinition getConstructorAbiDefinition(String contractAbi) {
        JSONArray abiArr = JSONArray.parseArray((String)contractAbi);
        AbiDefinition result = null;
        for (Object object : abiArr) {
            AbiDefinition abiDefinition = (AbiDefinition)JSON.parseObject((String)object.toString(), AbiDefinition.class);
            if (!TYPE_CONSTRUCTOR.equals(abiDefinition.getType())) continue;
            result = abiDefinition;
            break;
        }
        return result;
    }

    public static List<AbiDefinition> getFuncAbiDefinition(String contractAbi) {
        JSONArray abiArr = JSONArray.parseArray((String)contractAbi);
        ArrayList<AbiDefinition> result = new ArrayList<AbiDefinition>();
        for (Object object : abiArr) {
            AbiDefinition abiDefinition = (AbiDefinition)JSON.parseObject((String)object.toString(), AbiDefinition.class);
            if (!TYPE_FUNCTION.equals(abiDefinition.getType()) && !TYPE_CONSTRUCTOR.equals(abiDefinition.getType())) continue;
            result.add(abiDefinition);
        }
        return result;
    }

    public static List<AbiDefinition> getEventAbiDefinitions(String contractAbi) {
        JSONArray abiArr = JSONArray.parseArray((String)contractAbi);
        ArrayList<AbiDefinition> result = new ArrayList<AbiDefinition>();
        for (Object object : abiArr) {
            AbiDefinition abiDefinition = (AbiDefinition)JSON.parseObject((String)object.toString(), AbiDefinition.class);
            if (!TYPE_EVENT.equals(abiDefinition.getType())) continue;
            result.add(abiDefinition);
        }
        return result;
    }

    public static List<String> getFuncInputType(AbiDefinition abiDefinition) {
        ArrayList<String> inputList = new ArrayList<String>();
        if (abiDefinition != null) {
            List<AbiDefinition.NamedType> inputs = abiDefinition.getInputs();
            for (AbiDefinition.NamedType input : inputs) {
                inputList.add(input.getType());
            }
        }
        return inputList;
    }

    public static List<String> getFuncOutputType(AbiDefinition abiDefinition) {
        ArrayList<String> outputList = new ArrayList<String>();
        List<AbiDefinition.NamedType> outputs = abiDefinition.getOutputs();
        for (AbiDefinition.NamedType output : outputs) {
            outputList.add(output.getType());
        }
        return outputList;
    }

    public static List<TypeReference<?>> paramFormat(List<AbiDefinition.NamedType> paramTypes) throws BaseException {
        ArrayList finalOutputs = new ArrayList();
        for (int i = 0; i < paramTypes.size(); ++i) {
            AbiDefinition.NamedType.Type type = new AbiDefinition.NamedType.Type(paramTypes.get(i).getType());
            if (type.getDepth() > 1) {
                throw new BaseException(201202, String.format("type:%s unsupported array decoding", type.getName()));
            }
            TypeReference<Object> typeReference = null;
            typeReference = type.dynamicArray() ? DynamicArrayReference.create(type.getBaseName(), paramTypes.get(i).isIndexed()) : (type.staticArray() ? StaticArrayReference.create(type.getBaseName(), type.getDimensions(), paramTypes.get(i).isIndexed()) : TypeReference.create(ContractTypeUtil.getType(paramTypes.get(i).getType()), paramTypes.get(i).isIndexed()));
            finalOutputs.add(typeReference);
        }
        return finalOutputs;
    }

    public static EventValues decodeEvent(Log log, AbiDefinition abiDefinition) throws BaseException {
        List<TypeReference<?>> finalOutputs = ContractAbiUtil.paramFormat(abiDefinition.getInputs());
        Event event = new Event(abiDefinition.getName(), finalOutputs);
        EventValues eventValues = Contract.staticExtractEventParameters(event, log);
        return eventValues;
    }
}

