/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.image.impl;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.image.CaseDiagramGenerator;
import org.flowable.cmmn.image.impl.DefaultCaseDiagramCanvas;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CaseTask;
import org.flowable.cmmn.model.CmmnElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.DecisionTask;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.cmmn.model.Milestone;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.ProcessTask;
import org.flowable.cmmn.model.ServiceTask;
import org.flowable.cmmn.model.Stage;
import org.flowable.cmmn.model.Task;
import org.flowable.cmmn.model.TimerEventListener;
import org.flowable.cmmn.model.UserEventListener;

public class DefaultCaseDiagramGenerator
implements CaseDiagramGenerator {
    protected Map<Class<? extends CmmnElement>, ActivityDrawInstruction> activityDrawInstructions = new HashMap<Class<? extends CmmnElement>, ActivityDrawInstruction>();

    public DefaultCaseDiagramGenerator() {
        this(1.0);
    }

    public DefaultCaseDiagramGenerator(final double scaleFactor) {
        this.activityDrawInstructions.put(TimerEventListener.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultCaseDiagramCanvas caseDiagramCanvas, CmmnModel cmmnModel, CaseElement caseElement) {
                GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(caseElement.getId());
                caseDiagramCanvas.drawTimerEventListener(graphicInfo, scaleFactor);
            }
        });
        this.activityDrawInstructions.put(UserEventListener.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultCaseDiagramCanvas caseDiagramCanvas, CmmnModel cmmnModel, CaseElement caseElement) {
                GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(caseElement.getId());
                caseDiagramCanvas.drawUserEventListener(graphicInfo, scaleFactor);
            }
        });
        this.activityDrawInstructions.put(Task.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultCaseDiagramCanvas caseDiagramCanvas, CmmnModel cmmnModel, CaseElement caseElement) {
                GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(caseElement.getId());
                caseDiagramCanvas.drawTask(caseElement.getName(), graphicInfo, scaleFactor);
            }
        });
        this.activityDrawInstructions.put(HumanTask.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultCaseDiagramCanvas caseDiagramCanvas, CmmnModel cmmnModel, CaseElement caseElement) {
                GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(caseElement.getId());
                caseDiagramCanvas.drawUserTask(caseElement.getName(), graphicInfo, scaleFactor);
            }
        });
        this.activityDrawInstructions.put(ServiceTask.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultCaseDiagramCanvas caseDiagramCanvas, CmmnModel cmmnModel, CaseElement caseElement) {
                GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(caseElement.getId());
                caseDiagramCanvas.drawServiceTask(caseElement.getName(), graphicInfo, scaleFactor);
            }
        });
        this.activityDrawInstructions.put(CaseTask.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultCaseDiagramCanvas caseDiagramCanvas, CmmnModel cmmnModel, CaseElement caseElement) {
                GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(caseElement.getId());
                caseDiagramCanvas.drawCaseTask(caseElement.getName(), graphicInfo, scaleFactor);
            }
        });
        this.activityDrawInstructions.put(ProcessTask.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultCaseDiagramCanvas caseDiagramCanvas, CmmnModel cmmnModel, CaseElement caseElement) {
                GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(caseElement.getId());
                caseDiagramCanvas.drawProcessTask(caseElement.getName(), graphicInfo, scaleFactor);
            }
        });
        this.activityDrawInstructions.put(DecisionTask.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultCaseDiagramCanvas caseDiagramCanvas, CmmnModel cmmnModel, CaseElement caseElement) {
                GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(caseElement.getId());
                caseDiagramCanvas.drawDecisionTask(caseElement.getName(), graphicInfo, scaleFactor);
            }
        });
        this.activityDrawInstructions.put(Milestone.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultCaseDiagramCanvas caseDiagramCanvas, CmmnModel cmmnModel, CaseElement caseElement) {
                GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(caseElement.getId());
                caseDiagramCanvas.drawMilestone(caseElement.getName(), graphicInfo, scaleFactor);
            }
        });
        this.activityDrawInstructions.put(Criterion.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultCaseDiagramCanvas caseDiagramCanvas, CmmnModel cmmnModel, CaseElement caseElement) {
                GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(caseElement.getId());
                Criterion criterion = (Criterion)caseElement;
                if (criterion.isEntryCriterion()) {
                    caseDiagramCanvas.drawEntryCriterion(graphicInfo);
                } else if (criterion.isExitCriterion()) {
                    caseDiagramCanvas.drawExitCriterion(graphicInfo);
                }
            }
        });
        this.activityDrawInstructions.put(Stage.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultCaseDiagramCanvas caseDiagramCanvas, CmmnModel cmmnModel, CaseElement caseElement) {
                GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(caseElement.getId());
                caseDiagramCanvas.drawStage(caseElement.getName(), graphicInfo, scaleFactor);
            }
        });
    }

    @Override
    public InputStream generateDiagram(CmmnModel cmmnModel, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader, double scaleFactor) {
        return this.generateCaseDiagram(cmmnModel, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader, scaleFactor).generateImage(imageType);
    }

    @Override
    public InputStream generateDiagram(CmmnModel cmmnModel, String imageType) {
        return this.generateDiagram(cmmnModel, imageType, null, null, null, null, 1.0);
    }

    @Override
    public InputStream generateDiagram(CmmnModel cmmnModel, String imageType, double scaleFactor) {
        return this.generateDiagram(cmmnModel, imageType, null, null, null, null, scaleFactor);
    }

    @Override
    public InputStream generateDiagram(CmmnModel cmmnModel, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader) {
        return this.generateDiagram(cmmnModel, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader, 1.0);
    }

    @Override
    public InputStream generatePngDiagram(CmmnModel cmmnModel) {
        return this.generatePngDiagram(cmmnModel, 1.0);
    }

    @Override
    public InputStream generatePngDiagram(CmmnModel cmmnModel, double scaleFactor) {
        return this.generateDiagram(cmmnModel, "png", scaleFactor);
    }

    @Override
    public InputStream generateJpgDiagram(CmmnModel cmmnModel) {
        return this.generateJpgDiagram(cmmnModel, 1.0);
    }

    @Override
    public InputStream generateJpgDiagram(CmmnModel cmmnModel, double scaleFactor) {
        return this.generateDiagram(cmmnModel, "jpg", scaleFactor);
    }

    public BufferedImage generateImage(CmmnModel cmmnModel, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader, double scaleFactor) {
        return this.generateCaseDiagram(cmmnModel, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader, scaleFactor).generateBufferedImage(imageType);
    }

    public BufferedImage generateImage(CmmnModel cmmnModel, String imageType, double scaleFactor) {
        return this.generateImage(cmmnModel, imageType, null, null, null, null, scaleFactor);
    }

    @Override
    public BufferedImage generatePngImage(CmmnModel cmmnModel, double scaleFactor) {
        return this.generateImage(cmmnModel, "png", scaleFactor);
    }

    protected DefaultCaseDiagramCanvas generateCaseDiagram(CmmnModel cmmnModel, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader, double scaleFactor) {
        this.prepareCmmnModel(cmmnModel);
        DefaultCaseDiagramCanvas caseDiagramCanvas = DefaultCaseDiagramGenerator.initCaseDiagramCanvas(cmmnModel, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader);
        for (Case caseModel : cmmnModel.getCases()) {
            Stage planModel = caseModel.getPlanModel();
            GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(planModel.getId());
            caseDiagramCanvas.drawStage(planModel.getName(), graphicInfo, scaleFactor);
            for (Criterion criterion : planModel.getExitCriteria()) {
                ActivityDrawInstruction criterionInstruction = this.activityDrawInstructions.get(criterion.getClass());
                criterionInstruction.draw(caseDiagramCanvas, cmmnModel, (CaseElement)criterion);
            }
            for (PlanItem planItem : caseModel.getPlanModel().getPlanItems()) {
                this.drawActivity(caseDiagramCanvas, cmmnModel, planItem, scaleFactor);
            }
        }
        for (Association association : cmmnModel.getAssociations()) {
            this.drawAssociation(caseDiagramCanvas, cmmnModel, association, scaleFactor);
        }
        return caseDiagramCanvas;
    }

    protected void prepareCmmnModel(CmmnModel cmmnModel) {
        ArrayList allGraphicInfos = new ArrayList();
        if (cmmnModel.getLocationMap() != null) {
            allGraphicInfos.addAll(cmmnModel.getLocationMap().values());
        }
        if (cmmnModel.getFlowLocationMap() != null) {
            for (List flowGraphicInfos : cmmnModel.getFlowLocationMap().values()) {
                allGraphicInfos.addAll(flowGraphicInfos);
            }
        }
        if (allGraphicInfos.size() > 0) {
            boolean needsTranslationX = false;
            boolean needsTranslationY = false;
            double lowestX = 0.0;
            double lowestY = 0.0;
            for (GraphicInfo graphicInfo : allGraphicInfos) {
                double x = graphicInfo.getX();
                double y = graphicInfo.getY();
                if (x < lowestX) {
                    needsTranslationX = true;
                    lowestX = x;
                }
                if (!(y < lowestY)) continue;
                needsTranslationY = true;
                lowestY = y;
            }
            if (needsTranslationX || needsTranslationY) {
                double translationX = Math.abs(lowestX);
                double translationY = Math.abs(lowestY);
                for (GraphicInfo graphicInfo : allGraphicInfos) {
                    if (needsTranslationX) {
                        graphicInfo.setX(graphicInfo.getX() + translationX);
                    }
                    if (!needsTranslationY) continue;
                    graphicInfo.setY(graphicInfo.getY() + translationY);
                }
            }
        }
    }

    protected void drawActivity(DefaultCaseDiagramCanvas caseDiagramCanvas, CmmnModel cmmnModel, PlanItem planItem, double scaleFactor) {
        ActivityDrawInstruction criterionInstruction;
        ActivityDrawInstruction drawInstruction = this.activityDrawInstructions.get(planItem.getPlanItemDefinition().getClass());
        if (drawInstruction != null) {
            drawInstruction.draw(caseDiagramCanvas, cmmnModel, (CaseElement)planItem);
        }
        if (planItem.getPlanItemDefinition() instanceof Stage) {
            for (PlanItem childPlanItem : ((Stage)planItem.getPlanItemDefinition()).getPlanItems()) {
                this.drawActivity(caseDiagramCanvas, cmmnModel, childPlanItem, scaleFactor);
            }
        }
        for (Criterion criterion : planItem.getEntryCriteria()) {
            criterionInstruction = this.activityDrawInstructions.get(criterion.getClass());
            criterionInstruction.draw(caseDiagramCanvas, cmmnModel, (CaseElement)criterion);
        }
        for (Criterion criterion : planItem.getExitCriteria()) {
            criterionInstruction = this.activityDrawInstructions.get(criterion.getClass());
            criterionInstruction.draw(caseDiagramCanvas, cmmnModel, (CaseElement)criterion);
        }
    }

    protected void drawAssociation(DefaultCaseDiagramCanvas caseDiagramCanvas, CmmnModel cmmnModel, Association association, double scaleFactor) {
        List<GraphicInfo> graphicInfoList;
        Criterion targetElement;
        String sourceRef = association.getSourceRef();
        String targetRef = association.getTargetRef();
        Criterion sourceElement = cmmnModel.getCriterion(sourceRef);
        if (sourceElement == null) {
            sourceElement = cmmnModel.findPlanItem(sourceRef);
        }
        if ((targetElement = cmmnModel.getCriterion(targetRef)) == null) {
            targetElement = cmmnModel.findPlanItem(targetRef);
        }
        if ((graphicInfoList = cmmnModel.getFlowLocationGraphicInfo(association.getId())) != null && graphicInfoList.size() > 0) {
            graphicInfoList = DefaultCaseDiagramGenerator.connectionPerfectionizer(caseDiagramCanvas, cmmnModel, (BaseElement)sourceElement, (BaseElement)targetElement, graphicInfoList);
            int[] xPoints = new int[graphicInfoList.size()];
            int[] yPoints = new int[graphicInfoList.size()];
            for (int i = 1; i < graphicInfoList.size(); ++i) {
                GraphicInfo graphicInfo = graphicInfoList.get(i);
                GraphicInfo previousGraphicInfo = graphicInfoList.get(i - 1);
                if (i == 1) {
                    xPoints[0] = (int)previousGraphicInfo.getX();
                    yPoints[0] = (int)previousGraphicInfo.getY();
                }
                xPoints[i] = (int)graphicInfo.getX();
                yPoints[i] = (int)graphicInfo.getY();
            }
            caseDiagramCanvas.drawAssociation(xPoints, yPoints, scaleFactor);
        }
    }

    protected static List<GraphicInfo> connectionPerfectionizer(DefaultCaseDiagramCanvas processDiagramCanvas, CmmnModel cmmnModel, BaseElement sourceElement, BaseElement targetElement, List<GraphicInfo> graphicInfoList) {
        GraphicInfo sourceGraphicInfo = cmmnModel.getGraphicInfo(sourceElement.getId());
        GraphicInfo targetGraphicInfo = cmmnModel.getGraphicInfo(targetElement.getId());
        DefaultCaseDiagramCanvas.SHAPE_TYPE sourceShapeType = DefaultCaseDiagramGenerator.getShapeType(sourceElement);
        DefaultCaseDiagramCanvas.SHAPE_TYPE targetShapeType = DefaultCaseDiagramGenerator.getShapeType(targetElement);
        return processDiagramCanvas.connectionPerfectionizer(sourceShapeType, targetShapeType, sourceGraphicInfo, targetGraphicInfo, graphicInfoList);
    }

    protected static DefaultCaseDiagramCanvas.SHAPE_TYPE getShapeType(BaseElement baseElement) {
        if (baseElement instanceof Task || baseElement instanceof Stage) {
            return DefaultCaseDiagramCanvas.SHAPE_TYPE.Rectangle;
        }
        if (baseElement instanceof Criterion) {
            return DefaultCaseDiagramCanvas.SHAPE_TYPE.Rhombus;
        }
        if (baseElement instanceof EventListener) {
            return DefaultCaseDiagramCanvas.SHAPE_TYPE.Ellipse;
        }
        return null;
    }

    protected static GraphicInfo getLineCenter(List<GraphicInfo> graphicInfoList) {
        GraphicInfo gi = new GraphicInfo();
        int[] xPoints = new int[graphicInfoList.size()];
        int[] yPoints = new int[graphicInfoList.size()];
        double length = 0.0;
        double[] lengths = new double[graphicInfoList.size()];
        lengths[0] = 0.0;
        for (int i = 1; i < graphicInfoList.size(); ++i) {
            GraphicInfo graphicInfo = graphicInfoList.get(i);
            GraphicInfo previousGraphicInfo = graphicInfoList.get(i - 1);
            if (i == 1) {
                xPoints[0] = (int)previousGraphicInfo.getX();
                yPoints[0] = (int)previousGraphicInfo.getY();
            }
            xPoints[i] = (int)graphicInfo.getX();
            yPoints[i] = (int)graphicInfo.getY();
            lengths[i] = length += Math.sqrt(Math.pow((int)graphicInfo.getX() - (int)previousGraphicInfo.getX(), 2.0) + Math.pow((int)graphicInfo.getY() - (int)previousGraphicInfo.getY(), 2.0));
        }
        double m = length / 2.0;
        int p1 = 0;
        int p2 = 1;
        int i = 1;
        while (i < lengths.length) {
            double len = lengths[i];
            p1 = i - 1;
            p2 = i++;
            if (len > m) break;
        }
        GraphicInfo graphicInfo1 = graphicInfoList.get(p1);
        GraphicInfo graphicInfo2 = graphicInfoList.get(p2);
        double AB = (int)graphicInfo2.getX() - (int)graphicInfo1.getX();
        double OA = (int)graphicInfo2.getY() - (int)graphicInfo1.getY();
        double OB = lengths[p2] - lengths[p1];
        double ob = m - lengths[p1];
        double ab = AB * ob / OB;
        double oa = OA * ob / OB;
        double mx = graphicInfo1.getX() + ab;
        double my = graphicInfo1.getY() + oa;
        gi.setX(mx);
        gi.setY(my);
        return gi;
    }

    protected static DefaultCaseDiagramCanvas initCaseDiagramCanvas(CmmnModel cmmnModel, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader) {
        double minX = Double.MAX_VALUE;
        double maxX = 0.0;
        double minY = Double.MAX_VALUE;
        double maxY = 0.0;
        for (Case caseModel : cmmnModel.getCases()) {
            Stage stage = caseModel.getPlanModel();
            GraphicInfo stageInfo = cmmnModel.getGraphicInfo(stage.getId());
            if (stageInfo.getX() + stageInfo.getWidth() > maxX) {
                maxX = stageInfo.getX() + stageInfo.getWidth();
            }
            if (stageInfo.getX() < minX) {
                minX = stageInfo.getX();
            }
            if (stageInfo.getY() + stageInfo.getHeight() > maxY) {
                maxY = stageInfo.getY() + stageInfo.getHeight();
            }
            if (!(stageInfo.getY() < minY)) continue;
            minY = stageInfo.getY();
        }
        return new DefaultCaseDiagramCanvas((int)maxX + 10, (int)maxY + 10, (int)minX, (int)minY, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader);
    }

    public Map<Class<? extends CmmnElement>, ActivityDrawInstruction> getActivityDrawInstructions() {
        return this.activityDrawInstructions;
    }

    public void setActivityDrawInstructions(Map<Class<? extends CmmnElement>, ActivityDrawInstruction> activityDrawInstructions) {
        this.activityDrawInstructions = activityDrawInstructions;
    }

    protected static interface ActivityDrawInstruction {
        public void draw(DefaultCaseDiagramCanvas var1, CmmnModel var2, CaseElement var3);
    }
}

