/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Process;
import org.flowable.cmmn.model.Stage;

public class CmmnModel {
    protected String id;
    protected String name;
    protected String targetNamespace;
    protected String expressionLanguage;
    protected String exporter;
    protected String exporterVersion;
    protected String author;
    protected Date creationDate;
    protected List<Case> cases = new ArrayList<Case>();
    protected List<Process> processes = new ArrayList<Process>();
    protected List<Association> associations = new ArrayList<Association>();
    protected Map<String, Criterion> criterionMap = new LinkedHashMap<String, Criterion>();
    protected Map<String, String> criterionTechnicalIdMap = new HashMap<String, String>();
    protected Map<String, GraphicInfo> locationMap = new LinkedHashMap<String, GraphicInfo>();
    protected Map<String, GraphicInfo> labelLocationMap = new LinkedHashMap<String, GraphicInfo>();
    protected Map<String, List<GraphicInfo>> flowLocationMap = new LinkedHashMap<String, List<GraphicInfo>>();
    protected Map<String, String> namespaceMap = new LinkedHashMap<String, String>();

    public void addCase(Case caze) {
        this.cases.add(caze);
    }

    public Case getPrimaryCase() {
        return this.cases.get(0);
    }

    public Case getCaseById(String id) {
        for (Case caze : this.cases) {
            if (!id.equals(caze.getId())) continue;
            return caze;
        }
        return null;
    }

    public void addProcess(Process process) {
        this.processes.add(process);
    }

    public Process getProcessById(String id) {
        for (Process process : this.processes) {
            if (!id.equals(process.getId())) continue;
            return process;
        }
        return null;
    }

    public PlanItemDefinition findPlanItemDefinition(String id) {
        Case caseModel2;
        PlanItemDefinition foundPlanItemDefinition = null;
        Iterator<Case> iterator = this.cases.iterator();
        while (iterator.hasNext() && (foundPlanItemDefinition = (caseModel2 = iterator.next()).getPlanModel().findPlanItemDefinition(id)) == null) {
        }
        if (foundPlanItemDefinition == null) {
            for (Case caseModel2 : this.cases) {
                Stage stage;
                Iterator<Stage> iterator2 = caseModel2.getPlanModel().findPlanItemDefinitionsOfType(Stage.class, true).iterator();
                while (iterator2.hasNext() && (foundPlanItemDefinition = (stage = iterator2.next()).findPlanItemDefinition(id)) == null) {
                }
                if (foundPlanItemDefinition == null) continue;
                break;
            }
        }
        return foundPlanItemDefinition;
    }

    public PlanItem findPlanItem(String id) {
        Case caseModel2;
        PlanItem foundPlanItem = null;
        Iterator<Case> iterator = this.cases.iterator();
        while (iterator.hasNext() && (foundPlanItem = (caseModel2 = iterator.next()).getPlanModel().findPlanItemInPlanFragmentOrUpwards(id)) == null) {
        }
        if (foundPlanItem == null) {
            for (Case caseModel2 : this.cases) {
                Stage stage;
                Iterator<Stage> iterator2 = caseModel2.getPlanModel().findPlanItemDefinitionsOfType(Stage.class, true).iterator();
                while (iterator2.hasNext() && (foundPlanItem = (stage = iterator2.next()).findPlanItemInPlanFragmentOrUpwards(id)) == null) {
                }
                if (foundPlanItem == null) continue;
                break;
            }
        }
        return foundPlanItem;
    }

    public void addAssociation(Association association) {
        this.associations.add(association);
    }

    public void addCriterion(String key, Criterion criterion) {
        this.criterionMap.put(key, criterion);
    }

    public Criterion getCriterion(String key) {
        return this.criterionMap.get(key);
    }

    public void addCriterionTechnicalId(String technicalId, String id) {
        this.criterionTechnicalIdMap.put(technicalId, id);
    }

    public String getCriterionId(String technicalId) {
        return this.criterionTechnicalIdMap.get(technicalId);
    }

    public void addGraphicInfo(String key, GraphicInfo graphicInfo) {
        this.locationMap.put(key, graphicInfo);
    }

    public GraphicInfo getGraphicInfo(String key) {
        return this.locationMap.get(key);
    }

    public void removeGraphicInfo(String key) {
        this.locationMap.remove(key);
    }

    public List<GraphicInfo> getFlowLocationGraphicInfo(String key) {
        return this.flowLocationMap.get(key);
    }

    public void removeFlowGraphicInfoList(String key) {
        this.flowLocationMap.remove(key);
    }

    public Map<String, GraphicInfo> getLocationMap() {
        return this.locationMap;
    }

    public Map<String, List<GraphicInfo>> getFlowLocationMap() {
        return this.flowLocationMap;
    }

    public GraphicInfo getLabelGraphicInfo(String key) {
        return this.labelLocationMap.get(key);
    }

    public void addLabelGraphicInfo(String key, GraphicInfo graphicInfo) {
        this.labelLocationMap.put(key, graphicInfo);
    }

    public void removeLabelGraphicInfo(String key) {
        this.labelLocationMap.remove(key);
    }

    public Map<String, GraphicInfo> getLabelLocationMap() {
        return this.labelLocationMap;
    }

    public void addFlowGraphicInfoList(String key, List<GraphicInfo> graphicInfoList) {
        this.flowLocationMap.put(key, graphicInfoList);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public void setExpressionLanguage(String expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    public String getExporter() {
        return this.exporter;
    }

    public void setExporter(String exporter) {
        this.exporter = exporter;
    }

    public String getExporterVersion() {
        return this.exporterVersion;
    }

    public void setExporterVersion(String exporterVersion) {
        this.exporterVersion = exporterVersion;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public List<Case> getCases() {
        return this.cases;
    }

    public void setCases(List<Case> cases) {
        this.cases = cases;
    }

    public List<Process> getProcesses() {
        return this.processes;
    }

    public void setProcesses(List<Process> processes) {
        this.processes = processes;
    }

    public List<Association> getAssociations() {
        return this.associations;
    }

    public void setAssociations(List<Association> associations) {
        this.associations = associations;
    }

    public void addNamespace(String prefix, String uri) {
        this.namespaceMap.put(prefix, uri);
    }

    public boolean containsNamespacePrefix(String prefix) {
        return this.namespaceMap.containsKey(prefix);
    }

    public String getNamespace(String prefix) {
        return this.namespaceMap.get(prefix);
    }

    public Map<String, String> getNamespaces() {
        return this.namespaceMap;
    }
}

