/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl;

import java.io.Serializable;
import org.flowable.content.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.api.management.TablePage;
import org.flowable.engine.common.api.management.TablePageQuery;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;

public class TablePageQueryImpl
implements TablePageQuery,
Command<TablePage>,
Serializable {
    private static final long serialVersionUID = 1L;
    transient CommandExecutor commandExecutor;
    protected String tableName;
    protected String order;
    protected int firstResult;
    protected int maxResults;

    public TablePageQueryImpl() {
    }

    public TablePageQueryImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public TablePageQueryImpl tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TablePageQueryImpl orderAsc(String column) {
        this.addOrder(column, "asc");
        return this;
    }

    public TablePageQueryImpl orderDesc(String column) {
        this.addOrder(column, "desc");
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    protected void addOrder(String column, String sortOrder) {
        this.order = this.order == null ? "" : this.order + ", ";
        this.order = this.order + column + " " + sortOrder;
    }

    public TablePage listPage(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        return (TablePage)this.commandExecutor.execute((Command)this);
    }

    public TablePage execute(CommandContext commandContext) {
        return CommandContextUtil.getTableDataManager(commandContext).getTablePage(this, this.firstResult, this.maxResults);
    }

    public String getOrder() {
        return this.order;
    }
}

