/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl;

import org.flowable.content.api.ContentManagementService;
import org.flowable.content.api.ContentService;
import org.flowable.content.engine.ContentEngine;
import org.flowable.content.engine.ContentEngineConfiguration;
import org.flowable.content.engine.ContentEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentEngineImpl
implements ContentEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentEngineImpl.class);
    protected String name;
    protected ContentManagementService managementService;
    protected ContentService contentService;
    protected ContentEngineConfiguration engineConfiguration;

    public ContentEngineImpl(ContentEngineConfiguration engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
        this.name = engineConfiguration.getEngineName();
        this.managementService = engineConfiguration.getContentManagementService();
        this.contentService = engineConfiguration.getContentService();
        if (engineConfiguration.getSchemaManagementCmd() != null) {
            engineConfiguration.getCommandExecutor().execute(engineConfiguration.getSchemaCommandConfig(), engineConfiguration.getSchemaManagementCmd());
        }
        if (this.name == null) {
            LOGGER.info("default flowable ContentEngine created");
        } else {
            LOGGER.info("ContentEngine {} created", (Object)this.name);
        }
        ContentEngines.registerContentEngine(this);
    }

    @Override
    public void close() {
        ContentEngines.unregister(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ContentManagementService getContentManagementService() {
        return this.managementService;
    }

    @Override
    public ContentService getContentService() {
        return this.contentService;
    }

    @Override
    public ContentEngineConfiguration getContentEngineConfiguration() {
        return this.engineConfiguration;
    }
}

