/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.history;

import javax.servlet.http.HttpServletResponse;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.flowable.dmn.api.DmnHistoricDecisionExecution;
import org.flowable.dmn.api.DmnHistoryService;
import org.flowable.dmn.rest.service.api.DmnRestResponseFactory;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BaseHistoricDecisionExecutionResource {
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected DmnRestResponseFactory dmnRestResponseFactory;
    @Autowired
    protected DmnHistoryService dmnHistoryService;

    protected DmnHistoricDecisionExecution getHistoricDecisionExecutionFromRequest(String decisionExecutionId) {
        DmnHistoricDecisionExecution decisionExecution = (DmnHistoricDecisionExecution)this.dmnHistoryService.createHistoricDecisionExecutionQuery().id(decisionExecutionId).singleResult();
        if (decisionExecution == null) {
            throw new FlowableObjectNotFoundException("Could not find a decision execution with id '" + decisionExecution);
        }
        return decisionExecution;
    }

    protected String getExecutionAuditData(String decisionExecutionId, HttpServletResponse response) {
        if (decisionExecutionId == null) {
            throw new FlowableIllegalArgumentException("No decision execution id provided");
        }
        DmnHistoricDecisionExecution decisionExecution = this.getHistoricDecisionExecutionFromRequest(decisionExecutionId);
        response.setContentType("application/json");
        return decisionExecution.getExecutionJson();
    }
}

