/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.repository;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.rest.service.api.DmnRestResponseFactory;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BaseDecisionTableResource {
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected DmnRestResponseFactory dmnRestResponseFactory;
    @Autowired
    protected DmnRepositoryService dmnRepositoryService;

    protected DmnDecisionTable getDecisionTableFromRequest(String decisionTableId) {
        DmnDecisionTable decisionTable = this.dmnRepositoryService.getDecisionTable(decisionTableId);
        if (decisionTable == null) {
            throw new FlowableObjectNotFoundException("Could not find a decision table with id '" + decisionTableId);
        }
        return decisionTable;
    }

    protected byte[] getDeploymentResourceData(String deploymentId, String resourceId, HttpServletResponse response) {
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("No deployment id provided");
        }
        if (resourceId == null) {
            throw new FlowableIllegalArgumentException("No resource id provided");
        }
        DmnDeployment deployment = (DmnDeployment)this.dmnRepositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId);
        }
        List resourceList = this.dmnRepositoryService.getDeploymentResourceNames(deploymentId);
        if (resourceList.contains(resourceId)) {
            InputStream resourceStream = this.dmnRepositoryService.getResourceAsStream(deploymentId, resourceId);
            String contentType = this.contentTypeResolver.resolveContentType(resourceId);
            response.setContentType(contentType);
            try {
                return IOUtils.toByteArray((InputStream)resourceStream);
            }
            catch (Exception e) {
                throw new FlowableException("Error converting resource stream", (Throwable)e);
            }
        }
        throw new FlowableObjectNotFoundException("Could not find a resource with id '" + resourceId + "' in deployment '" + deploymentId);
    }
}

