/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.repository;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDmnDeploymentResourceDataResource {
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected DmnRepositoryService dmnRepositoryService;

    protected byte[] getDmnDeploymentResourceData(String deploymentId, String resourceName, HttpServletResponse response) {
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("No deployment id provided");
        }
        if (resourceName == null) {
            throw new FlowableIllegalArgumentException("No resource name provided");
        }
        DmnDeployment deployment = (DmnDeployment)this.dmnRepositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a DMN deployment with id '" + deploymentId);
        }
        List resourceList = this.dmnRepositoryService.getDeploymentResourceNames(deploymentId);
        if (resourceList.contains(resourceName)) {
            InputStream resourceStream = this.dmnRepositoryService.getResourceAsStream(deploymentId, resourceName);
            String contentType = this.contentTypeResolver.resolveContentType(resourceName);
            response.setContentType(contentType);
            try {
                return IOUtils.toByteArray((InputStream)resourceStream);
            }
            catch (Exception e) {
                throw new FlowableException("Error converting resource stream", (Throwable)e);
            }
        }
        throw new FlowableObjectNotFoundException("Could not find a resource with name '" + resourceName + "' in deployment '" + deploymentId);
    }
}

