/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.spring.autodeployment;

import java.io.IOException;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.form.api.FormDeploymentBuilder;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.spring.autodeployment.AbstractAutoDeploymentStrategy;
import org.springframework.core.io.Resource;

public class DefaultAutoDeploymentStrategy
extends AbstractAutoDeploymentStrategy {
    public static final String DEPLOYMENT_MODE = "default";

    @Override
    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    @Override
    public void deployResources(String deploymentNameHint, Resource[] resources, FormRepositoryService repositoryService) {
        FormDeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(deploymentNameHint);
        for (Resource resource : resources) {
            String resourceName = this.determineResourceName(resource);
            try {
                deploymentBuilder.addInputStream(resourceName, resource.getInputStream());
            }
            catch (IOException e) {
                throw new FlowableException("couldn't auto deploy resource '" + resource + "': " + e.getMessage(), (Throwable)e);
            }
        }
        deploymentBuilder.deploy();
    }
}

