/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.util.List;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.impl.JobQueryImpl;
import org.flowable.job.service.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnacquireOwnedJobsCmd
implements Command<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnacquireOwnedJobsCmd.class);
    private final String lockOwner;
    private final String tenantId;

    public UnacquireOwnedJobsCmd(String lockOwner, String tenantId) {
        this.lockOwner = lockOwner;
        this.tenantId = tenantId;
    }

    public Void execute(CommandContext commandContext) {
        JobQueryImpl jobQuery = new JobQueryImpl(commandContext);
        jobQuery.lockOwner(this.lockOwner);
        jobQuery.jobTenantId(this.tenantId);
        List<Job> jobs = CommandContextUtil.getJobEntityManager(commandContext).findJobsByQueryCriteria(jobQuery);
        for (Job job : jobs) {
            this.logJobUnlocking(job);
            CommandContextUtil.getJobManager(commandContext).unacquire((JobInfo)job);
        }
        return null;
    }

    protected void logJobUnlocking(Job job) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unacquiring job {} with owner {} and tenantId {}", new Object[]{job, this.lockOwner, this.tenantId});
        }
    }
}

