/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.DefaultScope;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

abstract class LegacyDefaultScope
implements Iterable<Scope> {
    private List<Scope> scopeList;

    LegacyDefaultScope() {
    }

    @Override
    public Iterator<Scope> iterator() {
        List<Scope> list = this.scopeList;
        if (list == null) {
            this.scopeList = list = Collections.singletonList(this.createScope());
        }
        return list.iterator();
    }

    abstract Scope createScope();

    static Iterable<Scope> topScope(final Object global) {
        return new LegacyDefaultScope(){

            @Override
            Scope createScope() {
                Object globalObject = global != null && InteropLibrary.getUncached().hasMembers(global) ? global : new EmptyGlobalBindings();
                return Scope.newBuilder("global", globalObject).build();
            }
        };
    }

    static Iterable<Scope> lexicalScope(final Node node, final Frame frame, final Class<? extends TruffleLanguage<?>> language) {
        return new LegacyDefaultScope(){

            @Override
            Scope createScope() {
                RootNode root = node.getRootNode();
                String name = root.getName();
                if (name == null) {
                    name = "local";
                }
                return Scope.newBuilder(name, DefaultScope.getVariables(root, frame, language)).node(root).arguments(DefaultScope.getArguments(frame != null ? frame.getArguments() : new Object[]{}, language)).build();
            }
        };
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class EmptyGlobalBindings
    implements TruffleObject {
        EmptyGlobalBindings() {
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        Object readMember(String member) throws UnknownIdentifierException {
            throw UnknownIdentifierException.create(member);
        }

        @ExportMessage
        Object getMembers(boolean includeInternal) {
            return DefaultScope.VariableNamesObject.EMPTY;
        }

        @ExportMessage
        boolean isMemberReadable(String member) {
            return false;
        }
    }
}

