/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.ejb.event.CallbackHandlerConsumer;
import org.hibernate.ejb.event.EJB3AutoFlushEventListener;
import org.hibernate.ejb.event.EJB3DeleteEventListener;
import org.hibernate.ejb.event.EJB3FlushEntityEventListener;
import org.hibernate.ejb.event.EJB3FlushEventListener;
import org.hibernate.ejb.event.EJB3MergeEventListener;
import org.hibernate.ejb.event.EJB3PersistEventListener;
import org.hibernate.ejb.event.EJB3PersistOnFlushEventListener;
import org.hibernate.ejb.event.EJB3PostDeleteEventListener;
import org.hibernate.ejb.event.EJB3PostInsertEventListener;
import org.hibernate.ejb.event.EJB3PostLoadEventListener;
import org.hibernate.ejb.event.EJB3PostUpdateEventListener;
import org.hibernate.ejb.event.EJB3SaveEventListener;
import org.hibernate.ejb.event.EJB3SaveOrUpdateEventListener;
import org.hibernate.ejb.event.EntityCallbackHandler;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.EventListeners;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.event.def.DefaultPostLoadEventListener;
import org.hibernate.event.def.DefaultPreLoadEventListener;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.secure.JACCPreDeleteEventListener;
import org.hibernate.secure.JACCPreInsertEventListener;
import org.hibernate.secure.JACCPreLoadEventListener;
import org.hibernate.secure.JACCPreUpdateEventListener;
import org.hibernate.secure.JACCSecurityListener;

public class EventListenerConfigurator {
    private static final Object[] READER_METHOD_ARGS = new Object[0];
    private Ejb3Configuration configuration;
    private boolean isSecurity;

    public EventListenerConfigurator(Ejb3Configuration configuration) {
        this.configuration = configuration;
        EventListeners listenerConfig = configuration.getEventListeners();
        listenerConfig.setFlushEventListeners(new FlushEventListener[]{EJB3FlushEventListener.INSTANCE});
        listenerConfig.setAutoFlushEventListeners(new AutoFlushEventListener[]{EJB3AutoFlushEventListener.INSTANCE});
        listenerConfig.setDeleteEventListeners(new DeleteEventListener[]{new EJB3DeleteEventListener()});
        listenerConfig.setFlushEntityEventListeners(new FlushEntityEventListener[]{new EJB3FlushEntityEventListener()});
        listenerConfig.setMergeEventListeners(new MergeEventListener[]{new EJB3MergeEventListener()});
        listenerConfig.setPersistEventListeners(new PersistEventListener[]{new EJB3PersistEventListener()});
        listenerConfig.setPersistOnFlushEventListeners(new PersistEventListener[]{new EJB3PersistOnFlushEventListener()});
        listenerConfig.setSaveEventListeners(new SaveOrUpdateEventListener[]{new EJB3SaveEventListener()});
        listenerConfig.setSaveOrUpdateEventListeners(new SaveOrUpdateEventListener[]{new EJB3SaveOrUpdateEventListener()});
        listenerConfig.setPreInsertEventListeners(new PreInsertEventListener[]{new JACCPreInsertEventListener()});
        listenerConfig.setPreUpdateEventListeners(new PreUpdateEventListener[]{new JACCPreUpdateEventListener()});
        listenerConfig.setPreDeleteEventListeners(new PreDeleteEventListener[]{new JACCPreDeleteEventListener()});
        listenerConfig.setPreLoadEventListeners(new PreLoadEventListener[]{new DefaultPreLoadEventListener(), new JACCPreLoadEventListener()});
        listenerConfig.setPostDeleteEventListeners(new PostDeleteEventListener[]{new EJB3PostDeleteEventListener()});
        listenerConfig.setPostInsertEventListeners(new PostInsertEventListener[]{new EJB3PostInsertEventListener()});
        listenerConfig.setPostLoadEventListeners(new PostLoadEventListener[]{new EJB3PostLoadEventListener(), new DefaultPostLoadEventListener()});
        EJB3PostUpdateEventListener postUpdateEventListener = new EJB3PostUpdateEventListener();
        listenerConfig.setPostUpdateEventListeners(new PostUpdateEventListener[]{postUpdateEventListener});
    }

    public void setProperties(Properties properties) {
        if (properties.containsKey("hibernate.jacc.enabled")) {
            this.isSecurity = true;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (!name.startsWith("hibernate.ejb.event")) continue;
            String type = name.substring("hibernate.ejb.event".length() + 1);
            StringTokenizer st = new StringTokenizer(properties.getProperty(name), " ,", false);
            ArrayList<String> listeners = new ArrayList<String>();
            while (st.hasMoreElements()) {
                listeners.add((String)st.nextElement());
            }
            this.configuration.setListeners(type, listeners.toArray(new String[listeners.size()]));
        }
    }

    public void configure() {
        EntityCallbackHandler callbackHandler = new EntityCallbackHandler();
        this.configuration.buildMappings();
        Iterator classes = this.configuration.getClassMappings();
        ReflectionManager reflectionManager = this.configuration.getHibernateConfiguration().getReflectionManager();
        while (classes.hasNext()) {
            PersistentClass clazz = (PersistentClass)classes.next();
            if (clazz.getClassName() == null) continue;
            try {
                callbackHandler.add(reflectionManager.classForName(clazz.getClassName(), this.getClass()), reflectionManager);
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("entity class not found: " + clazz.getNodeName(), (Throwable)e);
            }
        }
        EventListeners listenerConfig = this.configuration.getEventListeners();
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(listenerConfig.getClass(), Object.class);
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            try {
                int max = pds.length;
                for (int i = 0; i < max; ++i) {
                    Object[] listenersArray;
                    Object listeners = pds[i].getReadMethod().invoke((Object)listenerConfig, READER_METHOD_ARGS);
                    if (listeners == null) {
                        throw new HibernateException("Listener [" + pds[i].getName() + "] was null");
                    }
                    if (!(listeners instanceof Object[])) continue;
                    int securityListenersNbr = 0;
                    for (Object listener : listenersArray = (Object[])listeners) {
                        if (listener != null && listener instanceof CallbackHandlerConsumer) {
                            ((CallbackHandlerConsumer)listener).setCallbackHandler(callbackHandler);
                        }
                        if (listener == null || !(listener instanceof JACCSecurityListener) || this.isSecurity) continue;
                        ++securityListenersNbr;
                    }
                    if (this.isSecurity) continue;
                    Class<?> clazz = pds[i].getReadMethod().getReturnType().getComponentType();
                    Object newArray = Array.newInstance(clazz, listenersArray.length - securityListenersNbr);
                    int index = 0;
                    for (Object listener : listenersArray) {
                        if (listener != null && listener instanceof JACCSecurityListener) continue;
                        Array.set(newArray, index++, listener);
                    }
                    pds[i].getWriteMethod().invoke((Object)listenerConfig, newArray);
                }
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new HibernateException("Unable to validate listener config", t);
            }
        }
        catch (Exception t) {
            throw new HibernateException("Unable to copy listeners", (Throwable)t);
        }
        finally {
            if (beanInfo != null) {
                Introspector.flushFromCaches(listenerConfig.getClass());
            }
        }
    }
}

