/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;

public class SearchModeSearchDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler
implements InitializingBean {
    private static final String SQL_PREFIX = "Select count('x') from ";
    @NotNull
    private String fieldUser;
    @NotNull
    private String fieldPassword;
    @NotNull
    private String tableUsers;
    private String sql;

    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        int count;
        String username = credential.getUsername();
        String encyptedPassword = this.getPasswordEncoder().encode(credential.getPassword());
        try {
            count = (Integer)this.getJdbcTemplate().queryForObject(this.sql, Integer.class, new Object[]{username, encyptedPassword});
        }
        catch (DataAccessException e) {
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)e);
        }
        if (count == 0) {
            throw new FailedLoginException(String.valueOf(username) + " not found with SQL query.");
        }
        return this.createHandlerResult((Credential)credential, (Principal)new SimplePrincipal(username), null);
    }

    public void afterPropertiesSet() throws Exception {
        this.sql = SQL_PREFIX + this.tableUsers + " WHERE " + this.fieldUser + " = ? AND " + this.fieldPassword + " = ?";
    }

    public final void setFieldPassword(String fieldPassword) {
        this.fieldPassword = fieldPassword;
    }

    public final void setFieldUser(String fieldUser) {
        this.fieldUser = fieldUser;
    }

    public final void setTableUsers(String tableUsers) {
        this.tableUsers = tableUsers;
    }
}

