/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SamlUtils {
    private static final String JSR_105_PROVIDER = "org.jcp.xml.dsig.internal.dom.XMLDSigRI";
    private static final String SAML_PROTOCOL_NS_URI_V20 = "urn:oasis:names:tc:SAML:2.0:protocol";

    private SamlUtils() {
    }

    public static String signSamlResponse(String samlResponse, PrivateKey privateKey, PublicKey publicKey) {
        Document doc = SamlUtils.constructDocumentFromXmlString(samlResponse);
        if (doc != null) {
            Element signedElement = SamlUtils.signSamlElement(doc.getRootElement(), privateKey, publicKey);
            doc.setRootElement((Element)signedElement.detach());
            return new XMLOutputter().outputString(doc);
        }
        throw new RuntimeException("Error signing SAML Response: Null document");
    }

    public static Document constructDocumentFromXmlString(String xmlString) {
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            return builder.build((InputStream)new ByteArrayInputStream(xmlString.getBytes()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Element signSamlElement(Element element, PrivateKey privKey, PublicKey pubKey) {
        try {
            SignatureMethod signatureMethod;
            String providerName = System.getProperty("jsr105Provider", JSR_105_PROVIDER);
            XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
            List<Transform> envelopedTransform = Collections.singletonList(sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            Reference ref = sigFactory.newReference("", sigFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), envelopedTransform, null, null);
            if (pubKey instanceof DSAPublicKey) {
                signatureMethod = sigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null);
            } else if (pubKey instanceof RSAPublicKey) {
                signatureMethod = sigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
            } else {
                throw new RuntimeException("Error signing SAML element: Unsupported type of key");
            }
            CanonicalizationMethod canonicalizationMethod = sigFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null);
            SignedInfo signedInfo = sigFactory.newSignedInfo(canonicalizationMethod, signatureMethod, Collections.singletonList(ref));
            KeyInfoFactory keyInfoFactory = sigFactory.getKeyInfoFactory();
            KeyValue keyValuePair = keyInfoFactory.newKeyValue(pubKey);
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(keyValuePair));
            org.w3c.dom.Element w3cElement = SamlUtils.toDom(element);
            DOMSignContext dsc = new DOMSignContext(privKey, (Node)w3cElement);
            Node xmlSigInsertionPoint = SamlUtils.getXmlSignatureInsertLocation(w3cElement);
            dsc.setNextSibling(xmlSigInsertionPoint);
            XMLSignature signature = sigFactory.newXMLSignature(signedInfo, keyInfo);
            signature.sign(dsc);
            return SamlUtils.toJdom(w3cElement);
        }
        catch (Exception e) {
            throw new RuntimeException("Error signing SAML element: " + e.getMessage(), e);
        }
    }

    private static Node getXmlSignatureInsertLocation(org.w3c.dom.Element elem) {
        Node insertLocation = null;
        NodeList nodeList = elem.getElementsByTagNameNS(SAML_PROTOCOL_NS_URI_V20, "Extensions");
        if (nodeList.getLength() != 0) {
            insertLocation = nodeList.item(nodeList.getLength() - 1);
        } else {
            nodeList = elem.getElementsByTagNameNS(SAML_PROTOCOL_NS_URI_V20, "Status");
            insertLocation = nodeList.item(nodeList.getLength() - 1);
        }
        return insertLocation;
    }

    private static org.w3c.dom.Element toDom(Element element) {
        return SamlUtils.toDom(element.getDocument()).getDocumentElement();
    }

    private static org.w3c.dom.Document toDom(Document doc) {
        try {
            XMLOutputter xmlOutputter = new XMLOutputter();
            StringWriter elemStrWriter = new StringWriter();
            xmlOutputter.output(doc, (Writer)elemStrWriter);
            byte[] xmlBytes = elemStrWriter.toString().getBytes();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            return dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xmlBytes));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Element toJdom(org.w3c.dom.Element e) {
        return new DOMBuilder().build(e);
    }
}

