/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.web.view;

import java.util.Collection;
import java.util.Map;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.support.saml.web.view.AbstractSaml10ResponseView;
import org.joda.time.DateTime;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.Attribute;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.AttributeValue;
import org.opensaml.saml1.core.Audience;
import org.opensaml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml1.core.AuthenticationStatement;
import org.opensaml.saml1.core.Conditions;
import org.opensaml.saml1.core.ConfirmationMethod;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml1.core.Response;
import org.opensaml.saml1.core.StatusCode;
import org.opensaml.saml1.core.Subject;
import org.opensaml.saml1.core.SubjectConfirmation;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;

public final class Saml10SuccessResponseView
extends AbstractSaml10ResponseView {
    private static final String NAMESPACE = "http://www.ja-sig.org/products/cas/";
    private static final String REMEMBER_ME_ATTRIBUTE_NAME = "longTermAuthenticationRequestTokenUsed";
    private static final String REMEMBER_ME_ATTRIBUTE_VALUE = "true";
    private static final String CONFIRMATION_METHOD = "urn:oasis:names:tc:SAML:1.0:cm:artifact";
    private final XSStringBuilder attrValueBuilder = new XSStringBuilder();
    @NotNull
    private String issuer;
    @Min(value=1000L)
    private long issueLength = 30000L;
    @NotNull
    private String rememberMeAttributeName = "longTermAuthenticationRequestTokenUsed";

    @Override
    protected void prepareResponse(Response response, Map<String, Object> model) {
        Authentication authentication = this.getAssertionFrom(model).getPrimaryAuthentication();
        DateTime issuedAt = response.getIssueInstant();
        Service service = this.getAssertionFrom(model).getService();
        Object o = authentication.getAttributes().get("org.jasig.cas.authentication.principal.REMEMBER_ME");
        boolean isRemembered = o == Boolean.TRUE && !this.getAssertionFrom(model).isFromNewLogin();
        Assertion assertion = this.newSamlObject(Assertion.class);
        assertion.setID(this.generateId());
        assertion.setIssueInstant(issuedAt);
        assertion.setIssuer(this.issuer);
        assertion.setConditions(this.newConditions(issuedAt, service.getId()));
        AuthenticationStatement authnStatement = this.newAuthenticationStatement(authentication);
        assertion.getAuthenticationStatements().add(authnStatement);
        Map attributes = authentication.getPrincipal().getAttributes();
        if (!attributes.isEmpty() || isRemembered) {
            assertion.getAttributeStatements().add(this.newAttributeStatement(this.newSubject(authentication.getPrincipal().getId()), attributes, isRemembered));
        }
        response.setStatus(this.newStatus(StatusCode.SUCCESS, null));
        response.getAssertions().add(assertion);
    }

    private Conditions newConditions(DateTime issuedAt, String serviceId) {
        Conditions conditions = this.newSamlObject(Conditions.class);
        conditions.setNotBefore(issuedAt);
        conditions.setNotOnOrAfter(issuedAt.plus(this.issueLength));
        AudienceRestrictionCondition audienceRestriction = this.newSamlObject(AudienceRestrictionCondition.class);
        Audience audience = this.newSamlObject(Audience.class);
        audience.setUri(serviceId);
        audienceRestriction.getAudiences().add(audience);
        conditions.getAudienceRestrictionConditions().add(audienceRestriction);
        return conditions;
    }

    private Subject newSubject(String identifier) {
        SubjectConfirmation confirmation = this.newSamlObject(SubjectConfirmation.class);
        ConfirmationMethod method = this.newSamlObject(ConfirmationMethod.class);
        method.setConfirmationMethod(CONFIRMATION_METHOD);
        confirmation.getConfirmationMethods().add(method);
        NameIdentifier nameIdentifier = this.newSamlObject(NameIdentifier.class);
        nameIdentifier.setNameIdentifier(identifier);
        Subject subject = this.newSamlObject(Subject.class);
        subject.setNameIdentifier(nameIdentifier);
        subject.setSubjectConfirmation(confirmation);
        return subject;
    }

    private AuthenticationStatement newAuthenticationStatement(Authentication authentication) {
        String authenticationMethod = (String)authentication.getAttributes().get("samlAuthenticationStatementAuthMethod");
        AuthenticationStatement authnStatement = this.newSamlObject(AuthenticationStatement.class);
        authnStatement.setAuthenticationInstant(new DateTime((Object)authentication.getAuthenticatedDate()));
        authnStatement.setAuthenticationMethod(authenticationMethod != null ? authenticationMethod : "urn:oasis:names:tc:SAML:1.0:am:unspecified");
        authnStatement.setSubject(this.newSubject(authentication.getPrincipal().getId()));
        return authnStatement;
    }

    private AttributeStatement newAttributeStatement(Subject subject, Map<String, Object> attributes, boolean isRemembered) {
        AttributeStatement attrStatement = this.newSamlObject(AttributeStatement.class);
        attrStatement.setSubject(subject);
        for (Map.Entry<String, Object> e : attributes.entrySet()) {
            if (e.getValue() instanceof Collection && ((Collection)e.getValue()).isEmpty()) {
                this.logger.info("Skipping attribute {} because it does not have any values.", (Object)e.getKey());
                continue;
            }
            Attribute attribute = this.newSamlObject(Attribute.class);
            attribute.setAttributeName(e.getKey());
            attribute.setAttributeNamespace(NAMESPACE);
            if (e.getValue() instanceof Collection) {
                Collection c = (Collection)e.getValue();
                for (Object value : c) {
                    attribute.getAttributeValues().add(this.newAttributeValue(value));
                }
            } else {
                attribute.getAttributeValues().add(this.newAttributeValue(e.getValue()));
            }
            attrStatement.getAttributes().add(attribute);
        }
        if (isRemembered) {
            Attribute attribute = this.newSamlObject(Attribute.class);
            attribute.setAttributeName(this.rememberMeAttributeName);
            attribute.setAttributeNamespace(NAMESPACE);
            attribute.getAttributeValues().add(this.newAttributeValue(REMEMBER_ME_ATTRIBUTE_VALUE));
            attrStatement.getAttributes().add(attribute);
        }
        return attrStatement;
    }

    private XSString newAttributeValue(Object value) {
        XSString stringValue = (XSString)this.attrValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        if (value instanceof String) {
            stringValue.setValue((String)value);
        } else {
            stringValue.setValue(value.toString());
        }
        return stringValue;
    }

    public void setIssueLength(long issueLength) {
        this.issueLength = issueLength;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setRememberMeAttributeName(String rememberMeAttributeName) {
        this.rememberMeAttributeName = rememberMeAttributeName;
    }
}

