/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationContext;
import org.jasig.cas.authentication.AuthenticationContextBuilder;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationSystemSupport;
import org.jasig.cas.authentication.AuthenticationTransaction;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.DefaultAuthenticationContextBuilder;
import org.jasig.cas.authentication.DefaultAuthenticationSystemSupport;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.MessageDescriptor;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.AbstractTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketCreationException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.stereotype.Component;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@Component(value="authenticationViaFormAction")
public class AuthenticationViaFormAction {
    public static final String SUCCESS_WITH_WARNINGS = "successWithWarnings";
    public static final String AUTHENTICATION_FAILURE = "authenticationFailure";
    public static final String PUBLIC_WORKSTATION_ATTRIBUTE = "publicWorkstation";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private CookieGenerator warnCookieGenerator;
    @NotNull
    @Autowired(required=false)
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport = new DefaultAuthenticationSystemSupport();

    public final Event submit(RequestContext context, Credential credential, MessageContext messageContext) {
        if (this.isRequestAskingForServiceTicket(context)) {
            return this.grantServiceTicket(context, credential);
        }
        return this.createTicketGrantingTicket(context, credential, messageContext);
    }

    protected boolean isRequestAskingForServiceTicket(RequestContext context) {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        return StringUtils.isNotBlank((CharSequence)context.getRequestParameters().get("renew")) && ticketGrantingTicketId != null && service != null;
    }

    protected Event grantServiceTicket(RequestContext context, Credential credential) {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        try {
            WebApplicationService service = WebUtils.getService((RequestContext)context);
            DefaultAuthenticationContextBuilder builder = new DefaultAuthenticationContextBuilder(this.authenticationSystemSupport.getPrincipalElectionStrategy());
            AuthenticationTransaction transaction = AuthenticationTransaction.wrap((Credential[])new Credential[]{credential});
            this.authenticationSystemSupport.getAuthenticationTransactionManager().handle(transaction, (AuthenticationContextBuilder)builder);
            AuthenticationContext authenticationContext = builder.build((Service)service);
            ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, (Service)service, authenticationContext);
            WebUtils.putServiceTicketInRequestScope((RequestContext)context, (ServiceTicket)serviceTicketId);
            WebUtils.putWarnCookieIfRequestParameterPresent((CookieGenerator)this.warnCookieGenerator, (RequestContext)context);
            return this.newEvent("warn");
        }
        catch (AuthenticationException e) {
            return this.newEvent(AUTHENTICATION_FAILURE, (Exception)((Object)e));
        }
        catch (TicketCreationException ticketCreationException) {
            this.logger.warn("Invalid attempt to access service using renew=true with different credential. Ending SSO session.");
            this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
        }
        catch (AbstractTicketException e) {
            return this.newEvent("error", (Exception)((Object)e));
        }
        return this.newEvent("error");
    }

    protected Event createTicketGrantingTicket(RequestContext context, Credential credential, MessageContext messageContext) {
        try {
            WebApplicationService service = WebUtils.getService((RequestContext)context);
            DefaultAuthenticationContextBuilder builder = new DefaultAuthenticationContextBuilder(this.authenticationSystemSupport.getPrincipalElectionStrategy());
            AuthenticationTransaction transaction = AuthenticationTransaction.wrap((Credential[])new Credential[]{credential});
            this.authenticationSystemSupport.getAuthenticationTransactionManager().handle(transaction, (AuthenticationContextBuilder)builder);
            AuthenticationContext authenticationContext = builder.build((Service)service);
            TicketGrantingTicket tgt = this.centralAuthenticationService.createTicketGrantingTicket(authenticationContext);
            WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (TicketGrantingTicket)tgt);
            WebUtils.putWarnCookieIfRequestParameterPresent((CookieGenerator)this.warnCookieGenerator, (RequestContext)context);
            AuthenticationViaFormAction.putPublicWorkstationToFlowIfRequestParameterPresent(context);
            if (this.addWarningMessagesToMessageContextIfNeeded(tgt, messageContext)) {
                return this.newEvent(SUCCESS_WITH_WARNINGS);
            }
            return this.newEvent("success");
        }
        catch (AuthenticationException e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            return this.newEvent(AUTHENTICATION_FAILURE, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            return this.newEvent("error", e);
        }
    }

    protected boolean addWarningMessagesToMessageContextIfNeeded(TicketGrantingTicket tgtId, MessageContext messageContext) {
        boolean foundAndAddedWarnings = false;
        for (Map.Entry entry : tgtId.getAuthentication().getSuccesses().entrySet()) {
            for (MessageDescriptor message : ((HandlerResult)entry.getValue()).getWarnings()) {
                AuthenticationViaFormAction.addWarningToContext(messageContext, message);
                foundAndAddedWarnings = true;
            }
        }
        return foundAndAddedWarnings;
    }

    private static void putPublicWorkstationToFlowIfRequestParameterPresent(RequestContext context) {
        if (StringUtils.isNotBlank((CharSequence)context.getExternalContext().getRequestParameterMap().get(PUBLIC_WORKSTATION_ATTRIBUTE))) {
            context.getFlowScope().put(PUBLIC_WORKSTATION_ATTRIBUTE, (Object)Boolean.TRUE);
        }
    }

    private Event newEvent(String id) {
        return new Event((Object)this, id);
    }

    private Event newEvent(String id, Exception error) {
        return new Event((Object)this, id, (AttributeMap)new LocalAttributeMap("error", (Object)error));
    }

    private static void addWarningToContext(MessageContext context, MessageDescriptor warning) {
        MessageBuilder builder = new MessageBuilder().warning().code(warning.getCode()).defaultText(warning.getDefaultMessage()).args((Object[])warning.getParams());
        context.addMessage(builder.build());
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setWarnCookieGenerator(CookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }

    public void setAuthenticationSystemSupport(AuthenticationSystemSupport authenticationSystemSupport) {
        this.authenticationSystemSupport = authenticationSystemSupport;
    }
}

