/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.jasig.cas.web.support.CookieRetrievingCookieGenerator;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class InitialFlowSetupAction
extends AbstractAction {
    @NotNull
    private CookieRetrievingCookieGenerator warnCookieGenerator;
    @NotNull
    private CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    @NotNull
    @Size(min=1)
    private List<ArgumentExtractor> argumentExtractors;
    private boolean pathPopulated = false;

    protected Event doExecute(RequestContext context) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        if (!this.pathPopulated) {
            String contextPath = context.getExternalContext().getContextPath();
            String cookiePath = StringUtils.hasText((String)contextPath) ? String.valueOf(contextPath) + "/" : "/";
            this.logger.info((Object)("Setting path for cookies to: " + cookiePath));
            this.warnCookieGenerator.setCookiePath(cookiePath);
            this.ticketGrantingTicketCookieGenerator.setCookiePath(cookiePath);
            this.pathPopulated = true;
        }
        context.getFlowScope().put("ticketGrantingTicketId", (Object)this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request));
        context.getFlowScope().put("warnCookieValue", (Object)Boolean.valueOf(this.warnCookieGenerator.retrieveCookieValue(request)));
        WebApplicationService service = WebUtils.getService(this.argumentExtractors, (RequestContext)context);
        if (service != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Placing service in FlowScope: " + service.getId()));
        }
        context.getFlowScope().put("service", (Object)service);
        return this.result("success");
    }

    public void setTicketGrantingTicketCookieGenerator(CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }

    public void setWarnCookieGenerator(CookieRetrievingCookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }

    public void setArgumentExtractors(List<ArgumentExtractor> argumentExtractors) {
        this.argumentExtractors = argumentExtractors;
    }
}

