/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.web;

import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public final class RegisteredServiceThemeBasedViewResolver
extends InternalResourceViewResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceThemeBasedViewResolver.class);
    private static final String THEME_LOCATION_PATTERN = "%s/%s/ui/";
    private final ServicesManager servicesManager;
    @Autowired
    private ResourceLoader resourceLoader;

    public RegisteredServiceThemeBasedViewResolver(ServicesManager servicesManager) {
        super.setCache(false);
        this.servicesManager = servicesManager;
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        String contentType;
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        InternalResourceView view = (InternalResourceView)BeanUtils.instantiateClass((Class)this.getViewClass());
        String defaultThemePrefix = String.format(THEME_LOCATION_PATTERN, this.getPrefix(), "default");
        String defaultViewUrl = String.valueOf(defaultThemePrefix) + viewName + this.getSuffix();
        view.setUrl(defaultViewUrl);
        if (service != null && registeredService != null && registeredService.getAccessStrategy().isServiceAccessAllowed() && StringUtils.hasText((String)registeredService.getTheme())) {
            LOGGER.debug("Attempting to locate views for service [{}] with theme [{}]", (Object)registeredService.getServiceId(), (Object)registeredService.getTheme());
            String themePrefix = String.format(THEME_LOCATION_PATTERN, this.getPrefix(), registeredService.getTheme());
            LOGGER.debug("Prefix [{}] set for service [{}] with theme [{}]", new Object[]{themePrefix, service, registeredService.getTheme()});
            String viewUrl = String.valueOf(themePrefix) + viewName + this.getSuffix();
            Resource resource = this.resourceLoader.getResource(viewUrl);
            if (resource.exists()) {
                view.setUrl(viewUrl);
            }
        }
        if ((contentType = this.getContentType()) != null) {
            view.setContentType(contentType);
        }
        view.setRequestContextAttribute(this.getRequestContextAttribute());
        view.setAttributesMap(this.getAttributesMap());
        view.setAlwaysInclude(false);
        view.setExposeContextBeansAsAttributes(false);
        view.setPreventDispatchLoop(true);
        LOGGER.debug("View resolved: {}", (Object)view.getUrl());
        return view;
    }

    public void setCache(boolean cache) {
        LOGGER.warn("The {} does not support caching. Turned off caching forcefully.", (Object)((Object)((Object)this)).getClass().getSimpleName());
        super.setCache(false);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

