/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractThrottledSubmissionHandlerInterceptorAdapter
extends HandlerInterceptorAdapter
implements InitializingBean {
    private static final int DEFAULT_FAILURE_THRESHOLD = 100;
    private static final int DEFAULT_FAILURE_RANGE_IN_SECONDS = 60;
    private static final String DEFAULT_USERNAME_PARAMETER = "username";
    private static final String SUCCESSFUL_AUTHENTICATION_EVENT = "success";
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Min(value=0L)
    private int failureThreshold = 100;
    @Min(value=0L)
    private int failureRangeInSeconds = 60;
    @NotNull
    private String usernameParameter = "username";
    private double thresholdRate;

    public void afterPropertiesSet() {
        this.thresholdRate = (double)this.failureThreshold / (double)this.failureRangeInSeconds;
    }

    public final boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        if (!"POST".equals(request.getMethod())) {
            return true;
        }
        if (this.exceedsThreshold(request)) {
            this.recordThrottle(request);
            request.setAttribute("CAS_ACCESS_DENIED_REASON", (Object)"screen.blocked.message");
            response.sendError(403, "Access Denied for user [" + request.getParameter(this.usernameParameter) + "] from IP Address [" + request.getRemoteAddr() + ']');
            return false;
        }
        return true;
    }

    public final void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) throws Exception {
        if (!"POST".equals(request.getMethod())) {
            return;
        }
        RequestContext context = (RequestContext)request.getAttribute("flowRequestContext");
        if (context == null || context.getCurrentEvent() == null) {
            return;
        }
        if (SUCCESSFUL_AUTHENTICATION_EVENT.equals(context.getCurrentEvent().getId())) {
            return;
        }
        this.recordSubmissionFailure(request);
    }

    @Autowired
    public final void setFailureThreshold(@Value(value="${cas.throttle.failure.threshold:100}") int failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    @Autowired
    public final void setFailureRangeInSeconds(@Value(value="${cas.throttle.failure.range.seconds:60}") int failureRangeInSeconds) {
        this.failureRangeInSeconds = failureRangeInSeconds;
    }

    @Autowired
    public final void setUsernameParameter(@Value(value="${cas.throttle.username.parameter:username}") String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    protected double getThresholdRate() {
        return this.thresholdRate;
    }

    protected int getFailureThreshold() {
        return this.failureThreshold;
    }

    protected int getFailureRangeInSeconds() {
        return this.failureRangeInSeconds;
    }

    protected String getUsernameParameter() {
        return this.usernameParameter;
    }

    protected void recordThrottle(HttpServletRequest request) {
        this.logger.warn("Throttling submission from {}. More than {} failed login attempts within {} seconds. Authentication attempt exceeds the failure threshold {}", new Object[]{request.getRemoteAddr(), this.failureThreshold, this.failureRangeInSeconds, this.failureThreshold});
    }

    protected abstract void recordSubmissionFailure(HttpServletRequest var1);

    protected abstract boolean exceedsThreshold(HttpServletRequest var1);

    public String toString() {
        return new ToStringBuilder((Object)this).append("failureThreshold", this.failureThreshold).append("failureRangeInSeconds", this.failureRangeInSeconds).append("usernameParameter", (Object)this.usernameParameter).append("thresholdRate", this.thresholdRate).toString();
    }

    protected abstract String getName();
}

