/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter;
import org.jasig.inspektr.audit.AuditActionContext;
import org.jasig.inspektr.audit.AuditPointRuntimeInfo;
import org.jasig.inspektr.audit.AuditTrailManager;
import org.jasig.inspektr.common.web.ClientInfo;
import org.jasig.inspektr.common.web.ClientInfoHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component(value="inspektrIpAddressUsernameThrottle")
public class InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter
extends AbstractThrottledSubmissionHandlerInterceptorAdapter {
    private static final String DEFAULT_APPLICATION_CODE = "CAS";
    private static final String DEFAULT_AUTHN_FAILED_ACTION = "AUTHENTICATION_FAILED";
    private static final String INSPEKTR_ACTION = "THROTTLED_LOGIN_ATTEMPT";
    private static final double NUMBER_OF_MILLISECONDS_IN_SECOND = 1000.0;
    private static final String SQL_AUDIT_QUERY = "SELECT AUD_DATE FROM COM_AUDIT_TRAIL WHERE AUD_CLIENT_IP = ? AND AUD_USER = ? AND AUD_ACTION = ? AND APPLIC_CD = ? AND AUD_DATE >= ? ORDER BY AUD_DATE DESC";
    @Autowired
    @Qualifier(value="auditTrailManager")
    private AuditTrailManager auditTrailManager;
    @Nullable
    @Autowired(required=false)
    @Qualifier(value="inspektrAuditTrailDataSource")
    private DataSource dataSource;
    @Value(value="${cas.throttle.appcode:CAS}")
    private String applicationCode = "CAS";
    @Value(value="${cas.throttle.authn.failurecode:AUTHENTICATION_FAILED}")
    private String authenticationFailureCode = "AUTHENTICATION_FAILED";
    @Value(value="${cas.throttle.audit.query:SELECT AUD_DATE FROM COM_AUDIT_TRAIL WHERE AUD_CLIENT_IP = ? AND AUD_USER = ? AND AUD_ACTION = ? AND APPLIC_CD = ? AND AUD_DATE >= ? ORDER BY AUD_DATE DESC}")
    private String sqlQueryAudit;
    private JdbcTemplate jdbcTemplate;

    public InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter() {
    }

    public InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter(AuditTrailManager auditTrailManager, DataSource dataSource) {
        this.auditTrailManager = auditTrailManager;
        this.init();
    }

    @PostConstruct
    public void init() {
        if (this.dataSource != null) {
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        } else {
            this.logger.debug("No data source is defined for {}. Ignoring the construction of JDBC template", (Object)this.getName());
        }
    }

    @Override
    protected boolean exceedsThreshold(HttpServletRequest request) {
        if (this.dataSource != null && this.jdbcTemplate != null) {
            String userToUse = this.constructUsername(request, this.getUsernameParameter());
            Calendar cutoff = Calendar.getInstance();
            cutoff.add(13, -1 * this.getFailureRangeInSeconds());
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            String remoteAddress = clientInfo.getClientIpAddress();
            List failures = this.jdbcTemplate.query(this.sqlQueryAudit, new Object[]{remoteAddress, userToUse, this.authenticationFailureCode, this.applicationCode, cutoff.getTime()}, new int[]{12, 12, 12, 12, 93}, (RowMapper)new RowMapper<Timestamp>(){

                public Timestamp mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getTimestamp(1);
                }
            });
            if (failures.size() < 2) {
                return false;
            }
            return 1000.0 / (double)(((Timestamp)failures.get(0)).getTime() - ((Timestamp)failures.get(1)).getTime()) > this.getThresholdRate();
        }
        this.logger.debug("No data source is defined for {}. Ignoring threshold checking", (Object)this.getName());
        return false;
    }

    @Override
    protected void recordSubmissionFailure(HttpServletRequest request) {
        this.recordThrottle(request);
    }

    @Override
    protected void recordThrottle(HttpServletRequest request) {
        if (this.dataSource != null && this.jdbcTemplate != null) {
            super.recordThrottle(request);
            String userToUse = this.constructUsername(request, this.getUsernameParameter());
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            AuditPointRuntimeInfo auditPointRuntimeInfo = new AuditPointRuntimeInfo(){
                private static final long serialVersionUID = 1L;

                public String asString() {
                    return String.format("%s.recordThrottle()", this.getClass().getName());
                }
            };
            AuditActionContext context = new AuditActionContext(userToUse, userToUse, INSPEKTR_ACTION, this.applicationCode, new Date(), clientInfo.getClientIpAddress(), clientInfo.getServerIpAddress(), auditPointRuntimeInfo);
            this.auditTrailManager.record(context);
        } else {
            this.logger.debug("No data source is defined for {}. Ignoring audit record-keeping", (Object)this.getName());
        }
    }

    public final void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    public final void setAuthenticationFailureCode(String authenticationFailureCode) {
        this.authenticationFailureCode = authenticationFailureCode;
    }

    protected String constructUsername(HttpServletRequest request, String usernameParameter) {
        return request.getParameter(usernameParameter);
    }

    @Override
    protected String getName() {
        return "inspektrIpAddressUsernameThrottle";
    }
}

