/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.inspektr.error.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.jasig.inspektr.error.ErrorLogManager;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public final class ErrorLogHandlerExceptionResolver
implements HandlerExceptionResolver,
Ordered {
    @NotNull
    private ErrorLogManager errorLogManager;
    @Min(value=0L)
    private int order = 0;

    public ErrorLogHandlerExceptionResolver(ErrorLogManager errorLogManager) {
        this.errorLogManager = errorLogManager;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        this.errorLogManager.recordError((Throwable)exception);
        return null;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }
}

