/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.impl.CliShutdownHook;
import org.jboss.as.cli.impl.CommandContextImpl;

public class CommandContextFactoryImpl
extends CommandContextFactory {
    @Override
    public CommandContext newCommandContext() throws CliInitializationException {
        CommandContextImpl cmdCtx = new CommandContextImpl();
        this.addShutdownHook(cmdCtx);
        return cmdCtx;
    }

    @Override
    public CommandContext newCommandContext(String username, char[] password) throws CliInitializationException {
        CommandContextImpl cmdCtx = new CommandContextImpl(username, password);
        this.addShutdownHook(cmdCtx);
        return cmdCtx;
    }

    @Override
    public CommandContext newCommandContext(String controllerHost, int controllerPort, String username, char[] password) throws CliInitializationException {
        return this.newCommandContext(controllerHost, controllerPort, username, password, false, -1);
    }

    @Override
    public CommandContext newCommandContext(String controllerHost, int controllerPort, String username, char[] password, boolean initConsole, int connectionTimeout) throws CliInitializationException {
        CommandContextImpl ctx = new CommandContextImpl(controllerHost, controllerPort, username, password, initConsole, connectionTimeout);
        this.addShutdownHook(ctx);
        return ctx;
    }

    @Override
    public CommandContext newCommandContext(String controllerHost, int controllerPort, String username, char[] password, InputStream consoleInput, OutputStream consoleOutput) throws CliInitializationException {
        CommandContextImpl ctx = new CommandContextImpl(controllerHost, controllerPort, username, password, consoleInput, consoleOutput);
        this.addShutdownHook(ctx);
        return ctx;
    }

    protected void addShutdownHook(final CommandContext cmdCtx) {
        CliShutdownHook.add(new CliShutdownHook.Handler(){

            @Override
            public void shutdown() {
                cmdCtx.terminateSession();
            }
        });
    }
}

