/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.util.file;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class DirectoryCopier {
    private final File sourceDirectory;

    public DirectoryCopier(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void copyTo(File targetDirectory) throws IOException {
        this.copyTo(targetDirectory, null, null);
    }

    public void copyTo(File targetDirectory, String[] includes, String[] excludes) throws IOException {
        boolean created;
        if (!this.sourceDirectory.exists()) {
            return;
        }
        String[] list = this.sourceDirectory.list();
        if (list == null || list.length == 0) {
            return;
        }
        if (!targetDirectory.exists() && !(created = targetDirectory.mkdirs())) {
            throw new IOException("Filesystem reported it was unable to create directory " + targetDirectory.getAbsolutePath());
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.sourceDirectory);
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.addDefaultExcludes();
        scanner.scan();
        for (String includedFile : scanner.getIncludedFiles()) {
            DirectoryCopier.copyFileIfModified(new File(this.sourceDirectory, includedFile), new File(targetDirectory, includedFile));
        }
    }

    public static void copyFileIfModified(File source, File destination) throws IOException {
        if (destination.lastModified() < source.lastModified()) {
            FileUtils.copyFile((File)source.getCanonicalFile(), (File)destination);
            destination.setLastModified(source.lastModified());
        }
    }
}

