/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.CharProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.IntProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.LongProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.UIntProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.ULongProgressionType;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0014J\n\u0010\u0015\u001a\u00020\u0014*\u00020\u0014J\u0014\u0010\u0016\u001a\u00020\u0014*\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\f\u0010\u0018\u001a\u00020\u0014*\u00020\u0019H&J\f\u0010\u001a\u001a\u00020\u0014*\u00020\u0019H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u0082\u0001\u0004\u001c\u001d\u001e\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionType;", "", "elementClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "stepClass", "minValueAsLong", "", "maxValueAsLong", "getProgressionLastElementFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrClass;JJLorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;)V", "getElementClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getGetProgressionLastElementFunction", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getMaxValueAsLong", "()J", "getMinValueAsLong", "getStepClass", "asElementType", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "asStepType", "castIfNecessary", "targetClass", "minValueExpression", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "zeroStepExpression", "Companion", "Lorg/jetbrains/kotlin/backend/common/lower/loops/IntProgressionType;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/LongProgressionType;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/CharProgressionType;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/UnsignedProgressionType;", "ir.backend.common"})
public abstract class ProgressionType {
    @NotNull
    private final IrClass elementClass;
    @NotNull
    private final IrClass stepClass;
    private final long minValueAsLong;
    private final long maxValueAsLong;
    @Nullable
    private final IrSimpleFunctionSymbol getProgressionLastElementFunction;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract IrExpression minValueExpression(@NotNull DeclarationIrBuilder var1);

    @NotNull
    public abstract IrExpression zeroStepExpression(@NotNull DeclarationIrBuilder var1);

    @NotNull
    public final IrExpression asElementType(@NotNull IrExpression $this$asElementType) {
        Intrinsics.checkNotNullParameter((Object)$this$asElementType, (String)"$this$asElementType");
        return this.castIfNecessary($this$asElementType, this.elementClass);
    }

    @NotNull
    public final IrExpression asStepType(@NotNull IrExpression $this$asStepType) {
        Intrinsics.checkNotNullParameter((Object)$this$asStepType, (String)"$this$asStepType");
        return this.castIfNecessary($this$asStepType, this.stepClass);
    }

    private final IrExpression castIfNecessary(IrExpression $this$castIfNecessary, IrClass targetClass) {
        IrExpression irExpression;
        if (Intrinsics.areEqual((Object)$this$castIfNecessary.getType(), (Object)IrUtilsKt.getDefaultType(targetClass)) || IrTypePredicatesKt.isNothing($this$castIfNecessary.getType())) {
            irExpression = $this$castIfNecessary;
        } else {
            Name name = Name.identifier("to" + targetClass.getName().asString());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"to${tar\u2026tClass.name.asString()}\")");
            Name numberCastFunctionName = name;
            IrClass irClass2 = IrTypesKt.getClass($this$castIfNecessary.getType());
            Intrinsics.checkNotNull((Object)irClass2);
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass2);
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)numberCastFunctionName) && it.getDispatchReceiverParameter() != null && it.getExtensionReceiverParameter() == null && it.getValueParameters().isEmpty())) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction castFun = single$iv;
            IrCallImpl irCallImpl = new IrCallImpl($this$castIfNecessary.getStartOffset(), $this$castIfNecessary.getEndOffset(), castFun.getReturnType(), castFun.getSymbol(), null, null, 48, null);
            boolean bl = false;
            boolean bl2 = false;
            IrCallImpl $this$apply = irCallImpl;
            boolean bl3 = false;
            $this$apply.setDispatchReceiver($this$castIfNecessary);
            irExpression = irCallImpl;
        }
        return irExpression;
    }

    @NotNull
    public final IrClass getElementClass() {
        return this.elementClass;
    }

    @NotNull
    public final IrClass getStepClass() {
        return this.stepClass;
    }

    public final long getMinValueAsLong() {
        return this.minValueAsLong;
    }

    public final long getMaxValueAsLong() {
        return this.maxValueAsLong;
    }

    @Nullable
    public final IrSimpleFunctionSymbol getGetProgressionLastElementFunction() {
        return this.getProgressionLastElementFunction;
    }

    private ProgressionType(IrClass elementClass, IrClass stepClass, long minValueAsLong, long maxValueAsLong, IrSimpleFunctionSymbol getProgressionLastElementFunction) {
        this.elementClass = elementClass;
        this.stepClass = stepClass;
        this.minValueAsLong = minValueAsLong;
        this.maxValueAsLong = maxValueAsLong;
        this.getProgressionLastElementFunction = getProgressionLastElementFunction;
    }

    public /* synthetic */ ProgressionType(IrClass elementClass, IrClass stepClass, long minValueAsLong, long maxValueAsLong, IrSimpleFunctionSymbol getProgressionLastElementFunction, DefaultConstructorMarker $constructor_marker) {
        this(elementClass, stepClass, minValueAsLong, maxValueAsLong, getProgressionLastElementFunction);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionType$Companion;", "", "()V", "fromIrType", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionType;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "ir.backend.common"})
    public static final class Companion {
        @Nullable
        public final ProgressionType fromIrType(@NotNull IrType irType, @NotNull Symbols<? extends CommonBackendContext> symbols2) {
            Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
            Intrinsics.checkNotNullParameter(symbols2, (String)"symbols");
            return IrTypeUtilsKt.isSubtypeOfClass(irType, symbols2.getCharProgression()) ? (ProgressionType)new CharProgressionType(symbols2) : (IrTypeUtilsKt.isSubtypeOfClass(irType, symbols2.getIntProgression()) ? (ProgressionType)new IntProgressionType(symbols2) : (IrTypeUtilsKt.isSubtypeOfClass(irType, symbols2.getLongProgression()) ? (ProgressionType)new LongProgressionType(symbols2) : (symbols2.getUIntProgression() != null && IrTypeUtilsKt.isSubtypeOfClass(irType, symbols2.getUIntProgression()) ? (ProgressionType)new UIntProgressionType(symbols2) : (symbols2.getULongProgression() != null && IrTypeUtilsKt.isSubtypeOfClass(irType, symbols2.getULongProgression()) ? (ProgressionType)new ULongProgressionType(symbols2) : null))));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

