/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.collectors.components.ErrorNodeDiagnosticCollectorComponent$WhenMappings;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory1;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeStubDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeOperatorAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeMismatchError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedReferenceError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedSymbolError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVariableExpectedError;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u001e\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\u001f*\u00020 H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "collector", "Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;", "(Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;)V", "reportFirDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "visitErrorExpression", "errorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "visitErrorFunction", "errorFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorFunction;", "visitErrorLoop", "errorLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "visitErrorNamedReference", "errorNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "getFactory", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory0;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeSimpleDiagnostic;", "checkers"})
public final class ErrorNodeDiagnosticCollectorComponent
extends AbstractDiagnosticCollectorComponent {
    @Override
    public void visitErrorLoop(@NotNull FirErrorLoop errorLoop, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorLoop, (String)"errorLoop");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorLoop.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.runCheck((Function1<? super DiagnosticReporter, Unit>)((Function1)new Function1<DiagnosticReporter, Unit>(this, errorLoop, source){
            final /* synthetic */ ErrorNodeDiagnosticCollectorComponent this$0;
            final /* synthetic */ FirErrorLoop $errorLoop;
            final /* synthetic */ FirSourceElement $source;

            public final void invoke(@NotNull DiagnosticReporter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ErrorNodeDiagnosticCollectorComponent.access$reportFirDiagnostic(this.this$0, this.$errorLoop.getDiagnostic(), this.$source, it);
            }
            {
                this.this$0 = errorNodeDiagnosticCollectorComponent;
                this.$errorLoop = firErrorLoop;
                this.$source = firSourceElement;
                super(1);
            }
        }));
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorTypeRef.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.runCheck((Function1<? super DiagnosticReporter, Unit>)((Function1)new Function1<DiagnosticReporter, Unit>(this, errorTypeRef, source){
            final /* synthetic */ ErrorNodeDiagnosticCollectorComponent this$0;
            final /* synthetic */ FirErrorTypeRef $errorTypeRef;
            final /* synthetic */ FirSourceElement $source;

            public final void invoke(@NotNull DiagnosticReporter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ErrorNodeDiagnosticCollectorComponent.access$reportFirDiagnostic(this.this$0, this.$errorTypeRef.getDiagnostic(), this.$source, it);
            }
            {
                this.this$0 = errorNodeDiagnosticCollectorComponent;
                this.$errorTypeRef = firErrorTypeRef;
                this.$source = firSourceElement;
                super(1);
            }
        }));
    }

    @Override
    public void visitErrorNamedReference(@NotNull FirErrorNamedReference errorNamedReference, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorNamedReference, (String)"errorNamedReference");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorNamedReference.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.runCheck((Function1<? super DiagnosticReporter, Unit>)((Function1)new Function1<DiagnosticReporter, Unit>(this, errorNamedReference, source){
            final /* synthetic */ ErrorNodeDiagnosticCollectorComponent this$0;
            final /* synthetic */ FirErrorNamedReference $errorNamedReference;
            final /* synthetic */ FirSourceElement $source;

            public final void invoke(@NotNull DiagnosticReporter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ErrorNodeDiagnosticCollectorComponent.access$reportFirDiagnostic(this.this$0, this.$errorNamedReference.getDiagnostic(), this.$source, it);
            }
            {
                this.this$0 = errorNodeDiagnosticCollectorComponent;
                this.$errorNamedReference = firErrorNamedReference;
                this.$source = firSourceElement;
                super(1);
            }
        }));
    }

    @Override
    public void visitErrorExpression(@NotNull FirErrorExpression errorExpression, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorExpression, (String)"errorExpression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorExpression.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.runCheck((Function1<? super DiagnosticReporter, Unit>)((Function1)new Function1<DiagnosticReporter, Unit>(this, errorExpression, source){
            final /* synthetic */ ErrorNodeDiagnosticCollectorComponent this$0;
            final /* synthetic */ FirErrorExpression $errorExpression;
            final /* synthetic */ FirSourceElement $source;

            public final void invoke(@NotNull DiagnosticReporter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ErrorNodeDiagnosticCollectorComponent.access$reportFirDiagnostic(this.this$0, this.$errorExpression.getDiagnostic(), this.$source, it);
            }
            {
                this.this$0 = errorNodeDiagnosticCollectorComponent;
                this.$errorExpression = firErrorExpression;
                this.$source = firSourceElement;
                super(1);
            }
        }));
    }

    @Override
    public void visitErrorFunction(@NotNull FirErrorFunction errorFunction, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorFunction, (String)"errorFunction");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorFunction.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.runCheck((Function1<? super DiagnosticReporter, Unit>)((Function1)new Function1<DiagnosticReporter, Unit>(this, errorFunction, source){
            final /* synthetic */ ErrorNodeDiagnosticCollectorComponent this$0;
            final /* synthetic */ FirErrorFunction $errorFunction;
            final /* synthetic */ FirSourceElement $source;

            public final void invoke(@NotNull DiagnosticReporter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ErrorNodeDiagnosticCollectorComponent.access$reportFirDiagnostic(this.this$0, this.$errorFunction.getDiagnostic(), this.$source, it);
            }
            {
                this.this$0 = errorNodeDiagnosticCollectorComponent;
                this.$errorFunction = firErrorFunction;
                this.$source = firSourceElement;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void reportFirDiagnostic(ConeDiagnostic diagnostic, FirSourceElement source, DiagnosticReporter reporter) {
        FirDiagnostic firDiagnostic;
        ConeDiagnostic coneDiagnostic = diagnostic;
        if (coneDiagnostic instanceof ConeUnresolvedReferenceError) {
            Name name = ((ConeUnresolvedReferenceError)diagnostic).getName();
            firDiagnostic = FirErrors.INSTANCE.getUNRESOLVED_REFERENCE().on(source, name != null ? name.asString() : null);
        } else if (coneDiagnostic instanceof ConeUnresolvedSymbolError) {
            firDiagnostic = FirErrors.INSTANCE.getUNRESOLVED_REFERENCE().on(source, ((ConeUnresolvedSymbolError)diagnostic).getClassId().asString());
        } else if (coneDiagnostic instanceof ConeUnresolvedNameError) {
            firDiagnostic = FirErrors.INSTANCE.getUNRESOLVED_REFERENCE().on(source, ((ConeUnresolvedNameError)diagnostic).getName().asString());
        } else if (coneDiagnostic instanceof ConeInapplicableCandidateError) {
            Collection<AbstractFirBasedSymbol<?>> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((ConeInapplicableCandidateError)diagnostic).getCandidates();
            FirSourceElement firSourceElement = source;
            FirDiagnosticFactory1<FirSourceElement, PsiElement, Collection<AbstractFirBasedSymbol<?>>> firDiagnosticFactory1 = FirErrors.INSTANCE.getINAPPLICABLE_CANDIDATE();
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ConeInapplicableCandidateError.CandidateInfo candidateInfo = (ConeInapplicableCandidateError.CandidateInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                AbstractFirBasedSymbol<?> abstractFirBasedSymbol = it.getSymbol();
                collection.add(abstractFirBasedSymbol);
            }
            collection = (List)destination$iv$iv;
            firDiagnostic = firDiagnosticFactory1.on(firSourceElement, collection);
        } else if (coneDiagnostic instanceof ConeAmbiguityError) {
            firDiagnostic = FirErrors.INSTANCE.getAMBIGUITY().on(source, ((ConeAmbiguityError)diagnostic).getCandidates());
        } else if (coneDiagnostic instanceof ConeOperatorAmbiguityError) {
            firDiagnostic = FirErrors.INSTANCE.getASSIGN_OPERATOR_AMBIGUITY().on(source, ((ConeOperatorAmbiguityError)diagnostic).getCandidates());
        } else if (coneDiagnostic instanceof ConeVariableExpectedError) {
            firDiagnostic = FirErrors.INSTANCE.getVARIABLE_EXPECTED().on(source);
        } else if (coneDiagnostic instanceof ConeTypeMismatchError) {
            firDiagnostic = FirErrors.INSTANCE.getTYPE_MISMATCH().on(source, ((ConeTypeMismatchError)diagnostic).getExpectedType(), ((ConeTypeMismatchError)diagnostic).getActualType());
        } else if (coneDiagnostic instanceof ConeSimpleDiagnostic) {
            firDiagnostic = this.getFactory((ConeSimpleDiagnostic)diagnostic).on(source);
        } else if (coneDiagnostic instanceof ConeStubDiagnostic) {
            firDiagnostic = null;
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported diagnostic type: " + diagnostic.getClass());
        }
        FirDiagnostic coneDiagnostic2 = firDiagnostic;
        reporter.report(coneDiagnostic2);
    }

    private final FirDiagnosticFactory0<FirSourceElement, ?> getFactory(ConeSimpleDiagnostic $this$getFactory) {
        FirDiagnosticFactory0<FirSourceElement, PsiElement> firDiagnosticFactory0;
        switch (ErrorNodeDiagnosticCollectorComponent$WhenMappings.$EnumSwitchMapping$0[$this$getFactory.getKind().ordinal()]) {
            case 1: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getSYNTAX_ERROR();
                break;
            }
            case 2: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getRETURN_NOT_ALLOWED();
                break;
            }
            case 3: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getUNRESOLVED_LABEL();
                break;
            }
            case 4: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getILLEGAL_CONST_EXPRESSION();
                break;
            }
            case 5: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getDESERIALIZATION_ERROR();
                break;
            }
            case 6: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getINFERENCE_ERROR();
                break;
            }
            case 7: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getTYPE_PARAMETER_AS_SUPERTYPE();
                break;
            }
            case 8: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getENUM_AS_SUPERTYPE();
                break;
            }
            case 9: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getRECURSION_IN_SUPERTYPES();
                break;
            }
            case 10: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getRECURSION_IN_IMPLICIT_TYPES();
                break;
            }
            case 11: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getSUPER_IS_NOT_AN_EXPRESSION();
                break;
            }
            case 12: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getERROR_FROM_JAVA_RESOLUTION();
                break;
            }
            case 13: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getEXPRESSION_REQUIRED();
                break;
            }
            case 14: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getBREAK_OR_CONTINUE_OUTSIDE_A_LOOP();
                break;
            }
            case 15: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getNOT_A_LOOP_LABEL();
                break;
            }
            case 16: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getVARIABLE_EXPECTED();
                break;
            }
            case 17: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getOTHER_ERROR();
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unsupported diagnostic kind: " + (Object)((Object)$this$getFactory.getKind()) + " at " + $this$getFactory.getClass());
            }
        }
        return firDiagnosticFactory0;
    }

    public ErrorNodeDiagnosticCollectorComponent(@NotNull AbstractDiagnosticCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        super(collector2);
    }

    public static final /* synthetic */ void access$reportFirDiagnostic(ErrorNodeDiagnosticCollectorComponent $this, ConeDiagnostic diagnostic, FirSourceElement source, DiagnosticReporter reporter) {
        $this.reportFirDiagnostic(diagnostic, source, reporter);
    }
}

