/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/AbstractClassInstantiationChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class AbstractClassInstantiationChecker
implements CallChecker {
    public static final AbstractClassInstantiationChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object candidateDescriptor = resolvedCall2.getCandidateDescriptor();
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"resolvedCall.call");
        Call call3 = call2;
        if (candidateDescriptor instanceof ConstructorDescriptor && !CallResolverUtilKt.isSuperOrDelegatingConstructorCall(call3)) {
            ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)candidateDescriptor).getConstructedClass();
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"candidateDescriptor.constructedClass");
            if (classDescriptor2.getModality() == Modality.ABSTRACT) {
                BindingTrace bindingTrace = context2.getTrace();
                SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.CREATING_AN_INSTANCE_OF_ABSTRACT_CLASS.on(call3.getCallElement());
                Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"CREATING_AN_INSTANCE_OF_\u2026LASS.on(call.callElement)");
                DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
            }
        }
    }

    private AbstractClassInstantiationChecker() {
    }

    static {
        AbstractClassInstantiationChecker abstractClassInstantiationChecker;
        INSTANCE = abstractClassInstantiationChecker = new AbstractClassInstantiationChecker();
    }
}

