/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ResultClassInReturnTypeCheckerKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ResultTypeWithNullableOperatorsChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ResultTypeWithNullableOperatorsChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        block14: {
            Name name;
            block15: {
                block13: {
                    Object resultingDescriptor;
                    Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
                    Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowNullOperatorsForResult)) {
                        return;
                    }
                    Object obj = resolvedCall2.getResultingDescriptor();
                    Intrinsics.checkNotNullExpressionValue(obj, (String)"resolvedCall.resultingDescriptor");
                    Name name2 = obj.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"resolvedCall.resultingDescriptor.name");
                    name = name2;
                    Call call2 = resolvedCall2.getCall();
                    Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"resolvedCall.call");
                    ASTNode operationNode = call2.getCallOperationNode();
                    ASTNode aSTNode = operationNode;
                    if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.SAFE_ACCESS)) break block13;
                    Object obj2 = resultingDescriptor = resolvedCall2.getResultingDescriptor();
                    Intrinsics.checkNotNullExpressionValue(obj2, (String)"resultingDescriptor");
                    ReceiverParameterDescriptor receiverParameterDescriptor = obj2.getExtensionReceiverParameter();
                    if (receiverParameterDescriptor == null) {
                        receiverParameterDescriptor = resultingDescriptor.getDispatchReceiverParameter();
                    }
                    if (receiverParameterDescriptor == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)receiverParameterDescriptor, (String)"resultingDescriptor.exte\u2026ceiverParameter ?: return");
                    ReceiverParameterDescriptor receiver = receiverParameterDescriptor;
                    KotlinType kotlinType = receiver.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"receiver.type");
                    if (!ResultClassInReturnTypeCheckerKt.isResultType(kotlinType)) break block14;
                    BindingTrace bindingTrace = context2.getTrace();
                    ASTNode aSTNode2 = operationNode;
                    Intrinsics.checkNotNull((Object)aSTNode2);
                    bindingTrace.report(Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(aSTNode2.getPsi(), "?."));
                    break block14;
                }
                if (!Intrinsics.areEqual((Object)name, (Object)ControlStructureTypingUtils.ResolveConstruct.EXCL_EXCL.getSpecialFunctionName())) break block15;
                Object obj = resolvedCall2.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue(obj, (String)"resolvedCall.resultingDescriptor");
                KotlinType kotlinType = obj.getReturnType();
                if (kotlinType == null) break block14;
                if (ResultClassInReturnTypeCheckerKt.isResultType(kotlinType)) {
                    context2.getTrace().report(Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(reportOn, "!!"));
                }
                break block14;
            }
            if (!Intrinsics.areEqual((Object)name, (Object)ControlStructureTypingUtils.ResolveConstruct.ELVIS.getSpecialFunctionName())) break block14;
            Call call3 = resolvedCall2.getCall();
            Intrinsics.checkNotNullExpressionValue((Object)call3, (String)"resolvedCall.call");
            KtElement ktElement = call3.getCallElement();
            if (!(ktElement instanceof KtBinaryExpression)) {
                ktElement = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktElement;
            if (ktBinaryExpression == null) {
                return;
            }
            KtBinaryExpression elvisBinaryExpression = ktBinaryExpression;
            KtExpression ktExpression = elvisBinaryExpression.getLeft();
            if (ktExpression == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"elvisBinaryExpression.left ?: return");
            KtExpression left = ktExpression;
            KotlinType kotlinType = context2.getTrace().getType(left);
            if (kotlinType == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"context.trace.getType(left) ?: return");
            KotlinType leftType = kotlinType;
            if (ResultClassInReturnTypeCheckerKt.isResultType(leftType)) {
                BindingTrace bindingTrace = context2.getTrace();
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(reportOn, "?:");
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"Errors.RESULT_CLASS_WITH\u2026ERATOR.on(reportOn, \"?:\")");
                DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
            }
            if (left instanceof KtBinaryExpression) {
                KtExpression ktExpression2 = ((KtBinaryExpression)left).getRight();
                if (ktExpression2 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"left.right ?: return");
                KtExpression lastExpression = ktExpression2;
                KotlinType kotlinType2 = context2.getTrace().getType(lastExpression);
                if (kotlinType2 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"context.trace.getType(lastExpression) ?: return");
                KotlinType lastExpressionType = kotlinType2;
                if (ResultClassInReturnTypeCheckerKt.isResultType(lastExpressionType)) {
                    BindingTrace bindingTrace = context2.getTrace();
                    ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(reportOn, "?:");
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"Errors.RESULT_CLASS_WITH\u2026ERATOR.on(reportOn, \"?:\")");
                    DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
                }
            }
        }
    }
}

