/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import com.android.build.gradle.BaseExtension;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.AnnotationProcessingManager;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KaptExtension;
import org.jetbrains.kotlin.gradle.tasks.kapt.KaptStubGeneratorUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 B2\u00020\u0001:\u0001BBG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\nH\u0002J\u0018\u0010$\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0007H\u0002J\u0006\u0010&\u001a\u00020\"J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\"H\u0002J\b\u0010*\u001a\u00020\"H\u0002J&\u0010+\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010#\u001a\u00020\nH\u0002J\u0006\u0010-\u001a\u00020\"J\n\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0006\u00100\u001a\u00020\nJ\u0010\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007H\u0002J\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\b\u00105\u001a\u00020\"H\u0002J\u0006\u00106\u001a\u00020\"J\u0016\u00107\u001a\u00020(2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\n09H\u0002J\b\u0010:\u001a\u00020\"H\u0002J+\u0010;\u001a\u00020\"*\u00020\u00052\u0006\u0010<\u001a\u00020\u00072\u0014\u0010=\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u00070>H\u0082\bJ'\u0010?\u001a\u00020\"*\u00020\u00052\u0018\u0010@\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070A\u0012\u0004\u0012\u00020\"0>H\u0082\bR\u0010\u0010\r\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\n0\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u0016*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0010\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/AnnotationProcessingManager;", "", "task", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "javaTask", "Lorg/gradle/api/tasks/compile/JavaCompile;", "taskQualifier", "", "aptFiles", "", "Ljava/io/File;", "aptOutputDir", "aptWorkingDir", "androidVariant", "(Lorg/gradle/api/tasks/compile/AbstractCompile;Lorg/gradle/api/tasks/compile/JavaCompile;Ljava/lang/String;Ljava/util/Set;Ljava/io/File;Ljava/io/File;Ljava/lang/Object;)V", "getAptOutputDir", "()Ljava/io/File;", "generatedKotlinSourceDir", "getGeneratedKotlinSourceDir", "hackAnnotationDir", "getHackAnnotationDir", "kaptProcessorPath", "kotlin.jvm.PlatformType", "getKaptProcessorPath", "()Ljava/util/Set;", "originalJavaCompilerArgs", "", "originalProcessorPath", "Lorg/gradle/api/file/FileCollection;", "project", "Lorg/gradle/api/Project;", "wrappersDirectory", "getWrappersDirectory", "addGeneratedSourcesOutputToCompilerArgs", "", "outputDir", "addWrappersToCompilerArgs", "wrapperFqNames", "afterJavaCompile", "allowToUseOriginalKapt", "", "appendAdditionalComplerArgs", "appendAnnotationsArguments", "generateAnnotationProcessorStubs", "processorFqNames", "generateJavaHackFile", "getAndroidExtension", "Lcom/android/build/gradle/BaseExtension;", "getAnnotationFile", "getProcessorStubClassName", "processorFqName", "lookupAnnotationProcessors", "files", "setProcessorPathInJavaTask", "setupKapt", "tryAppendProcessorPathProperty", "path", "", "tryRevertProcessorPathProperty", "addCompilerArgument", "name", "value", "Lkotlin/Function1;", "modifyCompilerArguments", "modifier", "", "Companion", "kotlin-gradle-plugin"})
public final class AnnotationProcessingManager {
    private final Project project;
    @NotNull
    private final File wrappersDirectory;
    @NotNull
    private final File hackAnnotationDir;
    private List<String> originalJavaCompilerArgs;
    private FileCollection originalProcessorPath;
    private final JavaCompile javaTask;
    private final String taskQualifier;
    private final Set<File> aptFiles;
    @NotNull
    private final File aptOutputDir;
    private final File aptWorkingDir;
    private final Object androidVariant;
    @NotNull
    private static final Regex JAVA_FQNAME_PATTERN;
    @NotNull
    private static final String GEN_ANNOTATION = "__gen/annotation";
    private static final String ANDROID_APT_PLUGIN_ID = "com.neenbedankt.android-apt";
    @Deprecated
    public static final Companion Companion;

    @NotNull
    public final File getWrappersDirectory() {
        return this.wrappersDirectory;
    }

    @NotNull
    public final File getHackAnnotationDir() {
        return this.hackAnnotationDir;
    }

    @NotNull
    public final File getAnnotationFile() {
        if (!this.aptWorkingDir.exists()) {
            this.aptWorkingDir.mkdirs();
        }
        return new File(this.wrappersDirectory, "annotations." + this.taskQualifier + ".txt");
    }

    @NotNull
    public final File getGeneratedKotlinSourceDir() {
        File kotlinGeneratedDir = new File(this.aptWorkingDir, "kotlinGenerated");
        if (!kotlinGeneratedDir.exists()) {
            kotlinGeneratedDir.mkdirs();
        }
        return kotlinGeneratedDir;
    }

    @NotNull
    public final Set<File> getKaptProcessorPath() {
        Set set = SetsKt.plus((Set)SetsKt.setOf((Object)this.wrappersDirectory), (Iterable)this.aptFiles);
        FileCollection fileCollection = this.javaTask.getClasspath();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"javaTask.classpath");
        return SetsKt.plus((Set)set, (Iterable)((Iterable)fileCollection));
    }

    private final boolean allowToUseOriginalKapt() {
        String string;
        return this.project.hasProperty("allow.original.kapt") && Boolean.parseBoolean(string = String.valueOf(this.project.property("allow.original.kapt")));
    }

    public final void setupKapt() {
        CompileOptions compileOptions = this.javaTask.getOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions, (String)"javaTask.options");
        this.originalJavaCompilerArgs = compileOptions.getCompilerArgs();
        if (this.aptFiles.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("");
        Project project = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String deprecationMessage = stringBuilder.append(project.getName()).append(": ").append("Original kapt is deprecated. Please add \"apply plugin: 'kotlin-kapt'\" to your build.gradle.").toString();
        if (!this.allowToUseOriginalKapt()) {
            throw (Throwable)new GradleException(deprecationMessage);
        }
        Project project2 = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        project2.getLogger().warn(deprecationMessage);
        Project project3 = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        if (project3.getPlugins().findPlugin(ANDROID_APT_PLUGIN_ID) != null) {
            Project project4 = this.project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
            project4.getLogger().warn("Please do not use `" + ANDROID_APT_PLUGIN_ID + "` with kapt.");
        }
        Set<String> annotationProcessorFqNames = this.lookupAnnotationProcessors(this.aptFiles);
        this.generateAnnotationProcessorStubs(this.javaTask, annotationProcessorFqNames, this.wrappersDirectory);
        this.setProcessorPathInJavaTask();
        if (this.aptOutputDir.exists()) {
            FilesKt.deleteRecursively((File)this.aptOutputDir);
        }
        this.addGeneratedSourcesOutputToCompilerArgs(this.javaTask, this.aptOutputDir);
        this.appendAnnotationsArguments();
        this.appendAdditionalComplerArgs();
    }

    public final void afterJavaCompile() {
        File generatedFile = new File(this.javaTask.getDestinationDir(), "" + GEN_ANNOTATION + "/Cl.class");
        if (generatedFile.exists()) {
            generatedFile.delete();
        } else {
            Project project = this.project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            Logger logger = project.getLogger();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"project.logger");
            GradleUtilsKt.kotlinDebug(logger, "kapt: Java file stub was not found at " + generatedFile);
        }
        CompileOptions compileOptions = this.javaTask.getOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions, (String)"javaTask.options");
        compileOptions.setCompilerArgs(this.originalJavaCompilerArgs);
        this.tryRevertProcessorPathProperty();
    }

    public final void generateJavaHackFile() {
        File javaHackPackageDir = new File(this.hackAnnotationDir, GEN_ANNOTATION);
        File javaHackClFile = new File(javaHackPackageDir, "Cl.java");
        if (!javaHackClFile.exists()) {
            javaHackClFile.getParentFile().mkdirs();
            FilesKt.writeText$default((File)javaHackClFile, (String)"package __gen.annotation;\nclass Cl { @__gen.KotlinAptAnnotation boolean v; }", null, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendAnnotationsArguments() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        JavaCompile $receiver$iv = this.javaTask;
        AnnotationProcessingManager this_$iv = this;
        CompileOptions compileOptions = $receiver$iv.getOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions, (String)"this.options");
        List list = compileOptions.getCompilerArgs();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
        List compilerArgs$iv = list;
        Iterable iterable = compilerArgs$iv;
        Collection collection = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p1$iv;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            void var9_9 = destination$iv$iv;
            String string = p1$iv.toString();
            var9_9.add(string);
        }
        ArrayList newCompilerArgs$iv = (ArrayList)destination$iv$iv;
        List list2 = newCompilerArgs$iv;
        list2.add("-Akapt.annotations=" + this.getAnnotationFile());
        list2.add("-Akapt.kotlin.generated=" + this.getGeneratedKotlinSourceDir());
        CompileOptions compileOptions2 = $receiver$iv.getOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions2, (String)"options");
        compileOptions2.setCompilerArgs((List)newCompilerArgs$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendAdditionalComplerArgs() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Project project = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        KaptExtension kaptExtension = (KaptExtension)project.getExtensions().getByType(KaptExtension.class);
        Project project2 = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        List<String> args = kaptExtension.getAdditionalArgumentsForJavac(project2, this.androidVariant, this.getAndroidExtension());
        if (args.isEmpty()) {
            return;
        }
        JavaCompile javaCompile = this.javaTask;
        AnnotationProcessingManager this_$iv = this;
        CompileOptions compileOptions = $receiver$iv.getOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions, (String)"this.options");
        List list = compileOptions.getCompilerArgs();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
        List compilerArgs$iv = list;
        Iterable iterable = compilerArgs$iv;
        Collection collection = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p1$iv;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            void var11_11 = destination$iv$iv;
            String string = p1$iv.toString();
            var11_11.add(string);
        }
        ArrayList newCompilerArgs$iv = (ArrayList)destination$iv$iv;
        List list2 = newCompilerArgs$iv;
        list2.addAll((Collection)args);
        CompileOptions compileOptions2 = $receiver$iv.getOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions2, (String)"options");
        compileOptions2.setCompilerArgs((List)newCompilerArgs$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateAnnotationProcessorStubs(JavaCompile javaTask, Set<String> processorFqNames, File outputDir) {
        void $receiver$iv$iv;
        void $receiver$iv;
        File wrapperFile;
        File aptAnnotationFile = KaptStubGeneratorUtilsKt.generateKotlinAptAnnotation(outputDir);
        Project project = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Logger logger = project.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"project.logger");
        GradleUtilsKt.kotlinDebug(logger, "kapt: Stub annotation generated: " + aptAnnotationFile);
        File stubOutputPackageDir = new File(outputDir, "__gen");
        stubOutputPackageDir.mkdirs();
        for (String processorFqName : processorFqNames) {
            wrapperFile = KaptStubGeneratorUtilsKt.generateAnnotationProcessorWrapper(processorFqName, "__gen", stubOutputPackageDir, this.getProcessorStubClassName(processorFqName), this.taskQualifier);
            Project project2 = this.project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            Logger logger2 = project2.getLogger();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"project.logger");
            GradleUtilsKt.kotlinDebug(logger2, "kapt: Wrapper for " + processorFqName + " generated: " + wrapperFile);
        }
        Iterable iterable = processorFqNames;
        wrapperFile = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void fqName;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string2 = "__gen." + this.getProcessorStubClassName((String)fqName);
            collection.add(string2);
        }
        String annotationProcessorWrapperFqNames = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        this.addWrappersToCompilerArgs(javaTask, annotationProcessorWrapperFqNames);
    }

    /*
     * WARNING - void declaration
     */
    private final void addWrappersToCompilerArgs(JavaCompile javaTask, String wrapperFqNames) {
        int argIndex$iv;
        List args$iv;
        ArrayList newCompilerArgs$iv$iv;
        void $receiver$iv$iv;
        String name$iv;
        block5: {
            int n;
            void destination$iv$iv$iv;
            void $receiver$iv$iv$iv;
            void this_$iv;
            void $receiver$iv;
            JavaCompile javaCompile = javaTask;
            AnnotationProcessingManager annotationProcessingManager = this;
            name$iv = "-processor";
            void var6_6 = $receiver$iv;
            void this_$iv$iv = this_$iv;
            CompileOptions compileOptions = $receiver$iv$iv.getOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions, (String)"this.options");
            List list = compileOptions.getCompilerArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
            List compilerArgs$iv$iv = list;
            Iterable iterable = compilerArgs$iv$iv;
            Collection collection = new ArrayList();
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void p1$iv$iv;
                Object item$iv$iv$iv;
                Object t = item$iv$iv$iv = iterator.next();
                void var14_14 = destination$iv$iv$iv;
                String string = p1$iv$iv.toString();
                var14_14.add(string);
            }
            newCompilerArgs$iv$iv = (ArrayList)destination$iv$iv$iv;
            List $receiver$iv$iv2 = args$iv = (List)newCompilerArgs$iv$iv;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $receiver$iv$iv2) {
                String it$iv = (String)item$iv$iv;
                if (Intrinsics.areEqual((Object)name$iv, (Object)it$iv)) {
                    n = index$iv$iv;
                    break block5;
                }
                ++index$iv$iv;
            }
            n = argIndex$iv = -1;
        }
        if (argIndex$iv >= 0 && args$iv.size() > argIndex$iv + 1) {
            void prevValue;
            String string = (String)args$iv.get(argIndex$iv + 1);
            int n = argIndex$iv + 1;
            List list = args$iv;
            String string2 = prevValue != null ? "" + (String)prevValue + ',' + wrapperFqNames : wrapperFqNames;
            list.set(n, string2);
        } else {
            args$iv.add(name$iv);
            String prevValue = null;
            List list = args$iv;
            String string = wrapperFqNames;
            list.add(string);
        }
        CompileOptions compileOptions = $receiver$iv$iv.getOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions, (String)"options");
        compileOptions.setCompilerArgs((List)newCompilerArgs$iv$iv);
    }

    private final BaseExtension getAndroidExtension() {
        try {
            Project project = this.project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            Object object = project.getExtensions().getByName("android");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.BaseExtension");
            }
            return (BaseExtension)object;
        }
        catch (UnknownDomainObjectException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addGeneratedSourcesOutputToCompilerArgs(JavaCompile javaTask, File outputDir) {
        int argIndex$iv;
        List args$iv;
        ArrayList newCompilerArgs$iv$iv;
        void $receiver$iv$iv;
        String name$iv;
        block6: {
            int n;
            void destination$iv$iv$iv;
            void $receiver$iv$iv$iv;
            void this_$iv;
            void $receiver$iv;
            outputDir.mkdirs();
            JavaCompile javaCompile = javaTask;
            AnnotationProcessingManager annotationProcessingManager = this;
            name$iv = "-s";
            void var6_6 = $receiver$iv;
            void this_$iv$iv = this_$iv;
            CompileOptions compileOptions = $receiver$iv$iv.getOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions, (String)"this.options");
            List list = compileOptions.getCompilerArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
            List compilerArgs$iv$iv = list;
            Iterable iterable = compilerArgs$iv$iv;
            Collection collection = new ArrayList();
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void p1$iv$iv;
                Object item$iv$iv$iv;
                Object t = item$iv$iv$iv = iterator.next();
                void var14_14 = destination$iv$iv$iv;
                String string = p1$iv$iv.toString();
                var14_14.add(string);
            }
            newCompilerArgs$iv$iv = (ArrayList)destination$iv$iv$iv;
            List $receiver$iv$iv2 = args$iv = (List)newCompilerArgs$iv$iv;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $receiver$iv$iv2) {
                String it$iv = (String)item$iv$iv;
                if (Intrinsics.areEqual((Object)name$iv, (Object)it$iv)) {
                    n = index$iv$iv;
                    break block6;
                }
                ++index$iv$iv;
            }
            n = argIndex$iv = -1;
        }
        if (argIndex$iv >= 0 && args$iv.size() > argIndex$iv + 1) {
            void prevValue;
            String string = (String)args$iv.get(argIndex$iv + 1);
            int n = argIndex$iv + 1;
            List list = args$iv;
            if (prevValue != null) {
                javaTask.getLogger().warn("Destination for generated sources was modified by kapt. Previous value = " + (String)prevValue);
            }
            String string2 = outputDir.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"outputDir.absolutePath");
            String string3 = string2;
            list.set(n, string3);
        } else {
            args$iv.add(name$iv);
            String prevValue = null;
            List list = args$iv;
            String string = outputDir.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputDir.absolutePath");
            String string4 = string;
            list.add(string4);
        }
        CompileOptions compileOptions = $receiver$iv$iv.getOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions, (String)"options");
        compileOptions.setCompilerArgs((List)newCompilerArgs$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void setProcessorPathInJavaTask() {
        Set<File> path = this.getKaptProcessorPath();
        boolean couldSetProperty = this.tryAppendProcessorPathProperty((Iterable<? extends File>)path);
        if (!couldSetProperty) {
            int argIndex$iv;
            List args$iv;
            ArrayList newCompilerArgs$iv$iv;
            void $receiver$iv$iv;
            String name$iv;
            block10: {
                int n;
                void destination$iv$iv$iv;
                void $receiver$iv$iv$iv;
                void this_$iv;
                void $receiver$iv;
                JavaCompile javaCompile = this.javaTask;
                AnnotationProcessingManager annotationProcessingManager = this;
                name$iv = "-processorpath";
                void var6_6 = $receiver$iv;
                void this_$iv$iv = this_$iv;
                CompileOptions compileOptions = $receiver$iv$iv.getOptions();
                Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions, (String)"this.options");
                List list = compileOptions.getCompilerArgs();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
                List compilerArgs$iv$iv = list;
                Iterable iterable = compilerArgs$iv$iv;
                Collection collection = new ArrayList();
                Iterator iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void p1$iv$iv;
                    Object item$iv$iv$iv;
                    Object t = item$iv$iv$iv = iterator.next();
                    void var14_14 = destination$iv$iv$iv;
                    String string = p1$iv$iv.toString();
                    var14_14.add(string);
                }
                newCompilerArgs$iv$iv = (ArrayList)destination$iv$iv$iv;
                List $receiver$iv$iv2 = args$iv = (List)newCompilerArgs$iv$iv;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    String it$iv = (String)item$iv$iv;
                    if (Intrinsics.areEqual((Object)name$iv, (Object)it$iv)) {
                        n = index$iv$iv;
                        break block10;
                    }
                    ++index$iv$iv;
                }
                n = argIndex$iv = -1;
            }
            if (argIndex$iv >= 0 && args$iv.size() > argIndex$iv + 1) {
                String string;
                String string2;
                Iterable iterable;
                String string3;
                void prevValue;
                String string4 = (String)args$iv.get(argIndex$iv + 1);
                int n = argIndex$iv + 1;
                List list = args$iv;
                if (prevValue != null) {
                    this.javaTask.getLogger().warn("Processor path was modified by kapt. Previous value = " + (String)prevValue);
                }
                Iterable iterable2 = path;
                void v4 = prevValue;
                if (v4 != null) {
                    string3 = v4;
                    iterable = iterable2;
                    void it = string3;
                    string2 = File.pathSeparator + (String)it;
                    iterable2 = iterable;
                    string = string2;
                } else {
                    string = null;
                }
                string3 = string;
                iterable = iterable2;
                String string5 = string3;
                if (string5 == null) {
                    string5 = "";
                }
                string2 = string5;
                CharSequence charSequence = string2;
                String string6 = File.pathSeparator;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"File.pathSeparator");
                string3 = null;
                CharSequence charSequence2 = null;
                int n2 = 0;
                CharSequence charSequence3 = string6;
                CharSequence charSequence4 = null;
                CharSequence charSequence5 = charSequence;
                String string7 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)charSequence3, charSequence4, (CharSequence)charSequence5, (int)n2, charSequence2, (Function1)string3, (int)58, null);
                list.set(n, string7);
            } else {
                args$iv.add(name$iv);
                String prevValue = null;
                List list = args$iv;
                Function1 function1 = null;
                Iterable iterable = path;
                String string = "";
                CharSequence charSequence = string;
                String string8 = File.pathSeparator;
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"File.pathSeparator");
                function1 = null;
                CharSequence charSequence6 = null;
                int n = 0;
                CharSequence charSequence7 = string8;
                CharSequence charSequence8 = null;
                CharSequence charSequence9 = charSequence;
                String string9 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)charSequence7, charSequence8, (CharSequence)charSequence9, (int)n, charSequence6, function1, (int)58, null);
                list.add(string9);
            }
            CompileOptions compileOptions = $receiver$iv$iv.getOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions, (String)"options");
            compileOptions.setCompilerArgs((List)newCompilerArgs$iv$iv);
        }
    }

    private final boolean tryAppendProcessorPathProperty(Iterable<? extends File> path) {
        boolean bl;
        try {
            Class<?> optionsClass = this.javaTask.getOptions().getClass();
            Method getPath = optionsClass.getMethod("getAnnotationProcessorPath", new Class[0]);
            Method setPath = optionsClass.getMethod("setAnnotationProcessorPath", FileCollection.class);
            Object object = getPath.invoke((Object)this.javaTask.getOptions(), new Object[0]);
            if (!(object instanceof FileCollection)) {
                object = null;
            }
            this.originalProcessorPath = (FileCollection)object;
            if (this.originalProcessorPath != null) {
                this.javaTask.getLogger().warn("Processor path was modified by kapt. Previous value = " + this.originalProcessorPath);
            }
            Object[] objectArray = new Object[1];
            FileCollection fileCollection = this.originalProcessorPath;
            objectArray[0] = CollectionsKt.plus(path, (Iterable)(fileCollection != null ? (Iterable)fileCollection : (Iterable)CollectionsKt.emptyList()));
            ConfigurableFileCollection newPath = this.javaTask.getProject().files(objectArray);
            setPath.invoke((Object)this.javaTask.getOptions(), newPath);
            bl = true;
        }
        catch (NoSuchMethodException _) {
            bl = false;
        }
        return bl;
    }

    private final void tryRevertProcessorPathProperty() {
        try {
            Class<?> optionsClass = this.javaTask.getOptions().getClass();
            Method setPath = optionsClass.getMethod("setAnnotationProcessorPath", FileCollection.class);
            setPath.invoke((Object)this.javaTask.getOptions(), this.originalProcessorPath);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private final String getProcessorStubClassName(String processorFqName) {
        return "AnnotationProcessorWrapper_" + this.taskQualifier + '_' + StringsKt.replace$default((String)processorFqName, (char)'.', (char)'_', (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void addCompilerArgument(@NotNull JavaCompile $receiver, String name, Function1<? super String, String> value) {
        int argIndex;
        List args;
        ArrayList newCompilerArgs$iv;
        void $receiver$iv;
        block5: {
            int n;
            void destination$iv$iv;
            void $receiver$iv$iv;
            JavaCompile javaCompile = $receiver;
            AnnotationProcessingManager this_$iv = this;
            CompileOptions compileOptions = $receiver$iv.getOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions, (String)"this.options");
            List list = compileOptions.getCompilerArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
            List compilerArgs$iv = list;
            Iterable iterable = compilerArgs$iv;
            Collection collection = new ArrayList();
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void p1$iv;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                void var13_12 = destination$iv$iv;
                String string = p1$iv.toString();
                var13_12.add(string);
            }
            newCompilerArgs$iv = (ArrayList)destination$iv$iv;
            List $receiver$iv2 = args = (List)newCompilerArgs$iv;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv2) {
                String it = (String)item$iv;
                if (Intrinsics.areEqual((Object)name, (Object)it)) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = argIndex = -1;
        }
        if (argIndex >= 0 && args.size() > argIndex + 1) {
            args.set(argIndex + 1, value.invoke(args.get(argIndex + 1)));
        } else {
            args.add(name);
            args.add(value.invoke(null));
        }
        CompileOptions compileOptions = $receiver$iv.getOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions, (String)"options");
        compileOptions.setCompilerArgs((List)newCompilerArgs$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void modifyCompilerArguments(@NotNull JavaCompile $receiver, Function1<? super List<String>, Unit> modifier) {
        void destination$iv;
        void $receiver$iv;
        CompileOptions compileOptions = $receiver.getOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions, (String)"this.options");
        List list = compileOptions.getCompilerArgs();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
        List compilerArgs = list;
        Iterable iterable = compilerArgs;
        Collection collection = new ArrayList();
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            void p1;
            Object item$iv;
            Object t = item$iv = iterator.next();
            void var13_9 = destination$iv;
            String string = p1.toString();
            var13_9.add(string);
        }
        ArrayList newCompilerArgs = (ArrayList)destination$iv;
        modifier.invoke((Object)newCompilerArgs);
        CompileOptions compileOptions2 = $receiver.getOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions2, (String)"options");
        compileOptions2.setCompilerArgs((List)newCompilerArgs);
    }

    private final Set<String> lookupAnnotationProcessors(Set<? extends File> files) {
        lookupAnnotationProcessors.1 withZipFile$ = lookupAnnotationProcessors.1.INSTANCE;
        HashSet annotationProcessors = new HashSet();
        Function1<Sequence<? extends String>, Unit> processLines$ = new Function1<Sequence<? extends String>, Unit>(annotationProcessors){
            final /* synthetic */ HashSet $annotationProcessors;

            public final void invoke(@NotNull Sequence<String> lines) {
                Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
                for (String line : lines) {
                    if (StringsKt.isBlank((CharSequence)line) || !AnnotationProcessingManager.Companion.getJAVA_FQNAME_PATTERN().matches((CharSequence)line)) continue;
                    this.$annotationProcessors.add(line);
                }
            }
            {
                this.$annotationProcessors = hashSet;
                super(1);
            }
        };
        for (File file : files) {
            withZipFile$.invoke(file, (Function1<? super ZipFile, Unit>)((Function1)new Function1<ZipFile, Unit>(processLines$){
                final /* synthetic */ lookupAnnotationProcessors.2 $processLines$2;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull ZipFile zipFile) {
                    Intrinsics.checkParameterIsNotNull((Object)zipFile, (String)"zipFile");
                    ZipEntry entry = zipFile.getEntry("META-INF/services/javax.annotation.processing.Processor");
                    if (entry != null) {
                        InputStream inputStream = zipFile.getInputStream(entry);
                        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"zipFile.getInputStream(entry)");
                        InputStream inputStream2 = inputStream;
                        Object object = Charsets.UTF_8;
                        Reader $receiver$iv = new InputStreamReader(inputStream2, (Charset)object);
                        object = $receiver$iv;
                        int n = 8192;
                        object = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
                        Throwable throwable = null;
                        try {
                            BufferedReader it$iv = (BufferedReader)object;
                            Sequence p1 = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                            this.$processLines$2.invoke((Sequence<String>)p1);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                        }
                    }
                }
                {
                    this.$processLines$2 = var1_1;
                    super(1);
                }
            }));
        }
        Project project = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Logger logger = project.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"project.logger");
        GradleUtilsKt.kotlinDebug(logger, "kapt: Discovered annotation processors: " + CollectionsKt.joinToString$default((Iterable)annotationProcessors, null, null, null, (int)0, null, null, (int)63, null));
        return annotationProcessors;
    }

    @NotNull
    public final File getAptOutputDir() {
        return this.aptOutputDir;
    }

    public AnnotationProcessingManager(@NotNull AbstractCompile task, @NotNull JavaCompile javaTask, @NotNull String taskQualifier, @NotNull Set<? extends File> aptFiles, @NotNull File aptOutputDir, @NotNull File aptWorkingDir, @Nullable Object androidVariant) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)javaTask, (String)"javaTask");
        Intrinsics.checkParameterIsNotNull((Object)taskQualifier, (String)"taskQualifier");
        Intrinsics.checkParameterIsNotNull(aptFiles, (String)"aptFiles");
        Intrinsics.checkParameterIsNotNull((Object)aptOutputDir, (String)"aptOutputDir");
        Intrinsics.checkParameterIsNotNull((Object)aptWorkingDir, (String)"aptWorkingDir");
        this.javaTask = javaTask;
        this.taskQualifier = taskQualifier;
        this.aptFiles = aptFiles;
        this.aptOutputDir = aptOutputDir;
        this.aptWorkingDir = aptWorkingDir;
        this.androidVariant = androidVariant;
        this.project = task.getProject();
        this.wrappersDirectory = new File(this.aptWorkingDir, "wrappers");
        this.hackAnnotationDir = new File(this.aptWorkingDir, "java_src");
    }

    public /* synthetic */ AnnotationProcessingManager(AbstractCompile abstractCompile, JavaCompile javaCompile, String string, Set set, File file, File file2, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            object = null;
        }
        this(abstractCompile, javaCompile, string, set, file, file2, object);
    }

    static {
        Companion = new Companion(null);
        String string = "^([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*$";
        JAVA_FQNAME_PATTERN = new Regex(string);
        GEN_ANNOTATION = GEN_ANNOTATION;
        ANDROID_APT_PLUGIN_ID = ANDROID_APT_PLUGIN_ID;
    }

    public static final /* synthetic */ void access$modifyCompilerArguments(AnnotationProcessingManager $this, @NotNull JavaCompile $receiver, @NotNull Function1 modifier) {
        $this.modifyCompilerArguments($receiver, (Function1<? super List<String>, Unit>)modifier);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/AnnotationProcessingManager$Companion;", "", "()V", "ANDROID_APT_PLUGIN_ID", "", "GEN_ANNOTATION", "getGEN_ANNOTATION", "()Ljava/lang/String;", "JAVA_FQNAME_PATTERN", "Lkotlin/text/Regex;", "getJAVA_FQNAME_PATTERN", "()Lkotlin/text/Regex;", "kotlin-gradle-plugin"})
    private static final class Companion {
        @NotNull
        public final Regex getJAVA_FQNAME_PATTERN() {
            return JAVA_FQNAME_PATTERN;
        }

        @NotNull
        public final String getGEN_ANNOTATION() {
            return GEN_ANNOTATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

