/*
 * Decompiled with CFR 0.152.
 */
package jodd.csselly;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jodd.csselly.CSSellyException;
import jodd.csselly.CSSellyLexer;
import jodd.csselly.Combinator;
import jodd.csselly.CssSelector;
import jodd.util.StringUtil;
import jodd.util.UnsafeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSelly {
    protected final CSSellyLexer lexer;

    public CSSelly(String input) {
        this(UnsafeUtil.getChars((String)input));
    }

    public CSSelly(char[] input) {
        this.lexer = new CSSellyLexer(input);
    }

    public List<CssSelector> parse() {
        try {
            this.lexer.yylex();
            if (this.lexer.selectors.isEmpty()) {
                return null;
            }
            CssSelector last = this.lexer.selectors.get(this.lexer.selectors.size() - 1);
            if (last.getCombinator() == Combinator.DESCENDANT) {
                last.setCombinator(null);
            }
            CssSelector prevCssSelector = null;
            for (CssSelector cssSelector : this.lexer.selectors) {
                if (prevCssSelector != null) {
                    cssSelector.setPrevCssSelector(prevCssSelector);
                }
                prevCssSelector = cssSelector;
            }
            return this.lexer.selectors;
        }
        catch (IOException ioex) {
            throw new CSSellyException(ioex);
        }
    }

    public static List<List<CssSelector>> parse(String query) {
        String[] singleQueries = StringUtil.splitc((String)query, (char)',');
        ArrayList<List<CssSelector>> selectors = new ArrayList<List<CssSelector>>(singleQueries.length);
        for (String singleQuery : singleQueries) {
            selectors.add(new CSSelly(singleQuery).parse());
        }
        return selectors;
    }

    public static String toString(List<CssSelector> selectors) {
        StringBuilder out = new StringBuilder();
        for (CssSelector s : selectors) {
            out.append(s.toString());
        }
        return out.toString();
    }
}

