/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.lang.ref.WeakReference;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyContinuation;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.ast.executable.RuntimeCache;
import org.jruby.exceptions.JumpException;
import org.jruby.ext.fiber.ThreadFiber;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.backtrace.BacktraceElement;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.profile.ProfileCollection;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.util.RecursiveComparator;
import org.jruby.util.RubyDateFormat;
import org.jruby.util.RubyDateFormatter;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public final class ThreadContext {
    private static final Logger LOG = LoggerFactory.getLogger("ThreadContext");
    private static final int INITIAL_SIZE = 10;
    private static final int INITIAL_FRAMES_SIZE = 10;
    private static final int CALL_POLL_COUNT = 4095;
    public final Ruby runtime;
    public final IRubyObject nil;
    public final RuntimeCache runtimeCache;
    public final boolean is19;
    private boolean isWithinTrace;
    private RubyThread thread;
    private RubyThread rootThread;
    private static final WeakReference<ThreadFiber> NULL_FIBER_REF = new WeakReference<Object>(null);
    private WeakReference<ThreadFiber> fiber = NULL_FIBER_REF;
    private ThreadFiber rootFiber;
    private RubyDateFormatter dateFormatter;
    private RubyModule[] parentStack = new RubyModule[10];
    private int parentIndex = -1;
    private Frame[] frameStack = new Frame[10];
    private int frameIndex = -1;
    private BacktraceElement[] backtrace = new BacktraceElement[10];
    private int backtraceIndex = -1;
    private DynamicScope[] scopeStack = new DynamicScope[10];
    private int scopeIndex = -1;
    private static final RubyContinuation.Continuation[] EMPTY_CATCHTARGET_STACK = new RubyContinuation.Continuation[0];
    private RubyContinuation.Continuation[] catchStack = EMPTY_CATCHTARGET_STACK;
    private int catchIndex = -1;
    private boolean isProfiling = false;
    private ProfileCollection profileCollection;
    private boolean eventHooksEnabled = true;
    CallType lastCallType;
    Visibility lastVisibility;
    IRubyObject lastExitStatus;
    public final SecureRandom secureRandom;
    private static boolean trySHA1PRNG = true;
    public int callNumber;
    private int currentMethodSerial;
    private Set<RecursiveComparator.Pair> recursiveSet;
    @Deprecated
    private RubyDateFormat dateFormat;

    public static ThreadContext newContext(Ruby runtime) {
        ThreadContext context = new ThreadContext(runtime);
        return context;
    }

    private ThreadContext(Ruby runtime) {
        SecureRandom sr;
        try {
            sr = trySHA1PRNG ? SecureRandom.getInstance("SHA1PRNG") : new SecureRandom();
        }
        catch (Exception e) {
            trySHA1PRNG = false;
            sr = new SecureRandom();
        }
        this.secureRandom = sr;
        this.callNumber = 0;
        this.currentMethodSerial = 0;
        this.runtime = runtime;
        this.nil = runtime.getNil();
        this.is19 = runtime.is1_9();
        if (runtime.getInstanceConfig().isProfilingEntireRun()) {
            this.startProfiling();
        }
        this.runtimeCache = runtime.getRuntimeCache();
        StaticScope topStaticScope = runtime.getStaticScopeFactory().newLocalScope(null);
        this.pushScope(new ManyVarsDynamicScope(topStaticScope, null));
        Frame[] stack = this.frameStack;
        int length2 = stack.length;
        for (int i2 = 0; i2 < length2; ++i2) {
            stack[i2] = new Frame();
        }
        BacktraceElement[] stack2 = this.backtrace;
        int length22 = stack2.length;
        for (int i3 = 0; i3 < length22; ++i3) {
            stack2[i3] = new BacktraceElement();
        }
        ThreadContext.pushBacktrace(this, "", "", 0);
        ThreadContext.pushBacktrace(this, "", "", 0);
    }

    protected void finalize() throws Throwable {
        if (this.thread != null) {
            this.thread.dispose();
        }
    }

    public final Ruby getRuntime() {
        return this.runtime;
    }

    public IRubyObject getErrorInfo() {
        return this.thread.getErrorInfo();
    }

    public IRubyObject setErrorInfo(IRubyObject errorInfo) {
        this.thread.setErrorInfo(errorInfo);
        return errorInfo;
    }

    public JumpException.ReturnJump returnJump(IRubyObject value2) {
        return new JumpException.ReturnJump(this.getFrameJumpTarget(), value2);
    }

    public void setLastCallStatus(CallType callType) {
        this.lastCallType = callType;
    }

    public CallType getLastCallType() {
        return this.lastCallType;
    }

    public void setLastVisibility(Visibility visibility) {
        this.lastVisibility = visibility;
    }

    public Visibility getLastVisibility() {
        return this.lastVisibility;
    }

    public void setLastCallStatusAndVisibility(CallType callType, Visibility visibility) {
        this.lastCallType = callType;
        this.lastVisibility = visibility;
    }

    public IRubyObject getLastExitStatus() {
        return this.lastExitStatus;
    }

    public void setLastExitStatus(IRubyObject lastExitStatus) {
        this.lastExitStatus = lastExitStatus;
    }

    public void printScope() {
        LOG.debug("SCOPE STACK:", new Object[0]);
        for (int i2 = 0; i2 <= this.scopeIndex; ++i2) {
            LOG.debug("{}", this.scopeStack[i2]);
        }
    }

    public DynamicScope getCurrentScope() {
        return this.scopeStack[this.scopeIndex];
    }

    public StaticScope getCurrentStaticScope() {
        return this.scopeStack[this.scopeIndex].getStaticScope();
    }

    public DynamicScope getPreviousScope() {
        return this.scopeStack[this.scopeIndex - 1];
    }

    private void expandFramesIfNecessary() {
        int newSize = this.frameStack.length * 2;
        this.frameStack = this.fillNewFrameStack(new Frame[newSize], newSize);
    }

    private Frame[] fillNewFrameStack(Frame[] newFrameStack, int newSize) {
        System.arraycopy(this.frameStack, 0, newFrameStack, 0, this.frameStack.length);
        for (int i2 = this.frameStack.length; i2 < newSize; ++i2) {
            newFrameStack[i2] = new Frame();
        }
        return newFrameStack;
    }

    private void expandParentsIfNecessary() {
        int newSize = this.parentStack.length * 2;
        RubyModule[] newParentStack = new RubyModule[newSize];
        System.arraycopy(this.parentStack, 0, newParentStack, 0, this.parentStack.length);
        this.parentStack = newParentStack;
    }

    public void pushScope(DynamicScope scope) {
        int index2 = ++this.scopeIndex;
        DynamicScope[] stack = this.scopeStack;
        stack[index2] = scope;
        if (index2 + 1 == stack.length) {
            this.expandScopesIfNecessary();
        }
    }

    public void popScope() {
        this.scopeStack[this.scopeIndex--] = null;
    }

    private void expandScopesIfNecessary() {
        int newSize = this.scopeStack.length * 2;
        DynamicScope[] newScopeStack = new DynamicScope[newSize];
        System.arraycopy(this.scopeStack, 0, newScopeStack, 0, this.scopeStack.length);
        this.scopeStack = newScopeStack;
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public RubyThread getFiberCurrentThread() {
        if (this.rootThread != null) {
            return this.rootThread;
        }
        return this.thread;
    }

    public RubyDateFormatter getRubyDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new RubyDateFormatter(this);
        }
        return this.dateFormatter;
    }

    public void setThread(RubyThread thread2) {
        this.thread = thread2;
        this.rootThread = thread2;
        if (thread2 != null) {
            thread2.setContext(this);
        }
    }

    public ThreadFiber getFiber() {
        ThreadFiber f = (ThreadFiber)this.fiber.get();
        if (f == null) {
            return this.rootFiber;
        }
        return f;
    }

    public void setFiber(ThreadFiber fiber2) {
        this.fiber = new WeakReference<ThreadFiber>(fiber2);
    }

    public void setRootFiber(ThreadFiber rootFiber) {
        this.rootFiber = rootFiber;
    }

    public void setRootThread(RubyThread rootThread) {
        this.rootThread = rootThread;
    }

    private void expandCatchIfNecessary() {
        int newSize = this.catchStack.length * 2;
        if (newSize == 0) {
            newSize = 1;
        }
        RubyContinuation.Continuation[] newCatchStack = new RubyContinuation.Continuation[newSize];
        System.arraycopy(this.catchStack, 0, newCatchStack, 0, this.catchStack.length);
        this.catchStack = newCatchStack;
    }

    public void pushCatch(RubyContinuation.Continuation catchTarget) {
        int index2;
        if ((index2 = ++this.catchIndex) == this.catchStack.length) {
            this.expandCatchIfNecessary();
        }
        this.catchStack[index2] = catchTarget;
    }

    public void popCatch() {
        --this.catchIndex;
    }

    public RubyContinuation.Continuation getActiveCatch(Object tag2) {
        ThreadFiber prev;
        for (int i2 = this.catchIndex; i2 >= 0; --i2) {
            RubyContinuation.Continuation c = this.catchStack[i2];
            if (!(this.runtime.is1_9() ? c.tag == tag2 : c.tag.equals(tag2))) continue;
            return c;
        }
        ThreadFiber fiber2 = this.getFiber();
        if (fiber2 != null && (prev = fiber2.getData().getPrev()) != null) {
            return prev.getThread().getContext().getActiveCatch(tag2);
        }
        return null;
    }

    private void pushFrameCopy() {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        Frame currentFrame = stack[index2 - 1];
        stack[index2].updateFrame(currentFrame);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private Frame pushFrame(Frame frame) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2] = frame;
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
        return frame;
    }

    private void pushCallFrame(RubyModule clazz, String name2, IRubyObject self2, Block block) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2].updateFrame(clazz, self2, name2, block, this.callNumber);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushEvalFrame(IRubyObject self2) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2].updateFrameForEval(self2, this.callNumber);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    public void pushFrame() {
        int index2;
        Frame[] stack = this.frameStack;
        if ((index2 = ++this.frameIndex) + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    public void popFrame() {
        int index2;
        Frame frame;
        Frame[] stack = this.frameStack;
        if ((frame = stack[index2 = this.frameIndex--]).isCaptured()) {
            stack[index2] = new Frame();
        } else {
            frame.clear();
        }
    }

    private void popFrameReal(Frame oldFrame) {
        this.frameStack[this.frameIndex--] = oldFrame;
    }

    public Frame getCurrentFrame() {
        return this.frameStack[this.frameIndex];
    }

    public Frame getNextFrame() {
        int index2 = this.frameIndex;
        Frame[] stack = this.frameStack;
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
        return stack[index2 + 1];
    }

    public Frame getPreviousFrame() {
        int index2 = this.frameIndex;
        return index2 < 1 ? null : this.frameStack[index2 - 1];
    }

    public IRubyObject setBackRef(IRubyObject match2) {
        return this.getCurrentFrame().setBackRef(match2);
    }

    public IRubyObject getBackRef() {
        return this.getCurrentFrame().getBackRef(this.nil);
    }

    public IRubyObject setLastLine(IRubyObject last2) {
        return this.getCurrentFrame().setLastLine(last2);
    }

    public IRubyObject getLastLine() {
        return this.getCurrentFrame().getLastLine(this.nil);
    }

    private static void expandBacktraceIfNecessary(ThreadContext context) {
        int newSize = context.backtrace.length * 2;
        context.backtrace = ThreadContext.fillNewBacktrace(context, new BacktraceElement[newSize], newSize);
    }

    private static BacktraceElement[] fillNewBacktrace(ThreadContext context, BacktraceElement[] newBacktrace, int newSize) {
        System.arraycopy(context.backtrace, 0, newBacktrace, 0, context.backtrace.length);
        for (int i2 = context.backtrace.length; i2 < newSize; ++i2) {
            newBacktrace[i2] = new BacktraceElement();
        }
        return newBacktrace;
    }

    public static void pushBacktrace(ThreadContext context, String method2, ISourcePosition position) {
        int index2 = ++context.backtraceIndex;
        BacktraceElement[] stack = context.backtrace;
        BacktraceElement.update(stack[index2], method2, position);
        if (index2 + 1 == stack.length) {
            ThreadContext.expandBacktraceIfNecessary(context);
        }
    }

    public static void pushBacktrace(ThreadContext context, String method2, String file2, int line) {
        int index2 = ++context.backtraceIndex;
        BacktraceElement[] stack = context.backtrace;
        BacktraceElement.update(stack[index2], method2, file2, line);
        if (index2 + 1 == stack.length) {
            ThreadContext.expandBacktraceIfNecessary(context);
        }
    }

    public static void popBacktrace(ThreadContext context) {
        --context.backtraceIndex;
    }

    public boolean isJumpTargetAlive(int target, int skipFrames) {
        for (int i2 = this.frameIndex - skipFrames; i2 >= 0; --i2) {
            if (this.frameStack[i2].getJumpTarget() != target) continue;
            return true;
        }
        return false;
    }

    public boolean scopeExistsOnCallStack(StaticScope s2) {
        DynamicScope[] stack = this.scopeStack;
        for (int i2 = this.scopeIndex; i2 >= 0; --i2) {
            if (stack[i2].getStaticScope() != s2) continue;
            return true;
        }
        return false;
    }

    public String getFrameName() {
        return this.getCurrentFrame().getName();
    }

    public IRubyObject getFrameSelf() {
        return this.getCurrentFrame().getSelf();
    }

    public int getFrameJumpTarget() {
        return this.getCurrentFrame().getJumpTarget();
    }

    public RubyModule getFrameKlazz() {
        return this.getCurrentFrame().getKlazz();
    }

    public Block getFrameBlock() {
        return this.getCurrentFrame().getBlock();
    }

    public String getFile() {
        return this.backtrace[this.backtraceIndex].filename;
    }

    public int getLine() {
        return this.backtrace[this.backtraceIndex].line;
    }

    public void setLine(int line) {
        this.backtrace[this.backtraceIndex].line = line;
    }

    public void setFileAndLine(String file2, int line) {
        BacktraceElement b2 = this.backtrace[this.backtraceIndex];
        b2.filename = file2;
        b2.line = line;
    }

    public void setFileAndLine(ISourcePosition position) {
        BacktraceElement b2 = this.backtrace[this.backtraceIndex];
        b2.filename = position.getFile();
        b2.line = position.getStartLine();
    }

    public Visibility getCurrentVisibility() {
        return this.getCurrentFrame().getVisibility();
    }

    public Visibility getPreviousVisibility() {
        return this.getPreviousFrame().getVisibility();
    }

    public void setCurrentVisibility(Visibility visibility) {
        this.getCurrentFrame().setVisibility(visibility);
    }

    public void pollThreadEvents() {
        this.thread.pollThreadEvents(this);
    }

    public int getCurrentTarget() {
        return this.callNumber;
    }

    public void callThreadPoll() {
        if ((this.callNumber++ & 0xFFF) == 0) {
            this.pollThreadEvents();
        }
    }

    public static void callThreadPoll(ThreadContext context) {
        if ((context.callNumber++ & 0xFFF) == 0) {
            context.pollThreadEvents();
        }
    }

    public void trace(RubyEvent event2, String name2, RubyModule implClass) {
        this.trace(event2, name2, implClass, this.backtrace[this.backtraceIndex].filename, this.backtrace[this.backtraceIndex].line);
    }

    public void trace(RubyEvent event2, String name2, RubyModule implClass, String file2, int line) {
        this.runtime.callEventHooks(this, event2, file2, line, name2, implClass);
    }

    public void pushRubyClass(RubyModule currentModule) {
        int index2 = ++this.parentIndex;
        RubyModule[] stack = this.parentStack;
        stack[index2] = currentModule;
        if (index2 + 1 == stack.length) {
            this.expandParentsIfNecessary();
        }
    }

    public RubyModule popRubyClass() {
        int index2 = this.parentIndex;
        RubyModule[] stack = this.parentStack;
        RubyModule ret = stack[index2];
        stack[index2] = null;
        this.parentIndex = index2 - 1;
        return ret;
    }

    public RubyModule getRubyClass() {
        assert (this.parentIndex != -1) : "Trying to getService RubyClass from empty stack";
        RubyModule parentModule = this.parentStack[this.parentIndex];
        return parentModule.getNonIncludedClass();
    }

    public RubyModule getPreviousRubyClass() {
        assert (this.parentIndex != 0) : "Trying to getService RubyClass from too-shallow stack";
        RubyModule parentModule = this.parentStack[this.parentIndex - 1];
        return parentModule.getNonIncludedClass();
    }

    @Deprecated
    public boolean getConstantDefined(String internedName) {
        return this.getCurrentStaticScope().isConstantDefined(internedName);
    }

    @Deprecated
    public IRubyObject getConstant(String internedName) {
        return this.getCurrentStaticScope().getConstant(internedName);
    }

    @Deprecated
    public IRubyObject setConstantInCurrent(String internedName, IRubyObject result2) {
        return this.getCurrentStaticScope().setConstant(internedName, result2);
    }

    @Deprecated
    public IRubyObject setConstantInModule(String internedName, IRubyObject target, IRubyObject result2) {
        if (!(target instanceof RubyModule)) {
            throw this.runtime.newTypeError(target.toString() + " is not a class/module");
        }
        RubyModule module = (RubyModule)target;
        module.setConstant(internedName, result2);
        return result2;
    }

    @Deprecated
    public IRubyObject setConstantInObject(String internedName, IRubyObject result2) {
        this.runtime.getObject().setConstant(internedName, result2);
        return result2;
    }

    public void renderCurrentBacktrace(StringBuilder sb) {
        TraceType traceType = this.runtime.getInstanceConfig().getTraceType();
        BacktraceData backtraceData = traceType.getBacktrace(this, false);
        traceType.getFormat().renderBacktrace(backtraceData.getBacktrace(this.runtime), sb, false);
    }

    public IRubyObject createCallerBacktrace(int level2, StackTraceElement[] stacktrace) {
        return this.createCallerBacktrace(level2, null, stacktrace);
    }

    public IRubyObject createCallerBacktrace(int level2, Integer length2, StackTraceElement[] stacktrace) {
        this.runtime.incrementCallerCount();
        RubyStackTraceElement[] trace = this.getTraceSubset(level2, length2, stacktrace);
        if (trace == null) {
            return this.nil;
        }
        RubyArray newTrace = this.runtime.newArray(trace.length);
        int i2 = level2;
        while (i2 - level2 < trace.length) {
            RubyString str = RubyString.newString(this.runtime, trace[i2 - level2].mriStyleString());
            newTrace.append(str);
            ++i2;
        }
        if (RubyInstanceConfig.LOG_CALLERS) {
            TraceType.dumpCaller(newTrace);
        }
        return newTrace;
    }

    public IRubyObject createCallerLocations(int level2, Integer length2, StackTraceElement[] stacktrace) {
        RubyStackTraceElement[] trace = this.getTraceSubset(level2, length2, stacktrace);
        if (trace == null) {
            return this.nil;
        }
        return RubyThread.Location.newLocationArray(this.runtime, trace);
    }

    private RubyStackTraceElement[] getTraceSubset(int level2, Integer length2, StackTraceElement[] stacktrace) {
        this.runtime.incrementCallerCount();
        if (length2 != null && length2 == 0) {
            return new RubyStackTraceElement[0];
        }
        RubyStackTraceElement[] trace = TraceType.Gather.CALLER.getBacktraceData(this, stacktrace, false).getBacktrace(this.runtime);
        int traceLength = ThreadContext.safeLength(level2, length2, trace);
        if (traceLength < 0) {
            return null;
        }
        trace = Arrays.copyOfRange(trace, level2, level2 + traceLength);
        if (RubyInstanceConfig.LOG_CALLERS) {
            TraceType.dumpCaller(trace);
        }
        return trace;
    }

    private static int safeLength(int level2, Integer length2, RubyStackTraceElement[] trace) {
        int baseLength = trace.length - level2;
        return length2 != null ? Math.min(length2, baseLength) : baseLength;
    }

    public RubyStackTraceElement[] createWarningBacktrace(Ruby runtime) {
        runtime.incrementWarningCount();
        RubyStackTraceElement[] trace = this.gatherCallerBacktrace();
        if (RubyInstanceConfig.LOG_WARNINGS) {
            TraceType.dumpWarning(trace);
        }
        return trace;
    }

    public RubyStackTraceElement[] gatherCallerBacktrace() {
        return TraceType.Gather.CALLER.getBacktraceData(this, false).getBacktrace(this.runtime);
    }

    public Frame[] createBacktrace(int level2, boolean nativeException) {
        Frame[] traceFrames;
        int traceSize = this.frameIndex - level2 + 1;
        if (traceSize <= 0) {
            return null;
        }
        if (nativeException) {
            traceFrames = new Frame[traceSize + 1];
            traceFrames[traceSize] = this.frameStack[this.frameIndex];
        } else {
            traceFrames = new Frame[traceSize];
        }
        System.arraycopy(this.frameStack, 0, traceFrames, 0, traceSize);
        return traceFrames;
    }

    public boolean isEventHooksEnabled() {
        return this.eventHooksEnabled;
    }

    public void setEventHooksEnabled(boolean flag) {
        this.eventHooksEnabled = flag;
    }

    public BacktraceElement[] createBacktrace2(int level2, boolean nativeException) {
        BacktraceElement[] backtrace2 = (BacktraceElement[])this.backtrace.clone();
        BacktraceElement[] newTrace = new BacktraceElement[this.backtraceIndex + 1];
        System.arraycopy(backtrace2, 0, newTrace, 0, newTrace.length);
        return newTrace;
    }

    private static String createRubyBacktraceString(StackTraceElement element) {
        return element.getFileName() + ':' + element.getLineNumber() + ":in `" + element.getMethodName() + '\'';
    }

    public static String createRawBacktraceStringFromThrowable(Throwable t) {
        StackTraceElement[] javaStackTrace = t.getStackTrace();
        StringBuilder buffer = new StringBuilder();
        if (javaStackTrace != null && javaStackTrace.length > 0) {
            StackTraceElement element = javaStackTrace[0];
            buffer.append(ThreadContext.createRubyBacktraceString(element)).append(": ").append(t.toString()).append("\n");
            for (int i2 = 1; i2 < javaStackTrace.length; ++i2) {
                element = javaStackTrace[i2];
                buffer.append("\tfrom ").append(ThreadContext.createRubyBacktraceString(element));
                if (i2 + 1 >= javaStackTrace.length) continue;
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    public static RubyStackTraceElement[] gatherRawBacktrace(Ruby runtime, StackTraceElement[] stackTrace) {
        ArrayList<RubyStackTraceElement> trace = new ArrayList<RubyStackTraceElement>(stackTrace.length);
        for (int i2 = 0; i2 < stackTrace.length; ++i2) {
            StackTraceElement element = stackTrace[i2];
            trace.add(new RubyStackTraceElement(element));
        }
        RubyStackTraceElement[] rubyStackTrace = new RubyStackTraceElement[trace.size()];
        return trace.toArray(rubyStackTrace);
    }

    private Frame pushFrameForBlock(Binding binding2) {
        Frame lastFrame = this.getNextFrame();
        Frame f = this.pushFrame(binding2.getFrame());
        f.setVisibility(binding2.getVisibility());
        return lastFrame;
    }

    private Frame pushFrameForEval(Binding binding2) {
        Frame lastFrame = this.getNextFrame();
        Frame f = this.pushFrame(binding2.getFrame());
        f.setVisibility(binding2.getVisibility());
        return lastFrame;
    }

    public void preAdoptThread() {
        this.pushFrame();
        this.pushRubyClass(this.runtime.getObject());
        this.getCurrentFrame().setSelf(this.runtime.getTopSelf());
    }

    public void preExtensionLoad(IRubyObject self2) {
        this.pushFrame();
        this.pushRubyClass(this.runtime.getObject());
        this.getCurrentFrame().setSelf(self2);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
    }

    public void postExtensionLoad() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preCompiledClass(RubyModule type2, StaticScope staticScope) {
        this.pushRubyClass(type2);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type2);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        staticScope.setModule(type2);
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
    }

    public void preCompiledClassDummyScope(RubyModule type2, StaticScope staticScope) {
        this.pushRubyClass(type2);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type2);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        staticScope.setModule(type2);
        this.pushScope(staticScope.getDummyScope());
    }

    public void postCompiledClass() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preScopeNode(StaticScope staticScope) {
        this.pushScope(DynamicScope.newDynamicScope(staticScope, this.getCurrentScope()));
    }

    public void postScopeNode() {
        this.popScope();
    }

    public void preClassEval(StaticScope staticScope, RubyModule type2) {
        this.pushRubyClass(type2);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type2);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        this.getCurrentFrame().setName(null);
        this.pushScope(DynamicScope.newDynamicScope(staticScope, null));
    }

    public void postClassEval() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preBsfApply(String[] names2) {
        StaticScope staticScope = this.runtime.getStaticScopeFactory().newLocalScope(null);
        staticScope.setVariables(names2);
        this.pushFrame();
    }

    public void postBsfApply() {
        this.popFrame();
    }

    public void preMethodFrameAndClass(RubyModule implClass, String name2, IRubyObject self2, Block block, StaticScope staticScope) {
        RubyModule ssModule = staticScope.getModule();
        if (ssModule == null) {
            ssModule = implClass;
        }
        this.pushRubyClass(ssModule);
        this.pushCallFrame(implClass, name2, self2, block);
    }

    public void preMethodFrameAndScope(RubyModule clazz, String name2, IRubyObject self2, Block block, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushCallFrame(clazz, name2, self2, block);
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(implementationClass);
    }

    public void preMethodFrameAndDummyScope(RubyModule clazz, String name2, IRubyObject self2, Block block, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushCallFrame(clazz, name2, self2, block);
        this.pushScope(staticScope.getDummyScope());
        this.pushRubyClass(implementationClass);
    }

    public void preMethodNoFrameAndDummyScope(RubyModule clazz, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(staticScope.getDummyScope());
        this.pushRubyClass(implementationClass);
    }

    public void postMethodFrameAndScope() {
        this.popRubyClass();
        this.popScope();
        this.popFrame();
    }

    public void preMethodFrameOnly(RubyModule clazz, String name2, IRubyObject self2, Block block) {
        this.pushRubyClass(clazz);
        this.pushCallFrame(clazz, name2, self2, block);
    }

    public void postMethodFrameOnly() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preMethodScopeOnly(RubyModule clazz, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(implementationClass);
    }

    public void postMethodScopeOnly() {
        this.popRubyClass();
        this.popScope();
    }

    public void preMethodBacktraceAndScope(String name2, RubyModule clazz, StaticScope staticScope) {
        this.preMethodScopeOnly(clazz, staticScope);
    }

    public void postMethodBacktraceAndScope() {
        this.postMethodScopeOnly();
    }

    public void preMethodBacktraceOnly(String name2) {
    }

    public void preMethodBacktraceDummyScope(RubyModule clazz, String name2, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(staticScope.getDummyScope());
        this.pushRubyClass(implementationClass);
    }

    public void postMethodBacktraceOnly() {
    }

    public void postMethodBacktraceDummyScope() {
        this.popRubyClass();
        this.popScope();
    }

    public void prepareTopLevel(RubyClass objectClass, IRubyObject topSelf) {
        this.pushFrame();
        this.setCurrentVisibility(Visibility.PRIVATE);
        this.pushRubyClass(objectClass);
        Frame frame = this.getCurrentFrame();
        frame.setSelf(topSelf);
        this.getCurrentScope().getStaticScope().setModule(objectClass);
    }

    public void preNodeEval(RubyModule rubyClass, IRubyObject self2, String name2) {
        this.pushRubyClass(rubyClass);
        this.pushEvalFrame(self2);
    }

    public void preNodeEval(RubyModule rubyClass, IRubyObject self2) {
        this.pushRubyClass(rubyClass);
        this.pushEvalFrame(self2);
    }

    public void postNodeEval() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preExecuteUnder(IRubyObject self2, RubyModule executeUnderClass, Block block) {
        Frame frame = this.getCurrentFrame();
        this.pushRubyClass(executeUnderClass);
        DynamicScope scope = this.getCurrentScope();
        StaticScope sScope = this.runtime.getStaticScopeFactory().newBlockScope(scope.getStaticScope());
        sScope.setModule(executeUnderClass);
        this.pushScope(DynamicScope.newDynamicScope(sScope, scope));
        this.pushCallFrame(frame.getKlazz(), frame.getName(), self2, block);
        this.getCurrentFrame().setVisibility(this.getPreviousFrame().getVisibility());
    }

    public void postExecuteUnder() {
        this.popFrame();
        this.popScope();
        this.popRubyClass();
    }

    public void preMproc() {
        this.pushFrame();
    }

    public void postMproc() {
        this.popFrame();
    }

    public void preTrace() {
        this.setWithinTrace(true);
        this.pushFrame();
    }

    public void postTrace() {
        this.popFrame();
        this.setWithinTrace(false);
    }

    public Frame preForBlock(Binding binding2, RubyModule klass) {
        Frame lastFrame = this.preYieldNoScope(binding2, klass);
        this.pushScope(binding2.getDynamicScope());
        return lastFrame;
    }

    public Frame preYieldSpecificBlock(Binding binding2, StaticScope scope, RubyModule klass) {
        Frame lastFrame = this.preYieldNoScope(binding2, klass);
        this.pushScope(DynamicScope.newDynamicScope(scope, binding2.getDynamicScope()));
        return lastFrame;
    }

    public Frame preYieldLightBlock(Binding binding2, DynamicScope emptyScope, RubyModule klass) {
        Frame lastFrame = this.preYieldNoScope(binding2, klass);
        this.pushScope(emptyScope);
        return lastFrame;
    }

    public Frame preYieldNoScope(Binding binding2, RubyModule klass) {
        this.pushRubyClass(klass != null ? klass : binding2.getKlass());
        return this.pushFrameForBlock(binding2);
    }

    public void preEvalScriptlet(DynamicScope scope) {
        this.pushScope(scope);
    }

    public void postEvalScriptlet() {
        this.popScope();
    }

    public Frame preEvalWithBinding(Binding binding2) {
        Frame lastFrame = this.pushFrameForEval(binding2);
        this.pushRubyClass(binding2.getKlass());
        return lastFrame;
    }

    public void postEvalWithBinding(Binding binding2, Frame lastFrame) {
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYield(Binding binding2, Frame lastFrame) {
        this.popScope();
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYieldLight(Binding binding2, Frame lastFrame) {
        this.popScope();
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYieldNoScope(Frame lastFrame) {
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void preScopedBody(DynamicScope scope) {
        this.pushScope(scope);
    }

    public void postScopedBody() {
        this.popScope();
    }

    public boolean isWithinTrace() {
        return this.isWithinTrace;
    }

    public void setWithinTrace(boolean isWithinTrace) {
        this.isWithinTrace = isWithinTrace;
    }

    public Binding currentBinding() {
        Frame frame = this.getCurrentFrame().capture();
        return new Binding(frame, this.parentIndex < 0 ? frame.getKlazz() : this.getRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    public Binding currentBinding(IRubyObject self2) {
        Frame frame = this.getCurrentFrame().capture();
        return new Binding(self2, frame, frame.getVisibility(), this.getRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    public Binding currentBinding(IRubyObject self2, Visibility visibility) {
        Frame frame = this.getCurrentFrame().capture();
        return new Binding(self2, frame, visibility, this.getRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    public Binding currentBinding(IRubyObject self2, DynamicScope scope) {
        Frame frame = this.getCurrentFrame().capture();
        return new Binding(self2, frame, frame.getVisibility(), this.getRubyClass(), scope, this.backtrace[this.backtraceIndex].clone());
    }

    public Binding currentBinding(IRubyObject self2, Visibility visibility, DynamicScope scope) {
        Frame frame = this.getCurrentFrame().capture();
        return new Binding(self2, frame, visibility, this.getRubyClass(), scope, this.backtrace[this.backtraceIndex].clone());
    }

    @Deprecated
    public Binding previousBinding() {
        Frame frame = this.getPreviousFrame();
        return new Binding(frame, this.getPreviousRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    @Deprecated
    public Binding previousBinding(IRubyObject self2) {
        Frame frame = this.getPreviousFrame();
        return new Binding(self2, frame, frame.getVisibility(), this.getPreviousRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    public ProfileCollection getProfileCollection() {
        return this.profileCollection;
    }

    public void startProfiling() {
        this.isProfiling = true;
        this.profileCollection = this.getRuntime().getProfilingService().newProfileCollection(this);
    }

    public void stopProfiling() {
        this.isProfiling = false;
    }

    public boolean isProfiling() {
        return this.isProfiling;
    }

    public int profileEnter(int nextMethod) {
        int previousMethodSerial = this.currentMethodSerial;
        this.currentMethodSerial = nextMethod;
        if (this.isProfiling()) {
            this.getProfileCollection().profileEnter(nextMethod);
        }
        return previousMethodSerial;
    }

    public int profileEnter(String name2, DynamicMethod nextMethod) {
        if (this.isProfiling()) {
            this.getRuntime().getProfiledMethods().addProfiledMethod(name2, nextMethod);
        }
        return this.profileEnter((int)nextMethod.getSerialNumber());
    }

    public int profileExit(int nextMethod, long startTime) {
        int previousMethodSerial = this.currentMethodSerial;
        this.currentMethodSerial = nextMethod;
        if (this.isProfiling()) {
            this.getProfileCollection().profileExit(nextMethod, startTime);
        }
        return previousMethodSerial;
    }

    public Set<RecursiveComparator.Pair> getRecursiveSet() {
        return this.recursiveSet;
    }

    public void setRecursiveSet(Set<RecursiveComparator.Pair> recursiveSet) {
        this.recursiveSet = recursiveSet;
    }

    @Deprecated
    public void setFile(String file2) {
        this.backtrace[this.backtraceIndex].filename = file2;
    }

    @Deprecated
    public RubyDateFormat getRubyDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new RubyDateFormat("-", Locale.US, this.runtime.is1_9());
        }
        return this.dateFormat;
    }
}

