/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.backtrace;

import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.PrintStream;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.backtrace.BacktraceElement;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class TraceType {
    private static final Logger LOG = LoggerFactory.getLogger("TraceType");
    private final Gather gather;
    private final Format format;
    private static final String FIRST_COLOR = "\u001b[0;31m";
    private static final String KERNEL_COLOR = "\u001b[0;36m";
    private static final String EVAL_COLOR = "\u001b[0;33m";
    private static final String CLEAR_COLOR = "\u001b[0m";

    public TraceType(Gather gather, Format format) {
        this.gather = gather;
        this.format = format;
    }

    public Gather getGather() {
        return this.gather;
    }

    public Format getFormat() {
        return this.format;
    }

    public BacktraceData getBacktrace(ThreadContext context, boolean nativeException) {
        return this.gather.getBacktraceData(context, nativeException);
    }

    public BacktraceData getIntegratedBacktrace(ThreadContext context, StackTraceElement[] javaTrace) {
        return this.gather.getIntegratedBacktraceData(context, javaTrace);
    }

    public String printBacktrace(RubyException exception2, boolean console) {
        return this.format.printBacktrace(exception2, console);
    }

    public static void logBacktrace(RubyStackTraceElement[] trace) {
        LOG.info("Backtrace generated:", new Object[0]);
        for (RubyStackTraceElement element : trace) {
            LOG.info("  " + element.getFileName() + ":" + element.getLineNumber() + " in " + element.getMethodName(), new Object[0]);
        }
    }

    public static void dumpException(RubyException exception2) {
        LOG.info("Exception raised: {} : {}", exception2.getMetaClass(), exception2);
    }

    public static void dumpBacktrace(RubyException exception2) {
        Ruby runtime = exception2.getRuntime();
        System.err.println("Backtrace generated:\n" + Format.JRUBY.printBacktrace(exception2, runtime.getPosix().isatty(FileDescriptor.err)));
    }

    public static void dumpCaller(RubyArray trace) {
        LOG.info("Caller backtrace generated:\n" + trace, new Object[0]);
    }

    public static void dumpCaller(RubyStackTraceElement[] trace) {
        LOG.info("Caller backtrace generated:\n" + Arrays.toString(trace), new Object[0]);
    }

    public static void dumpWarning(RubyStackTraceElement[] trace) {
        LOG.info("Warning backtrace generated:\n" + Arrays.toString(trace), new Object[0]);
    }

    public static TraceType traceTypeFor(String style) {
        if (style.equalsIgnoreCase("raw")) {
            return new TraceType(Gather.RAW, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("ruby_framed")) {
            return new TraceType(Gather.NORMAL, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("normal")) {
            return new TraceType(Gather.NORMAL, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("rubinius")) {
            return new TraceType(Gather.NORMAL, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("full")) {
            return new TraceType(Gather.FULL, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("mri")) {
            return new TraceType(Gather.NORMAL, Format.MRI);
        }
        return new TraceType(Gather.NORMAL, Format.JRUBY);
    }

    protected static String printBacktraceMRI(RubyException exception2, boolean console) {
        Ruby runtime = exception2.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        IRubyObject backtrace2 = exception2.callMethod(context, "backtrace");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream errorStream = new PrintStream(baos);
        boolean printedPosition = false;
        if (backtrace2.isNil() || !(backtrace2 instanceof RubyArray)) {
            if (context.getFile() != null && context.getFile().length() > 0) {
                errorStream.print(context.getFile() + ':' + context.getLine());
                printedPosition = true;
            } else {
                errorStream.print(context.getLine());
                printedPosition = true;
            }
        } else if (((RubyArray)backtrace2).getLength() == 0) {
            TraceType.printErrorPos(context, errorStream);
        } else {
            IRubyObject mesg = ((RubyArray)backtrace2).first();
            if (mesg.isNil()) {
                TraceType.printErrorPos(context, errorStream);
            } else {
                errorStream.print(mesg);
                printedPosition = true;
            }
        }
        RubyClass type2 = exception2.getMetaClass();
        String info = exception2.toString();
        if (type2 == runtime.getRuntimeError() && (info == null || info.length() == 0)) {
            errorStream.print(": unhandled exception\n");
        } else {
            if (printedPosition) {
                errorStream.print(": ");
            }
            String path2 = type2.getName();
            if (info.length() == 0) {
                errorStream.print(path2 + '\n');
            } else {
                if (path2.startsWith("#")) {
                    path2 = null;
                }
                String tail = null;
                int idx = info.indexOf(10);
                if (idx != -1) {
                    tail = info.substring(idx + 1);
                    info = info.substring(0, idx);
                }
                errorStream.print(info);
                if (path2 != null) {
                    errorStream.print(" (" + path2 + ")\n");
                }
                if (tail != null) {
                    errorStream.print(tail + '\n');
                }
            }
        }
        exception2.printBacktrace(errorStream, 1);
        return new String(baos.toByteArray());
    }

    protected static String printBacktraceJRuby(RubyException exception2, boolean console) {
        Ruby runtime = exception2.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        StringBuilder buffer = new StringBuilder();
        boolean color = console && runtime.getInstanceConfig().getBacktraceColor();
        String message2 = exception2.message(context).toString();
        if (exception2.getMetaClass() == runtime.getRuntimeError() && message2.length() == 0) {
            message2 = "No current exception";
        }
        buffer.append(exception2.getMetaClass().getName()).append(": ").append(message2).append('\n');
        RubyStackTraceElement[] frames = exception2.getBacktraceElements();
        if (frames == null) {
            frames = RubyStackTraceElement.EMPTY_ARRAY;
        }
        TraceType.renderBacktraceJRuby(frames, buffer, color);
        return buffer.toString();
    }

    private static void renderBacktraceJRuby(RubyStackTraceElement[] frames, StringBuilder buffer, boolean color) {
        int longestMethod = 0;
        for (RubyStackTraceElement frame : frames) {
            longestMethod = Math.max(longestMethod, frame.getMethodName().length());
        }
        boolean first2 = true;
        for (RubyStackTraceElement frame : frames) {
            if (color) {
                if (first2) {
                    buffer.append(FIRST_COLOR);
                } else if (frame.isBinding() || frame.getFileName().equals("(eval)")) {
                    buffer.append(EVAL_COLOR);
                } else if (frame.getFileName().indexOf(".java") != -1) {
                    buffer.append(KERNEL_COLOR);
                }
                first2 = false;
            }
            buffer.append("  ");
            String methodName = frame.getMethodName();
            for (int j = 0; j < longestMethod - methodName.length(); ++j) {
                buffer.append(' ');
            }
            buffer.append(methodName).append(" at ").append(frame.getFileName()).append(':').append(frame.getLineNumber());
            if (color) {
                buffer.append(CLEAR_COLOR);
            }
            buffer.append('\n');
        }
    }

    private static void renderBacktraceMRI(RubyStackTraceElement[] trace, StringBuilder buffer, boolean color) {
        for (int i2 = 0; i2 < trace.length; ++i2) {
            RubyStackTraceElement element = trace[i2];
            buffer.append(element.getFileName()).append(':').append(element.getLineNumber()).append(":in `").append(element.getMethodName()).append("'\n");
        }
    }

    public static IRubyObject generateMRIBacktrace(Ruby runtime, RubyStackTraceElement[] trace) {
        if (trace == null) {
            return runtime.getNil();
        }
        RubyArray traceArray = RubyArray.newArray(runtime);
        for (int i2 = 0; i2 < trace.length; ++i2) {
            RubyStackTraceElement element = trace[i2];
            RubyString str = RubyString.newString(runtime, element.getFileName() + ':' + element.getLineNumber() + ":in `" + element.getMethodName() + "'");
            traceArray.append(str);
        }
        return traceArray;
    }

    private static void printErrorPos(ThreadContext context, PrintStream errorStream) {
        if (context.getFile() != null && context.getFile().length() > 0) {
            if (context.getFrameName() != null) {
                errorStream.print(context.getFile() + ':' + context.getLine());
                errorStream.print(":in '" + context.getFrameName() + '\'');
            } else if (context.getLine() != 0) {
                errorStream.print(context.getFile() + ':' + context.getLine());
            } else {
                errorStream.print(context.getFile());
            }
        }
    }

    public static enum Format {
        MRI{

            @Override
            public String printBacktrace(RubyException exception2, boolean console) {
                return TraceType.printBacktraceMRI(exception2, console);
            }

            @Override
            public void renderBacktrace(RubyStackTraceElement[] elts, StringBuilder buffer, boolean color) {
                TraceType.renderBacktraceMRI(elts, buffer, color);
            }
        }
        ,
        JRUBY{

            @Override
            public String printBacktrace(RubyException exception2, boolean console) {
                return TraceType.printBacktraceJRuby(exception2, console);
            }

            @Override
            public void renderBacktrace(RubyStackTraceElement[] elts, StringBuilder buffer, boolean color) {
                TraceType.renderBacktraceJRuby(elts, buffer, color);
            }
        };


        public abstract String printBacktrace(RubyException var1, boolean var2);

        public abstract void renderBacktrace(RubyStackTraceElement[] var1, StringBuilder var2, boolean var3);
    }

    public static enum Gather {
        RAW{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, StackTraceElement[] javaTrace, boolean nativeException) {
                return new BacktraceData(javaTrace, new BacktraceElement[0], true, false, false);
            }
        }
        ,
        FULL{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, StackTraceElement[] javaTrace, boolean nativeException) {
                return new BacktraceData(javaTrace, context.createBacktrace2(0, nativeException), true, false, false);
            }
        }
        ,
        INTEGRATED{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, StackTraceElement[] javaTrace, boolean nativeException) {
                return new BacktraceData(javaTrace, context.createBacktrace2(0, nativeException), false, false, true);
            }
        }
        ,
        NORMAL{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, StackTraceElement[] javaTrace, boolean nativeException) {
                return new BacktraceData(javaTrace, context.createBacktrace2(0, nativeException), false, context.runtime.getInstanceConfig().getBacktraceMask(), false);
            }
        }
        ,
        CALLER{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, StackTraceElement[] javaTrace, boolean nativeException) {
                return new BacktraceData(javaTrace, context.createBacktrace2(0, nativeException), false, true, false);
            }
        };


        public BacktraceData getBacktraceData(ThreadContext context, boolean nativeException) {
            BacktraceData data2 = this.getBacktraceData(context, Thread.currentThread().getStackTrace(), nativeException);
            context.runtime.incrementBacktraceCount();
            if (RubyInstanceConfig.LOG_BACKTRACES) {
                TraceType.logBacktrace(data2.getBacktrace(context.runtime));
            }
            return data2;
        }

        public BacktraceData getIntegratedBacktraceData(ThreadContext context, StackTraceElement[] javaTrace) {
            Gather useGather = this;
            if (useGather == NORMAL) {
                useGather = INTEGRATED;
            }
            BacktraceData data2 = useGather.getBacktraceData(context, javaTrace, false);
            context.runtime.incrementBacktraceCount();
            if (RubyInstanceConfig.LOG_BACKTRACES) {
                TraceType.logBacktrace(data2.getBacktrace(context.runtime));
            }
            return data2;
        }

        public abstract BacktraceData getBacktraceData(ThreadContext var1, StackTraceElement[] var2, boolean var3);
    }
}

