/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.hadoop.rcfile;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.typesafe.config.Config;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.base.Validator;
import org.kitesdk.morphline.hadoop.rcfile.SingleStreamFileSystem;
import org.kitesdk.morphline.stdio.AbstractParser;

public final class ReadRCFileBuilder
implements CommandBuilder {
    public static final String OUTPUT_MEDIA_TYPE = "application/java-rc-file-record";
    public static final String RC_FILE_META_DATA = "RCFileMetaData";

    public Collection<String> getNames() {
        return Collections.singletonList("readRCFile");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadRCFile(this, config, parent, child, context);
    }

    private static final class ReadRCFile
    extends AbstractParser {
        private final List<RCFileColumn> columns = new ArrayList<RCFileColumn>();
        private final RCFileReadMode readMode;
        private final boolean includeMetaData;
        private final Configuration conf = new Configuration();
        private static final Object STREAM_PROTOCOL = "stream://";

        public ReadRCFile(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.includeMetaData = this.getConfigs().getBoolean(config, "includeMetaData", false);
            this.readMode = (RCFileReadMode)new Validator().validateEnum(config, this.getConfigs().getString(config, "readMode", RCFileReadMode.row.name()), RCFileReadMode.class, (Enum[])new RCFileReadMode[0]);
            for (Config columnConfig : this.getConfigs().getConfigList(config, "columns")) {
                this.columns.add(new RCFileColumn(columnConfig, this.conf));
            }
            this.validateArguments();
        }

        protected boolean doProcess(Record record, InputStream in) throws IOException {
            Path attachmentPath = this.getAttachmentPath(record);
            SingleStreamFileSystem fs = new SingleStreamFileSystem(in, attachmentPath);
            RCFile.Reader reader = null;
            try {
                SequenceFile.Metadata metadata;
                reader = new RCFile.Reader((FileSystem)fs, attachmentPath, this.conf);
                Record template = record.copy();
                ReadRCFile.removeAttachments((Record)template);
                template.put("_attachment_mimetype", (Object)ReadRCFileBuilder.OUTPUT_MEDIA_TYPE);
                if (this.includeMetaData && (metadata = reader.getMetadata()) != null) {
                    template.put(ReadRCFileBuilder.RC_FILE_META_DATA, (Object)metadata);
                }
                switch (this.readMode) {
                    case row: {
                        boolean bl = this.readRowWise(reader, template);
                        return bl;
                    }
                    case column: {
                        boolean bl = this.readColumnWise(reader, template);
                        return bl;
                    }
                }
                try {
                    throw new IllegalStateException();
                }
                catch (IOException e) {
                    throw new MorphlineRuntimeException("IOException while processing attachment " + attachmentPath.getName(), (Throwable)e);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }

        private Path getAttachmentPath(Record record) {
            String attachmentName = (String)record.getFirstValue("_attachment_name");
            if (attachmentName == null) {
                attachmentName = "UNKNOWN";
            }
            return new Path(STREAM_PROTOCOL + attachmentName);
        }

        private boolean readRowWise(RCFile.Reader reader, Record record) throws IOException {
            block4: {
                Record outputRecord;
                LongWritable rowID = new LongWritable();
                do {
                    boolean next;
                    try {
                        next = reader.next(rowID);
                    }
                    catch (EOFException ex) {
                        break block4;
                    }
                    if (!next) break block4;
                    this.incrementNumRecords();
                    outputRecord = record.copy();
                    BytesRefArrayWritable rowBatchBytes = new BytesRefArrayWritable();
                    rowBatchBytes.resetValid(this.columns.size());
                    reader.getCurrentRow(rowBatchBytes);
                    for (RCFileColumn rcColumn : this.columns) {
                        BytesRefWritable columnBytes = rowBatchBytes.get(rcColumn.getInputField());
                        outputRecord.put(rcColumn.getOutputField(), (Object)this.updateColumnValue(rcColumn, columnBytes));
                    }
                } while (this.getChild().process(outputRecord));
                return false;
            }
            return true;
        }

        private boolean readColumnWise(RCFile.Reader reader, Record record) throws IOException {
            block5: {
                block2: while (true) {
                    Record outputRecord;
                    boolean next;
                    try {
                        next = reader.nextBlock();
                    }
                    catch (EOFException ex) {
                        break block5;
                    }
                    if (!next) break block5;
                    Iterator<RCFileColumn> i$ = this.columns.iterator();
                    do {
                        if (!i$.hasNext()) continue block2;
                        RCFileColumn rcColumn = i$.next();
                        BytesRefArrayWritable rowBatchBytes = reader.getColumn(rcColumn.getInputField(), null);
                        ArrayList<Writable> rowValues = new ArrayList<Writable>(rowBatchBytes.size());
                        this.incrementNumRecords();
                        outputRecord = record.copy();
                        for (int rowIndex = 0; rowIndex < rowBatchBytes.size(); ++rowIndex) {
                            BytesRefWritable rowBytes = rowBatchBytes.get(rowIndex);
                            rowValues.add(this.updateColumnValue(rcColumn, rowBytes));
                        }
                        outputRecord.put(rcColumn.getOutputField(), rowValues);
                    } while (this.getChild().process(outputRecord));
                    break;
                }
                return false;
            }
            return true;
        }

        private Writable updateColumnValue(RCFileColumn column, BytesRefWritable bytesRef) throws IOException {
            Writable newColumnValue = column.newWritable();
            if (newColumnValue.getClass() == BytesRefWritable.class) {
                newColumnValue = bytesRef;
            } else {
                byte[] currentRowBytes = Arrays.copyOfRange(bytesRef.getData(), bytesRef.getStart(), bytesRef.getStart() + bytesRef.getLength());
                ByteArrayDataInput dataInput = ByteStreams.newDataInput((byte[])currentRowBytes);
                newColumnValue.readFields((DataInput)dataInput);
            }
            return newColumnValue;
        }

        private static final class RCFileColumn {
            private final int inputField;
            private final String outputField;
            private final Class<Writable> writableClass;
            private final Configuration conf;

            public RCFileColumn(Config columnConfig, Configuration conf) {
                this.conf = conf;
                Configs configs = new Configs();
                this.inputField = configs.getInt(columnConfig, "inputField");
                if (this.inputField < 0) {
                    throw new MorphlineCompilationException("Invalid column inputField specified: " + this.inputField, columnConfig);
                }
                this.outputField = configs.getString(columnConfig, "outputField");
                String writableClassString = configs.getString(columnConfig, "writableClass");
                if (writableClassString == null || writableClassString.isEmpty()) {
                    throw new MorphlineCompilationException("No writableClass specified for column " + this.outputField, columnConfig);
                }
                try {
                    Class<?> clazz = Class.forName(writableClassString);
                    if (!Writable.class.isAssignableFrom(clazz)) {
                        throw new MorphlineCompilationException("writableClass provided " + writableClassString + " for column " + this.outputField + " does not implement " + Writable.class.getName(), columnConfig);
                    }
                    this.writableClass = clazz;
                }
                catch (ClassNotFoundException e) {
                    throw new MorphlineCompilationException("Could not load class " + writableClassString + " definition", columnConfig, (Throwable)e);
                }
                configs.validateArguments(columnConfig);
            }

            public int getInputField() {
                return this.inputField;
            }

            public String getOutputField() {
                return this.outputField;
            }

            public Writable newWritable() {
                return (Writable)ReflectionUtils.newInstance(this.writableClass, (Configuration)this.conf);
            }
        }

        private static enum RCFileReadMode {
            column,
            row;

        }
    }
}

